/*
 * Decompiled with CFR 0.152.
 */
package com.possible_triangle.brazier.item;

import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.AbstractSpawner;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class LazySpawnEgg
extends Item {
    private final Supplier<EntityType<?>> type;
    private final int primaryColor;
    private final int secondaryColor;

    public LazySpawnEgg(Supplier<EntityType<? extends Entity>> type, int primaryColor, int secondaryColor) {
        super(new Item.Properties().func_200916_a(ItemGroup.field_78026_f));
        this.type = type;
        this.primaryColor = primaryColor;
        this.secondaryColor = secondaryColor;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        TileEntity tileentity;
        if (context.func_195991_k().func_201670_d()) {
            return ActionResultType.SUCCESS;
        }
        ServerWorld world = (ServerWorld)context.func_195991_k();
        ItemStack itemstack = context.func_195996_i();
        BlockPos pos = context.func_195995_a();
        Direction direction = context.func_196000_l();
        BlockState blockstate = world.func_180495_p(pos);
        if (blockstate.func_203425_a(Blocks.field_150474_ac) && (tileentity = world.func_175625_s(pos)) instanceof MobSpawnerTileEntity) {
            AbstractSpawner abstractspawner = ((MobSpawnerTileEntity)tileentity).func_145881_a();
            abstractspawner.func_200876_a(this.type.get());
            tileentity.func_70296_d();
            world.func_184138_a(pos, blockstate, blockstate, 3);
            itemstack.func_190918_g(1);
            return ActionResultType.CONSUME;
        }
        BlockPos spawnPos = blockstate.func_196952_d((IBlockReader)world, pos).func_197766_b() ? pos : pos.func_177972_a(direction);
        if (this.type.get().func_220331_a(world, itemstack, context.func_195999_j(), spawnPos, SpawnReason.SPAWN_EGG, true, !Objects.equals(pos, spawnPos) && direction == Direction.UP) != null) {
            itemstack.func_190918_g(1);
        }
        return ActionResultType.CONSUME;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack held = player.func_184586_b(hand);
        BlockRayTraceResult raytrace = LazySpawnEgg.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.SOURCE_ONLY);
        if (raytrace.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return ActionResult.func_226250_c_((Object)held);
        }
        if (world.field_72995_K) {
            return ActionResult.func_226248_a_((Object)held);
        }
        BlockPos blockpos = raytrace.func_216350_a();
        if (!(world.func_180495_p(blockpos).func_177230_c() instanceof FlowingFluidBlock)) {
            return ActionResult.func_226250_c_((Object)held);
        }
        if (world.func_175660_a(player, blockpos) && player.func_175151_a(blockpos, raytrace.func_216354_b(), held)) {
            if (this.type.get().func_220331_a((ServerWorld)world, held, player, blockpos, SpawnReason.SPAWN_EGG, false, false) == null) {
                return ActionResult.func_226250_c_((Object)held);
            }
            if (!player.field_71075_bZ.field_75098_d) {
                held.func_190918_g(1);
            }
            player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
            return ActionResult.func_226249_b_((Object)held);
        }
        return ActionResult.func_226251_d_((Object)held);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getColor(int tintIndex) {
        return tintIndex == 0 ? this.primaryColor : this.secondaryColor;
    }
}

