/*
 * Decompiled with CFR 0.152.
 */
package mirsario.cameraoverhaul.fabric.mixins;

import java.util.List;
import java.util.Set;
import mirsario.cameraoverhaul.common.CameraOverhaul;
import mirsario.cameraoverhaul.fabric.VersionUtils;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class MixinPlugin
implements IMixinConfigPlugin {
    public static String BaseMixinPath = "mirsario.cameraoverhaul.fabric.mixins.";

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        boolean isLegacy;
        if (!mixinClassName.startsWith(BaseMixinPath)) {
            return true;
        }
        String relativeName = mixinClassName.substring(BaseMixinPath.length());
        if (relativeName.startsWith("legacy.")) {
            isLegacy = true;
        } else if (relativeName.startsWith("modern.")) {
            isLegacy = false;
        } else {
            return true;
        }
        boolean legacyGameVersion = VersionUtils.MinecraftVersionMatches("<1.15");
        boolean result = legacyGameVersion == isLegacy;
        CameraOverhaul.Logger.info((result ? "Using" : "Skipping") + " " + (isLegacy ? "legacy" : "modern") + " mixin '" + mixinClassName + "'.");
        return result;
    }

    public void onLoad(String mixinPackage) {
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public List<String> getMixins() {
        return null;
    }
}

