/*
 * Decompiled with CFR 0.152.
 */
package mirsario.cameraoverhaul.fabric.mixins;

import java.util.List;
import java.util.Set;
import mirsario.cameraoverhaul.common.CameraOverhaul;
import mirsario.cameraoverhaul.fabric.mixins.VersionPredicateParser;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.VersionParsingException;
import net.fabricmc.loader.api.metadata.ModMetadata;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class MixinPlugin
implements IMixinConfigPlugin {
    public static String BaseMixinPath = "mirsario.cameraoverhaul.fabric.mixins.";

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        boolean legacyGameVersion;
        boolean isLegacy;
        if (!mixinClassName.startsWith(BaseMixinPath)) {
            return true;
        }
        String relativeName = mixinClassName.substring(BaseMixinPath.length());
        if (relativeName.startsWith("legacy.")) {
            isLegacy = true;
        } else if (relativeName.startsWith("modern.")) {
            isLegacy = false;
        } else {
            return true;
        }
        ModMetadata metadata = ((ModContainer)FabricLoader.getInstance().getModContainer("minecraft").get()).getMetadata();
        try {
            legacyGameVersion = VersionPredicateParser.matches(metadata.getVersion(), "<1.15");
        }
        catch (VersionParsingException e) {
            e.printStackTrace();
            legacyGameVersion = true;
        }
        boolean result = legacyGameVersion == isLegacy;
        CameraOverhaul.Logger.info((result ? "Using" : "Skipping") + " " + (isLegacy ? "legacy" : "modern") + " mixin '" + mixinClassName + "'.");
        return result;
    }

    public void onLoad(String mixinPackage) {
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public List<String> getMixins() {
        return null;
    }
}

