/*
 * Decompiled with CFR 0.152.
 */
package mirsario.cameraoverhaul.common.systems;

import mirsario.cameraoverhaul.common.CameraOverhaul;
import mirsario.cameraoverhaul.common.configuration.ConfigData;
import mirsario.cameraoverhaul.core.callbacks.CameraUpdateCallback;
import mirsario.cameraoverhaul.core.structures.Transform;
import mirsario.cameraoverhaul.core.utils.MathUtils;
import mirsario.cameraoverhaul.core.utils.Vec2fUtils;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_4184;

public final class CameraSystem
implements CameraUpdateCallback {
    private static double prevForwardVelocityPitchOffset;
    private static double prevVerticalVelocityPitchOffset;
    private static double prevStrafingRollOffset;
    private static double prevCameraYaw;
    private static double yawDeltaRollOffset;
    private static double yawDeltaRollTargetOffset;
    private static double lerpSpeed;

    public CameraSystem() {
        CameraUpdateCallback.EVENT.Register(this);
        CameraOverhaul.Logger.info("CameraOverhaul - CameraSystem is ready.");
    }

    @Override
    public Transform OnCameraUpdate(class_4184 camera, Transform cameraTransform, float deltaTime) {
        ConfigData config = CameraOverhaul.instance.config;
        if (!config.enabled) {
            return cameraTransform;
        }
        class_243 velocity = camera.method_19331().method_18798();
        class_241 relativeXZVelocity = Vec2fUtils.Rotate(new class_241((float)velocity.field_1352, (float)velocity.field_1350), 360.0f - (float)cameraTransform.eulerRot.field_1351);
        this.VerticalVelocityPitchOffset(cameraTransform, velocity, relativeXZVelocity, deltaTime, config.verticalVelocityPitchFactor);
        this.ForwardVelocityPitchOffset(cameraTransform, velocity, relativeXZVelocity, deltaTime, config.forwardVelocityPitchFactor);
        this.YawDeltaRollOffset(cameraTransform, velocity, relativeXZVelocity, deltaTime, config.yawDeltaRollFactor);
        this.StrafingRollOffset(cameraTransform, velocity, relativeXZVelocity, deltaTime, config.strafingRollFactor);
        prevCameraYaw = cameraTransform.eulerRot.field_1351;
        return cameraTransform;
    }

    private void VerticalVelocityPitchOffset(Transform transform, class_243 velocity, class_241 relativeXZVelocity, double deltaTime, float intensity) {
        double verticalVelocityPitchOffset = velocity.field_1351 * 2.75;
        if (velocity.field_1351 < 0.0) {
            verticalVelocityPitchOffset *= 2.25;
        }
        prevVerticalVelocityPitchOffset = verticalVelocityPitchOffset = MathUtils.Lerp(prevVerticalVelocityPitchOffset, verticalVelocityPitchOffset, deltaTime * lerpSpeed);
        transform.eulerRot = transform.eulerRot.method_1031(verticalVelocityPitchOffset * (double)intensity, 0.0, 0.0);
    }

    private void ForwardVelocityPitchOffset(Transform transform, class_243 velocity, class_241 relativeXZVelocity, double deltaTime, float intensity) {
        double forwardVelocityPitchOffset = (double)relativeXZVelocity.field_1342 * 5.0;
        prevForwardVelocityPitchOffset = forwardVelocityPitchOffset = MathUtils.Lerp(prevForwardVelocityPitchOffset, forwardVelocityPitchOffset, deltaTime * lerpSpeed);
        transform.eulerRot = transform.eulerRot.method_1031(forwardVelocityPitchOffset * (double)intensity, 0.0, 0.0);
    }

    private void YawDeltaRollOffset(Transform transform, class_243 velocity, class_241 relativeXZVelocity, double deltaTime, float intensity) {
        double yawDelta = prevCameraYaw - transform.eulerRot.field_1351;
        if (yawDelta > 180.0) {
            yawDelta = 360.0 - yawDelta;
        } else if (yawDelta < -180.0) {
            yawDelta = -360.0 - yawDelta;
        }
        yawDeltaRollOffset = MathUtils.Lerp(yawDeltaRollOffset, yawDeltaRollTargetOffset += yawDelta * 0.07, deltaTime * lerpSpeed * 10.0);
        transform.eulerRot = transform.eulerRot.method_1031(0.0, 0.0, yawDeltaRollOffset * (double)intensity);
        yawDeltaRollTargetOffset = MathUtils.Lerp(yawDeltaRollTargetOffset, 0.0, deltaTime * 0.35);
    }

    private void StrafingRollOffset(Transform transform, class_243 velocity, class_241 relativeXZVelocity, double deltaTime, float intensity) {
        double strafingRollOffset = (double)(-relativeXZVelocity.field_1343) * 15.0;
        prevStrafingRollOffset = strafingRollOffset = MathUtils.Lerp(prevStrafingRollOffset, strafingRollOffset, deltaTime * lerpSpeed);
        transform.eulerRot = transform.eulerRot.method_1031(0.0, 0.0, strafingRollOffset * (double)intensity);
    }

    static {
        lerpSpeed = 1.0;
    }
}

