/*
 * Decompiled with CFR 0.152.
 */
package mirsario.cameraoverhaul.core.configuration;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import mirsario.cameraoverhaul.core.configuration.BaseConfigData;

public final class Configuration {
    private static Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public static <T extends BaseConfigData> T LoadConfig(Class<T> tClass, String configName, int configVersion) {
        BaseConfigData configData = null;
        try {
            Path configDir = Paths.get("", "config", configName + ".json");
            boolean saveConfig = false;
            if (Files.exists(configDir, new LinkOption[0])) {
                FileReader fileReader = new FileReader(configDir.toFile());
                configData = (BaseConfigData)gson.fromJson((Reader)fileReader, tClass);
                if (configData.configVersion < configVersion) {
                    saveConfig = true;
                }
            } else {
                try {
                    configData = (BaseConfigData)tClass.newInstance();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                saveConfig = true;
            }
            if (saveConfig) {
                Paths.get("", "config").toFile().mkdirs();
                configData.configVersion = configVersion;
                BufferedWriter writer = new BufferedWriter(new FileWriter(configDir.toFile()));
                writer.write(gson.toJson((Object)configData));
                writer.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (T)configData;
    }
}

