/*
 * Decompiled with CFR 0.152.
 */
package capsule.command;

import capsule.Config;
import capsule.StructureSaver;
import capsule.helpers.Capsule;
import capsule.helpers.Files;
import capsule.helpers.Spacial;
import capsule.items.CapsuleItem;
import capsule.loot.CapsuleLootEntry;
import capsule.loot.CapsuleLootTableHook;
import capsule.structure.CapsuleTemplate;
import capsule.structure.CapsuleTemplateManager;
import com.google.common.base.Joiner;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraft.world.storage.loot.LootContext;
import org.apache.commons.lang3.tuple.Pair;

public class CapsuleCommand
extends CommandBase {
    public static List<ICommandSender> sentUsageURL = new ArrayList<ICommandSender>();
    public static final String[] COMMAND_LIST = new String[]{"giveEmpty", "giveLinked", "giveBlueprint", "exportHeldItem", "exportSeenBlock", "fromExistingReward", "fromHeldCapsule", "fromStructure", "giveRandomLoot", "reloadLootList", "reloadWhitelist", "setAuthor", "setBaseColor", "setMaterialColor", "downloadTemplate"};
    public static final String[] COMMAND_HELP = new String[]{"giveEmpty [size] [overpowered]", "giveLinked <rewardName> [playerName]", "giveBlueprint <rewardName> [playerName]", "exportHeldItem", "exportSeenBlock", "fromExistingReward <rewardName> [playerName]", "fromHeldCapsule [outputName]", "fromStructure <structureName> [playerName]", "giveRandomLoot [playerName]", "reloadLootList", "reloadWhitelist", "setAuthor <authorName>", "setBaseColor <color>", "setMaterialColor <color>", "downloadTemplate"};

    public String func_71517_b() {
        return "capsule";
    }

    public int func_82362_a() {
        return 2;
    }

    public String func_71518_a(ICommandSender sender) {
        if (!sentUsageURL.contains(sender)) {
            TextComponentString msg = new TextComponentString("see Capsule commands usages at " + TextFormatting.UNDERLINE + "https://github.com/Lythom/capsule/wiki/Commands");
            msg.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://github.com/Lythom/capsule/wiki/Commands"));
            sender.func_145747_a((ITextComponent)msg);
            sentUsageURL.add(sender);
        }
        return "Capsule commands list:\n/capsule " + Joiner.on((String)"\n/capsule ").join((Object[])COMMAND_HELP);
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        EntityPlayerMP player = null;
        switch (args.length) {
            case 1: {
                return CapsuleCommand.func_71530_a((String[])args, (String[])COMMAND_LIST);
            }
            case 2: {
                switch (args[0]) {
                    case "giveRandomLoot": {
                        return CapsuleCommand.func_71530_a((String[])args, (String[])server.func_71213_z());
                    }
                    case "setBaseColor": 
                    case "setMaterialColor": {
                        return CapsuleCommand.func_71530_a((String[])args, (String[])CapsuleLootEntry.COLOR_PALETTE);
                    }
                    case "fromStructure": {
                        try {
                            player = CapsuleCommand.func_71521_c((ICommandSender)sender);
                            String[] structuresList = new File(player.func_71121_q().func_72860_G().func_75765_b(), "structures").list();
                            if (structuresList == null) {
                                return new ArrayList<String>();
                            }
                            return CapsuleCommand.func_71530_a((String[])args, (String[])structuresList);
                        }
                        catch (PlayerNotFoundException structuresList) {
                            break;
                        }
                    }
                    case "fromExistingReward": 
                    case "giveLinked": 
                    case "giveBlueprint": {
                        String[] rewardsList = new File(Config.rewardTemplatesPath).list();
                        if (rewardsList == null) {
                            return new ArrayList<String>();
                        }
                        return CapsuleCommand.func_71530_a((String[])args, (String[])rewardsList);
                    }
                    case "downloadTemplate": {
                        return Collections.emptyList();
                    }
                }
            }
            case 3: {
                switch (args[0]) {
                    case "fromStructure": 
                    case "fromExistingReward": 
                    case "giveLinked": 
                    case "giveBlueprint": {
                        return CapsuleCommand.func_71530_a((String[])args, (String[])server.func_71213_z());
                    }
                }
            }
        }
        return Collections.emptyList();
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 1 || "help".equalsIgnoreCase(args[0])) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        EntityPlayerMP player = null;
        if (sender instanceof EntityPlayerMP) {
            player = (EntityPlayerMP)sender;
        }
        if ("giveEmpty".equalsIgnoreCase(args[0])) {
            this.executeGiveEmpty(args, player);
        } else if ("giveLinked".equalsIgnoreCase(args[0])) {
            this.executeGiveLinked(server, sender, args, player);
        } else if ("giveBlueprint".equalsIgnoreCase(args[0])) {
            this.executeGiveBlueprint(server, sender, args, player);
        } else if ("exportHeldItem".equalsIgnoreCase(args[0])) {
            this.executeExportHeldItem(sender, args, player);
        } else if ("exportSeenBlock".equalsIgnoreCase(args[0])) {
            this.executeExportSeenBlock(server, sender, args, player);
        } else if ("setAuthor".equalsIgnoreCase(args[0])) {
            this.executeSetAuthor(server, sender, args, player);
        } else if ("setBaseColor".equalsIgnoreCase(args[0])) {
            this.executeSetBaseColor(sender, args, player);
        } else if ("setMaterialColor".equalsIgnoreCase(args[0])) {
            this.executeSetMaterialColor(sender, args, player);
        } else if ("fromHeldCapsule".equalsIgnoreCase(args[0])) {
            this.executeFromHeldCapsule(server, sender, args, player);
        } else if ("fromStructure".equalsIgnoreCase(args[0])) {
            this.executeFromStructure(server, sender, args, player);
        } else if ("fromExistingReward".equalsIgnoreCase(args[0])) {
            this.executeFromExistingReward(server, sender, args, player);
        } else if ("giveRandomLoot".equalsIgnoreCase(args[0])) {
            this.executeGiveRandomLoot(server, sender, args, player);
        } else if ("reloadLootList".equalsIgnoreCase(args[0])) {
            if (args.length != 1) {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
            Files.populateAndLoadLootList(Config.configDir, Config.lootTemplatesPaths, Config.lootTemplatesData);
        } else if ("reloadWhitelist".equalsIgnoreCase(args[0])) {
            if (args.length != 1) {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
            Files.populateAndLoadLootList(Config.configDir, Config.lootTemplatesPaths, Config.lootTemplatesData);
            Config.starterTemplatesList = Files.populateStarters(Config.configDir, Config.starterTemplatesPath);
            Config.blueprintWhitelist = Files.populateWhitelistConfig(Config.configDir);
        } else if (!"downloadTemplate".equalsIgnoreCase(args[0])) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
    }

    private void executeGiveEmpty(String[] args, EntityPlayerMP player) {
        if (player != null) {
            ItemStack capsule = Capsule.newEmptyCapsuleItemStack(0xFFFFFF, 0xFFFFFF, args.length >= 2 ? Integer.decode(args[1]) : 3, args.length >= 3 && Boolean.valueOf(args[2]) != false, null, null);
            this.giveCapsule(capsule, (EntityPlayer)player);
        }
    }

    private void executeGiveLinked(MinecraftServer server, ICommandSender sender, String[] args, EntityPlayerMP p) throws CommandException {
        StructureAndPlayerArgs structureAndPlayerArgs = new StructureAndPlayerArgs().invoke(server, sender, args, p);
        EntityPlayerMP player = structureAndPlayerArgs.getTargetedPlayer();
        String srcStructureName = structureAndPlayerArgs.getStructureName();
        if (player != null && !StringUtils.func_151246_b((String)srcStructureName) && player.func_130014_f_() instanceof WorldServer) {
            ItemStack capsule = Capsule.createLinkedCapsuleFromReward(Config.getRewardPathFromName(srcStructureName), player);
            if (!capsule.func_190926_b()) {
                this.giveCapsule(capsule, (EntityPlayer)player);
            } else {
                throw new CommandException("Reward Capsule \"%s\" not found ", new Object[]{srcStructureName});
            }
        }
    }

    private void executeGiveBlueprint(MinecraftServer server, ICommandSender sender, String[] args, EntityPlayerMP p) throws CommandException {
        StructureAndPlayerArgs structureAndPlayerArgs = new StructureAndPlayerArgs().invoke(server, sender, args, p);
        EntityPlayerMP player = structureAndPlayerArgs.getTargetedPlayer();
        String srcStructureName = structureAndPlayerArgs.getStructureName();
        if (player != null && !StringUtils.func_151246_b((String)srcStructureName) && player.func_130014_f_() instanceof WorldServer) {
            CapsuleTemplate srcTemplate = Capsule.getRewardTemplateIfExists(Config.getRewardPathFromName(srcStructureName), server);
            if (srcTemplate != null) {
                int size = Math.max(srcTemplate.getSize().func_177958_n(), Math.max(srcTemplate.getSize().func_177956_o(), srcTemplate.getSize().func_177952_p()));
                if (size % 2 == 0) {
                    ++size;
                }
                ItemStack capsule = Capsule.newEmptyCapsuleItemStack(3949738, 0xFFFFFF, size, false, Capsule.labelFromPath(srcStructureName), 0);
                CapsuleItem.setState(capsule, 3);
                CapsuleItem.setBlueprint(capsule);
                String destTemplate = StructureSaver.createBlueprintTemplate(Config.getRewardPathFromName(srcStructureName), capsule, player.func_71121_q(), (EntityPlayer)player);
                CapsuleItem.setStructureName(capsule, destTemplate);
                this.giveCapsule(capsule, (EntityPlayer)player);
            } else {
                throw new CommandException("Reward Capsule \"%s\" not found ", new Object[]{srcStructureName});
            }
        }
    }

    private void executeGiveRandomLoot(MinecraftServer server, ICommandSender sender, String[] args, EntityPlayerMP player) throws CommandException {
        if (args.length != 1 && args.length != 2) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        if (args.length == 2) {
            player = CommandBase.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[1]);
        }
        if (player != null) {
            LootContext.Builder lootcontext$builder = new LootContext.Builder(player.func_71121_q());
            ArrayList loots = new ArrayList();
            CapsuleLootTableHook.capsulePool.func_186449_b(loots, new Random(), lootcontext$builder.func_186471_a());
            if (loots.size() <= 0) {
                player.func_145747_a((ITextComponent)new TextComponentString("No loot this time !"));
            } else {
                for (ItemStack loot : loots) {
                    this.giveCapsule(loot, (EntityPlayer)player);
                }
            }
        }
    }

    private void executeFromExistingReward(MinecraftServer server, ICommandSender sender, String[] args, EntityPlayerMP p) throws CommandException {
        StructureAndPlayerArgs structureAndPlayerArgs = new StructureAndPlayerArgs().invoke(server, sender, args, p);
        EntityPlayerMP player = structureAndPlayerArgs.getTargetedPlayer();
        String structureName = structureAndPlayerArgs.getStructureName();
        if (player != null && !StringUtils.func_151246_b((String)structureName) && player.func_130014_f_() instanceof WorldServer) {
            String structurePath = Config.getRewardPathFromName(structureName);
            CapsuleTemplateManager templatemanager = StructureSaver.getRewardManager(server);
            CapsuleTemplate template = templatemanager.get(server, new ResourceLocation(structurePath));
            if (template != null) {
                int size = Math.max(template.getSize().func_177958_n(), Math.max(template.getSize().func_177956_o(), template.getSize().func_177952_p()));
                if (size % 2 == 0) {
                    ++size;
                }
                ItemStack capsule = Capsule.newRewardCapsuleItemStack(structurePath, CapsuleLootEntry.getRandomColor(), CapsuleLootEntry.getRandomColor(), size, Capsule.labelFromPath(structureName), template.getAuthor());
                CapsuleItem.setCanRotate(capsule, template.canRotate());
                this.giveCapsule(capsule, (EntityPlayer)player);
            } else {
                throw new CommandException("Reward Capsule \"%s\" not found ", new Object[]{structureName});
            }
        }
    }

    private void executeFromStructure(MinecraftServer server, ICommandSender sender, String[] args, EntityPlayerMP p) throws CommandException {
        StructureAndPlayerArgs structureAndPlayerArgs = new StructureAndPlayerArgs().invoke(server, sender, args, p);
        EntityPlayerMP player = structureAndPlayerArgs.getTargetedPlayer();
        String srcStructureName = structureAndPlayerArgs.getStructureName();
        if (player != null && !StringUtils.func_151246_b((String)srcStructureName) && player.func_130014_f_() instanceof WorldServer) {
            TemplateManager templatemanager = player.func_71121_q().func_184163_y();
            Template template = templatemanager.func_189942_b(server, new ResourceLocation(srcStructureName));
            if (template != null) {
                int size = Math.max(template.func_186259_a().func_177958_n(), Math.max(template.func_186259_a().func_177956_o(), template.func_186259_a().func_177952_p()));
                if (size % 2 == 0) {
                    ++size;
                }
                NBTTagCompound data = new NBTTagCompound();
                template.func_189552_a(data);
                ResourceLocation destinationLocation = new ResourceLocation(Config.rewardTemplatesPath + "/" + srcStructureName);
                CapsuleTemplateManager destManager = StructureSaver.getRewardManager(server);
                CapsuleTemplate destTemplate = destManager.getTemplate(server, destinationLocation);
                destTemplate.read(data);
                destManager.writeTemplate(server, destinationLocation);
                ItemStack capsule = Capsule.newRewardCapsuleItemStack(destinationLocation.toString(), CapsuleLootEntry.getRandomColor(), CapsuleLootEntry.getRandomColor(), size, srcStructureName, template.func_186261_b());
                CapsuleItem.setCanRotate(capsule, destTemplate.canRotate());
                this.giveCapsule(capsule, (EntityPlayer)player);
            } else {
                throw new CommandException("Structure \"%s\" not found ", new Object[]{srcStructureName});
            }
        }
    }

    private void executeFromHeldCapsule(MinecraftServer server, ICommandSender sender, String[] args, EntityPlayerMP player) throws WrongUsageException {
        ItemStack heldItem;
        if (args.length != 1 && args.length != 2) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        if (player != null && (heldItem = player.func_184614_ca()).func_77973_b() instanceof CapsuleItem && heldItem.func_77942_o()) {
            String outputName = args.length == 1 ? heldItem.func_77978_p().func_74779_i("label") : args[1];
            if (StringUtils.func_151246_b((String)outputName)) {
                throw new WrongUsageException("/capsule fromHeldCapsule [outputName]. Please label the held capsule or provide an output name to be used for output template.", new Object[0]);
            }
            String destinationTemplateLocation = Config.getRewardPathFromName(outputName.toLowerCase().replace(" ", "_").replace(":", "-"));
            boolean created = StructureSaver.copyFromCapsuleTemplate(heldItem, destinationTemplateLocation, StructureSaver.getRewardManager(server), player.func_71121_q(), false, null);
            if (!created) {
                player.func_145747_a((ITextComponent)new TextComponentString("Could not duplicate the capsule template. Either the source template don't exist or the destination folder dont exist."));
                return;
            }
            ItemStack capsule = Capsule.newRewardCapsuleItemStack(destinationTemplateLocation, CapsuleItem.getBaseColor(heldItem), CapsuleItem.getMaterialColor(heldItem), CapsuleItem.getSize(heldItem), outputName, CapsuleItem.getAuthor(heldItem));
            CapsuleItem.setCanRotate(capsule, CapsuleItem.canRotate(heldItem));
            this.giveCapsule(capsule, (EntityPlayer)player);
        }
    }

    private void executeSetMaterialColor(ICommandSender sender, String[] args, EntityPlayerMP player) throws WrongUsageException {
        ItemStack heldItem;
        if (args.length != 2) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        int color = 0;
        try {
            color = Integer.decode(args[1]);
        }
        catch (NumberFormatException e) {
            throw new WrongUsageException("Color parameter must be a valid integer. ie. 0xCC3D2E or 123456", new Object[0]);
        }
        if (player != null && (heldItem = player.func_184614_ca()).func_77973_b() instanceof CapsuleItem) {
            CapsuleItem.setMaterialColor(heldItem, color);
        }
    }

    private void executeSetBaseColor(ICommandSender sender, String[] args, EntityPlayerMP player) throws WrongUsageException {
        ItemStack heldItem;
        if (args.length != 2) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        int color = 0;
        try {
            color = Integer.decode(args[1]);
        }
        catch (NumberFormatException e) {
            throw new WrongUsageException("Color parameter must be a valid integer. ie. 0xCC3D2E or 123456", new Object[0]);
        }
        if (player != null && (heldItem = player.func_184614_ca()).func_77973_b() instanceof CapsuleItem) {
            CapsuleItem.setBaseColor(heldItem, color);
        }
    }

    private void executeSetAuthor(MinecraftServer server, ICommandSender sender, String[] args, EntityPlayerMP player) throws WrongUsageException {
        ItemStack heldItem;
        if (args.length != 1 && args.length != 2) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        if (player != null && !(heldItem = player.func_184614_ca()).func_190926_b() && heldItem.func_77973_b() instanceof CapsuleItem && heldItem.func_77942_o()) {
            if (args.length == 2) {
                String author = args[1];
                heldItem.func_77978_p().func_74778_a("author", args[1]);
                Pair<CapsuleTemplateManager, CapsuleTemplate> templatepair = StructureSaver.getTemplate(heldItem, player.func_71121_q());
                CapsuleTemplate template = (CapsuleTemplate)templatepair.getRight();
                CapsuleTemplateManager templatemanager = (CapsuleTemplateManager)templatepair.getLeft();
                if (template != null && templatemanager != null) {
                    template.setAuthor(author);
                    templatemanager.writeTemplate(server, new ResourceLocation(CapsuleItem.getStructureName(heldItem)));
                }
            } else {
                heldItem.func_77978_p().func_82580_o("author");
                Pair<CapsuleTemplateManager, CapsuleTemplate> templatepair = StructureSaver.getTemplate(heldItem, player.func_71121_q());
                CapsuleTemplate template = (CapsuleTemplate)templatepair.getRight();
                CapsuleTemplateManager templatemanager = (CapsuleTemplateManager)templatepair.getLeft();
                if (template != null && templatemanager != null) {
                    template.setAuthor("?");
                    templatemanager.writeTemplate(server, new ResourceLocation(CapsuleItem.getStructureName(heldItem)));
                }
            }
        }
    }

    private void executeExportSeenBlock(MinecraftServer server, ICommandSender sender, String[] args, EntityPlayerMP player) throws WrongUsageException {
        if (args.length != 1) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        if (player != null) {
            if (!server.func_71262_S()) {
                RayTraceResult rtc = Spacial.clientRayTracePreview((EntityPlayer)player, Minecraft.func_71410_x().func_184121_ak(), 50);
                if (rtc != null && rtc.field_72313_a == RayTraceResult.Type.BLOCK) {
                    BlockPos position = rtc.func_178782_a();
                    IBlockState state = player.func_71121_q().func_180495_p(position);
                    TileEntity tileentity = player.func_71121_q().func_175625_s(position);
                    String command = "/give @p " + state.func_177230_c().getRegistryName().toString() + " 1 " + state.func_177230_c().func_176201_c(state);
                    if (tileentity != null) {
                        command = command + " {BlockEntityTag:" + tileentity.serializeNBT().toString() + "}";
                    }
                    TextComponentString msg = new TextComponentString(command);
                    msg.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("Copy/Paste from client log (click to open)")));
                    msg.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_FILE, "logs/latest.log"));
                    player.func_145747_a((ITextComponent)msg);
                }
            } else {
                player.func_145747_a((ITextComponent)new TextComponentString("This command only works on an integrated server, not on an dedicated one"));
            }
        }
    }

    private void executeExportHeldItem(ICommandSender sender, String[] args, EntityPlayerMP player) throws WrongUsageException {
        ItemStack heldItem;
        if (args.length != 1) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        if (player != null && !(heldItem = player.func_184614_ca()).func_190926_b()) {
            String command = "/give @p " + heldItem.func_77973_b().getRegistryName().toString() + " 1 " + heldItem.func_77952_i();
            if (heldItem.func_77942_o()) {
                command = command + " " + heldItem.func_77978_p().toString();
            }
            TextComponentString msg = new TextComponentString(command);
            msg.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("Copy/Paste from client log (click to open)")));
            msg.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_FILE, "logs/latest.log"));
            player.func_145747_a((ITextComponent)msg);
        }
    }

    private void giveCapsule(ItemStack capsule, EntityPlayer player) {
        EntityItem entity = new EntityItem(player.func_130014_f_(), (double)player.func_180425_c().func_177958_n(), (double)player.func_180425_c().func_177956_o(), (double)player.func_180425_c().func_177952_p(), capsule);
        entity.func_174868_q();
        entity.func_70100_b_(player);
    }

    private class StructureAndPlayerArgs {
        private EntityPlayerMP targetedPlayer;
        private String structureName;

        private StructureAndPlayerArgs() {
        }

        public EntityPlayerMP getTargetedPlayer() {
            return this.targetedPlayer;
        }

        public String getStructureName() {
            return this.structureName;
        }

        public StructureAndPlayerArgs invoke(MinecraftServer server, ICommandSender sender, String[] args, EntityPlayerMP senderPlayer) throws CommandException {
            if (args.length == 1) {
                throw new WrongUsageException(CapsuleCommand.this.func_71518_a(sender), new Object[0]);
            }
            this.targetedPlayer = senderPlayer;
            int finalArgsCount = 0;
            if (args.length > 2) {
                EntityPlayerMP p = null;
                try {
                    p = CommandBase.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[args.length - 1]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (p != null) {
                    this.targetedPlayer = p;
                    finalArgsCount = 1;
                }
            }
            StringBuilder structureNameB = new StringBuilder();
            for (int i = 1; i < args.length - finalArgsCount; ++i) {
                structureNameB.append(args[i]);
                if (i >= args.length - finalArgsCount - 1) continue;
                structureNameB.append(" ");
            }
            this.structureName = structureNameB.toString().replaceAll(".nbt", "").replaceAll(".schematic", "");
            return this;
        }
    }
}

