/*
 * Decompiled with CFR 0.152.
 */
package capsule.helpers;

import capsule.Config;
import capsule.StructureSaver;
import capsule.helpers.Capsule;
import capsule.helpers.Files;
import capsule.recipes.PrefabsBlueprintCapsuleRecipe;
import capsule.structure.CapsuleTemplate;
import capsule.structure.CapsuleTemplateManager;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockDoubleStoneSlab;
import net.minecraft.block.BlockDoubleStoneSlabNew;
import net.minecraft.block.BlockDoubleWoodSlab;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockPistonExtension;
import net.minecraft.block.BlockPistonMoving;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Blueprint {
    protected static final Logger LOGGER = LogManager.getLogger(Blueprint.class);

    public static ItemStack getBlockItemCost(Template.BlockInfo blockInfo) {
        IBlockState state = blockInfo.field_186243_b;
        Block block = state.func_177230_c();
        NBTTagCompound blockNBT = blockInfo.field_186244_c;
        try {
            if (block instanceof BlockDoor) {
                if (state.func_177229_b((IProperty)BlockDoor.field_176523_O) == BlockDoor.EnumDoorHalf.LOWER) {
                    return block.func_185473_a(null, null, state);
                }
                return ItemStack.field_190927_a;
            }
            if (block instanceof BlockBed) {
                if (state.func_177229_b((IProperty)BlockBed.field_176472_a) == BlockBed.EnumPartType.HEAD) {
                    return new ItemStack(Items.field_151104_aV, 1, blockInfo.field_186244_c.func_74762_e("color"));
                }
                return ItemStack.field_190927_a;
            }
            if (block instanceof BlockDoublePlant) {
                BlockDoublePlant.EnumPlantType type = (BlockDoublePlant.EnumPlantType)state.func_177229_b((IProperty)BlockDoublePlant.field_176493_a);
                if (type == BlockDoublePlant.EnumPlantType.FERN) {
                    return new ItemStack((Block)Blocks.field_150329_H, 2, BlockTallGrass.EnumType.FERN.func_177044_a());
                }
                if (type == BlockDoublePlant.EnumPlantType.GRASS) {
                    return new ItemStack((Block)Blocks.field_150329_H, 2, BlockTallGrass.EnumType.GRASS.func_177044_a());
                }
                return ItemStack.field_190927_a;
            }
            if (block instanceof BlockDoubleStoneSlab || block instanceof BlockDoubleStoneSlabNew || block instanceof BlockDoubleWoodSlab) {
                ItemStack stack = block.func_185473_a(null, null, state);
                stack.func_190920_e(2);
                return stack;
            }
            if (block instanceof BlockFarmland) {
                return new ItemStack(Blocks.field_150346_d);
            }
            if (block instanceof BlockLiquid) {
                if (Blueprint.isLiquidSource(state, block)) {
                    ItemStack item = FluidUtil.getFilledBucket((FluidStack)new FluidStack(FluidRegistry.lookupFluidForBlock((Block)block), 1000));
                    return item.func_190926_b() ? null : item;
                }
                return ItemStack.field_190927_a;
            }
            if (block instanceof BlockPistonExtension || block instanceof BlockPistonMoving) {
                return ItemStack.field_190927_a;
            }
            ItemStack item = block.func_185473_a(null, null, state);
            if (blockNBT != null) {
                if (blockNBT.func_74764_b("dummy") && blockNBT.func_74767_n("dummy")) {
                    return ItemStack.field_190927_a;
                }
                NBTTagCompound itemNBT = new NBTTagCompound();
                JsonObject allowedNBT = Config.getBlueprintAllowedNBT(block);
                for (String key : blockNBT.func_150296_c()) {
                    if (!allowedNBT.has(key) || allowedNBT.get(key).isJsonNull()) continue;
                    String targetKey = allowedNBT.get(key).getAsString();
                    itemNBT.func_74782_a(targetKey, blockNBT.func_74781_a(key));
                }
                if (itemNBT.func_186856_d() > 0) {
                    item.func_77982_d(itemNBT);
                }
            }
            return item;
        }
        catch (Exception e) {
            return new ItemStack(Item.func_150898_a((Block)block), 1, block.func_180651_a(state));
        }
    }

    public static boolean isLiquidSource(IBlockState state, Block block) {
        return block instanceof BlockLiquid && (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0;
    }

    @Nullable
    public static Map<StructureSaver.ItemStackKey, Integer> getMaterialList(ItemStack blueprint, WorldServer worldserver, EntityPlayer player) {
        CapsuleTemplate blueprintTemplate = (CapsuleTemplate)StructureSaver.getTemplate(blueprint, worldserver).getRight();
        if (blueprintTemplate == null) {
            return null;
        }
        return Blueprint.getMaterialList(blueprintTemplate, player);
    }

    public static Map<StructureSaver.ItemStackKey, Integer> getMaterialList(CapsuleTemplate blueprintTemplate, @Nullable EntityPlayer player) {
        HashMap<StructureSaver.ItemStackKey, Integer> list = new HashMap<StructureSaver.ItemStackKey, Integer>();
        for (Template.BlockInfo block : blueprintTemplate.blocks) {
            ItemStack itemStack = Blueprint.getBlockItemCost(block);
            StructureSaver.ItemStackKey stackKey = new StructureSaver.ItemStackKey(itemStack);
            if (itemStack == null) {
                if (player != null) {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("capsule.error.technicalError", new Object[0]));
                }
                if (player != null) {
                    LOGGER.error("Unknown item during blueprint undo for block " + block.field_186243_b.func_177230_c().getRegistryName());
                }
                return null;
            }
            if (itemStack.func_190926_b() || itemStack.func_77973_b() == Items.field_190931_a) continue;
            Integer currValue = (Integer)list.get(stackKey);
            if (currValue == null) {
                currValue = 0;
            }
            list.put(stackKey, currValue + itemStack.func_190916_E());
        }
        return list;
    }

    public static TreeMap<Triple<StructureSaver.ItemStackKey, StructureSaver.ItemStackKey, StructureSaver.ItemStackKey>, String> sortTemplatesByIngredients(List<String> prefabsTemplatesList, CapsuleTemplateManager tempManager) {
        TreeMap<Triple<StructureSaver.ItemStackKey, StructureSaver.ItemStackKey, StructureSaver.ItemStackKey>, String> templatesByIngrendients = new TreeMap<Triple<StructureSaver.ItemStackKey, StructureSaver.ItemStackKey, StructureSaver.ItemStackKey>, String>(Triple::compareTo);
        for (String templateName : prefabsTemplatesList) {
            try {
                Map<StructureSaver.ItemStackKey, Integer> fullList;
                ResourceLocation location = new ResourceLocation(templateName);
                tempManager.readTemplate(location);
                CapsuleTemplate template = tempManager.get(null, location);
                if (template == null || (fullList = Blueprint.getMaterialList(template, null)) == null) continue;
                StructureSaver.ItemStackKey[] list = (StructureSaver.ItemStackKey[])fullList.entrySet().stream().sorted(Collections.reverseOrder(Map.Entry.comparingByValue())).limit(5L).map(Map.Entry::getKey).toArray(StructureSaver.ItemStackKey[]::new);
                Triple key = Triple.of((Object)list[0], (Object)(list.length > 1 ? list[1] : null), list.length > 2 ? list[2] : null);
                if (templatesByIngrendients.containsKey(key)) {
                    key = Triple.of((Object)list[0], (Object)(list.length > 2 ? list[2] : null), list.length > 1 ? list[1] : null);
                }
                if (templatesByIngrendients.containsKey(key)) {
                    key = Triple.of((Object)(list.length > 1 ? list[1] : null), (Object)list[0], list.length > 2 ? list[2] : null);
                }
                if (templatesByIngrendients.containsKey(key)) {
                    key = Triple.of((Object)(list.length > 2 ? list[2] : null), (Object)list[0], list.length > 1 ? list[1] : null);
                }
                if (templatesByIngrendients.containsKey(key)) {
                    key = Triple.of((Object)(list.length > 1 ? list[1] : null), (Object)(list.length > 2 ? list[2] : null), (Object)list[0]);
                }
                if (templatesByIngrendients.containsKey(key)) {
                    key = Triple.of((Object)(list.length > 2 ? list[2] : null), (Object)(list.length > 1 ? list[1] : null), (Object)list[0]);
                }
                templatesByIngrendients.put((Triple<StructureSaver.ItemStackKey, StructureSaver.ItemStackKey, StructureSaver.ItemStackKey>)key, templateName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return templatesByIngrendients;
    }

    public static Map<Triple<StructureSaver.ItemStackKey, StructureSaver.ItemStackKey, StructureSaver.ItemStackKey>, String> reduceIngredientCount(TreeMap<Triple<StructureSaver.ItemStackKey, StructureSaver.ItemStackKey, StructureSaver.ItemStackKey>, String> templatesByIngrendients) {
        HashMap<Triple<StructureSaver.ItemStackKey, StructureSaver.ItemStackKey, StructureSaver.ItemStackKey>, String> reduced = new HashMap<Triple<StructureSaver.ItemStackKey, StructureSaver.ItemStackKey, StructureSaver.ItemStackKey>, String>();
        templatesByIngrendients.forEach((ingredients, value) -> {
            Triple withOneIngredient = Triple.of((Object)ingredients.getLeft(), null, null);
            if (!reduced.containsKey(withOneIngredient)) {
                reduced.put((Triple<StructureSaver.ItemStackKey, StructureSaver.ItemStackKey, StructureSaver.ItemStackKey>)withOneIngredient, (String)value);
            } else if (ingredients.getMiddle() != null) {
                Triple withTwoIngredient = Triple.of((Object)ingredients.getLeft(), (Object)ingredients.getMiddle(), null);
                if (!reduced.containsKey(withTwoIngredient)) {
                    reduced.put((Triple<StructureSaver.ItemStackKey, StructureSaver.ItemStackKey, StructureSaver.ItemStackKey>)withTwoIngredient, (String)value);
                } else if (ingredients.getRight() != null) {
                    if (!reduced.containsKey(ingredients)) {
                        reduced.put((Triple<StructureSaver.ItemStackKey, StructureSaver.ItemStackKey, StructureSaver.ItemStackKey>)ingredients, (String)value);
                    } else {
                        LOGGER.warn("Could not create prefab recipe with 2 ingredients or less.");
                    }
                } else {
                    LOGGER.warn("Could not create prefab recipe with 2 ingredients or less.");
                }
            } else {
                LOGGER.warn("Could not create prefab recipe with 1 ingredient.");
            }
        });
        return reduced;
    }

    public static void createDynamicPrefabRecipes(RegistryEvent.Register<IRecipe> event, ArrayList<String> prefabsTemplatesList) {
        JsonObject referenceRecipe = Files.readJSON(new File(Config.configDir, "prefabs/prefab_blueprint_recipe.json"));
        if (referenceRecipe != null) {
            CapsuleTemplateManager tempManager = new CapsuleTemplateManager(Config.configDir.getParentFile().getParentFile().getPath(), (DataFixer)FMLCommonHandler.instance().getDataFixer());
            List<String> enabledPrefabsTemplatesList = Blueprint.getModEnabledTemplates(prefabsTemplatesList);
            TreeMap<Triple<StructureSaver.ItemStackKey, StructureSaver.ItemStackKey, StructureSaver.ItemStackKey>, String> templatesByIngrendients = Blueprint.sortTemplatesByIngredients(enabledPrefabsTemplatesList, tempManager);
            Map<Triple<StructureSaver.ItemStackKey, StructureSaver.ItemStackKey, StructureSaver.ItemStackKey>, String> reduced = Blueprint.reduceIngredientCount(templatesByIngrendients);
            reduced.forEach((ingredients, templateName) -> {
                CapsuleTemplate template = tempManager.get(null, new ResourceLocation(templateName));
                JsonObject jsonRecipe = Files.copy(referenceRecipe);
                if (jsonRecipe != null && template != null) {
                    jsonRecipe.getAsJsonObject("result").getAsJsonObject("nbt").addProperty("structureName", templateName);
                    jsonRecipe.getAsJsonObject("result").getAsJsonObject("nbt").addProperty("label", Capsule.labelFromPath(templateName));
                    int size = Math.max(template.getSize().func_177958_n(), Math.max(template.getSize().func_177956_o(), template.getSize().func_177952_p()));
                    jsonRecipe.getAsJsonObject("result").getAsJsonObject("nbt").addProperty("size", (Number)size);
                    PrefabsBlueprintCapsuleRecipe templateRecipe = new PrefabsBlueprintCapsuleRecipe(jsonRecipe, (Triple<StructureSaver.ItemStackKey, StructureSaver.ItemStackKey, StructureSaver.ItemStackKey>)ingredients);
                    event.getRegistry().register(templateRecipe.setRegistryName("capsule:" + templateName));
                }
            });
        }
    }

    public static List<String> getModEnabledTemplates(ArrayList<String> prefabsTemplatesList) {
        return prefabsTemplatesList.stream().filter(templatePath -> {
            String[] path = templatePath.replaceAll(Config.prefabsTemplatesPath + "/", "").split("/");
            return path.length == 1 || Loader.isModLoaded((String)path[0]);
        }).collect(Collectors.toList());
    }
}

