/*
 * Decompiled with CFR 0.152.
 */
package capsule.helpers;

import capsule.loot.LootPathData;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Files {
    protected static final Logger LOGGER = LogManager.getLogger(Files.class);
    private static Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JsonObject readJSON(File file) {
        if (!file.exists()) return null;
        try (FileInputStream stream = new FileInputStream(file);){
            JsonObject jsonContent;
            JsonObject jsonObject = jsonContent = (JsonObject)JsonUtils.func_193839_a((Gson)GSON, (Reader)new InputStreamReader(stream), JsonObject.class);
            return jsonObject;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static JsonObject copy(JsonObject original) {
        try {
            return (JsonObject)GSON.fromJson(GSON.toJson((Object)original, JsonObject.class), JsonObject.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static HashMap<String, JsonObject> populateWhitelistConfig(File capsuleConfigDir) {
        if (!capsuleConfigDir.exists()) {
            capsuleConfigDir.mkdirs();
        }
        HashMap<String, JsonObject> blueprintWhitelist = new HashMap<String, JsonObject>();
        if (capsuleConfigDir.exists() && capsuleConfigDir.isDirectory()) {
            File whitelistFile = new File(capsuleConfigDir, "blueprint_whitelist.json");
            if (!whitelistFile.exists()) {
                LOGGER.info("First load: initializing the configs in " + capsuleConfigDir.getPath() + ".");
                Files.populateFolder(capsuleConfigDir, "assets/capsule/config");
            }
            if (whitelistFile.exists()) {
                try (FileInputStream stream = new FileInputStream(whitelistFile);){
                    JsonArray whitelistElements = (JsonArray)JsonUtils.func_193839_a((Gson)GSON, (Reader)new InputStreamReader(stream), JsonArray.class);
                    if (whitelistElements != null) {
                        for (JsonElement elem : whitelistElements) {
                            if (elem.isJsonPrimitive()) {
                                blueprintWhitelist.put(elem.getAsString(), null);
                                continue;
                            }
                            if (!elem.isJsonObject()) continue;
                            JsonObject obj = elem.getAsJsonObject();
                            blueprintWhitelist.put(obj.get("block").getAsString(), obj.has("keepNBT") ? obj.get("keepNBT").getAsJsonObject() : null);
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            } else {
                LOGGER.error(whitelistFile.getPath() + " was expected to be found in config/capsule. Maybe it could not be created.");
            }
        }
        return blueprintWhitelist;
    }

    public static ArrayList<String> populateStarters(File capsuleConfigDir, String starterTemplatesPath) {
        if (StringUtils.func_151246_b((String)starterTemplatesPath)) {
            return new ArrayList<String>();
        }
        File startersFolder = new File(capsuleConfigDir.getParentFile().getParentFile(), starterTemplatesPath);
        if (!startersFolder.exists()) {
            startersFolder.mkdirs();
            LOGGER.info("First load: initializing the starters in " + starterTemplatesPath + ". You can change the content of folder with any nbt structure block, schematic or capsule file, or empty it for no starter capsule.");
            Files.populateFolder(startersFolder, "assets/capsule/starters");
        }
        ArrayList<String> starterTemplatesList = new ArrayList<String>();
        Files.iterateTemplates(startersFolder, templateName -> starterTemplatesList.add(starterTemplatesPath + "/" + templateName));
        return starterTemplatesList;
    }

    public static void populateAndLoadLootList(File capsuleConfigDir, String[] lootTemplatesPaths, Map<String, LootPathData> outLootTemplatesData) {
        for (String path : lootTemplatesPaths) {
            LootPathData data = outLootTemplatesData.get(path);
            File templateFolder = new File(capsuleConfigDir.getParentFile().getParentFile(), path);
            if (!templateFolder.exists()) {
                templateFolder.mkdirs();
                LOGGER.info("First load: initializing the loots in " + path + ". You can change the content of folder with any nbt structure block, schematic, or capsule file. You can remove the folders from capsule.config to remove loots.");
                String assetPath = "assets/capsule/loot/common";
                if (templateFolder.getPath().contains("uncommon")) {
                    assetPath = "assets/capsule/loot/uncommon";
                }
                if (templateFolder.getPath().contains("rare")) {
                    assetPath = "assets/capsule/loot/rare";
                }
                Files.populateFolder(templateFolder, assetPath);
            }
            data.files = new ArrayList<String>();
            Files.iterateTemplates(templateFolder, templateName -> data.files.add((String)templateName));
        }
    }

    public static ArrayList<String> populatePrefabs(File capsuleConfigDir, String prefabsTemplatesPath) {
        File prefabsFolder = new File(capsuleConfigDir.getParentFile().getParentFile(), prefabsTemplatesPath);
        if (!prefabsFolder.exists()) {
            prefabsFolder.mkdirs();
            LOGGER.info("First load: initializing the prefabs in " + prefabsTemplatesPath + ". You can change the content of folder with any nbt structure block, schematic or capsule file, or empty it for no blueprint prefabs recipes.");
            Files.populateFolder(prefabsFolder, "assets/capsule/prefabs");
        }
        ArrayList<String> prefabsTemplatesList = new ArrayList<String>();
        Files.iterateTemplates(prefabsFolder, templateName -> prefabsTemplatesList.add(prefabsTemplatesPath + "/" + templateName));
        return prefabsTemplatesList;
    }

    public static void populateFolder(File templateFolder, String assetPath) {
        try {
            String[] resources;
            for (String ressource : resources = Files.getResourceListing(Files.class, assetPath)) {
                if (ressource.isEmpty()) continue;
                InputStream sourceTemplate = Files.class.getClassLoader().getResourceAsStream(assetPath + "/" + ressource);
                if (sourceTemplate == null) {
                    LOGGER.error("asset " + assetPath + "/" + ressource + "couldn't be loaded");
                    break;
                }
                Path assetFile = templateFolder.toPath().resolve(ressource.toLowerCase());
                LOGGER.debug("copying asset " + assetPath + "/" + ressource + " to " + assetFile.toString());
                try {
                    if (ressource.contains(".")) {
                        java.nio.file.Files.copy(sourceTemplate, assetFile, new CopyOption[0]);
                        continue;
                    }
                    File assetFileDirectory = assetFile.toFile();
                    if (!assetFileDirectory.exists()) {
                        assetFileDirectory.mkdirs();
                    }
                    Files.populateFolder(assetFileDirectory, assetPath + "/" + ressource);
                }
                catch (Exception e) {
                    LOGGER.error((Object)e);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error while copying initial capsule templates, there will be no loots!", (Throwable)e);
        }
    }

    public static void iterateTemplates(File templateFolder, Consumer<String> onTemplateFound) {
        if (templateFolder.exists() && templateFolder.isDirectory()) {
            Iterator iterator = null;
            try {
                iterator = java.nio.file.Files.walk(templateFolder.toPath(), new FileVisitOption[0]).iterator();
                while (iterator.hasNext()) {
                    Path path = (Path)iterator.next();
                    File file = path.toFile();
                    if (!file.isFile() || !file.getName().endsWith(".nbt") && !file.getName().endsWith(".schematic")) continue;
                    Path relative = templateFolder.toPath().relativize(path);
                    onTemplateFound.accept(relative.toString().replaceAll("\\\\", "/").replaceAll(".nbt", "").replaceAll(".schematic", ""));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String[] getResourceListing(Class<?> clazz, String path) throws URISyntaxException, IOException {
        URL dirURL = clazz.getClassLoader().getResource(path);
        if (dirURL != null && dirURL.getProtocol().equals("file")) {
            return new File(dirURL.toURI()).list();
        }
        if (dirURL == null) {
            String me = clazz.getName().replace(".", "/") + ".class";
            dirURL = clazz.getClassLoader().getResource(me);
        }
        if (dirURL != null && dirURL.getProtocol().equals("jar")) {
            String jarPath = dirURL.getPath().substring(5, dirURL.getPath().indexOf("!"));
            JarFile jar = new JarFile(URLDecoder.decode(jarPath, "UTF-8"));
            LOGGER.debug("Listing files in " + jarPath);
            Enumeration<JarEntry> entries = jar.entries();
            HashSet<String> result = new HashSet<String>();
            while (entries.hasMoreElements()) {
                String name = entries.nextElement().getName();
                if (!name.startsWith(path)) continue;
                LOGGER.debug("Found in jar " + name);
                String entry = name.replace(path + "/", "");
                LOGGER.debug("Keeping " + entry);
                result.add(entry);
            }
            jar.close();
            return result.toArray(new String[0]);
        }
        InputStream inputstream = clazz.getResourceAsStream("/" + path);
        if (inputstream != null) {
            InputStreamReader isr = new InputStreamReader(inputstream, StandardCharsets.UTF_8);
            BufferedReader br = new BufferedReader(isr);
            HashSet<String> result = new HashSet<String>();
            String filename = null;
            while ((filename = br.readLine()) != null) {
                result.add(filename);
            }
            return result.toArray(new String[0]);
        }
        throw new UnsupportedOperationException("Cannot list files for URL " + dirURL);
    }
}

