/*
 * Decompiled with CFR 0.152.
 */
package capsule.helpers;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Serialization {
    protected static final Logger LOGGER = LogManager.getLogger(Serialization.class);

    public static Block[] deserializeBlockArray(String[] blockIds) {
        ArrayList<Object> states = new ArrayList<Object>();
        ArrayList<String> notfound = new ArrayList<String>();
        for (String blockId : blockIds) {
            Block b = Block.func_149684_b((String)blockId);
            if (b != null) {
                states.add(b);
                continue;
            }
            List blockIdsList = ForgeRegistries.BLOCKS.getValuesCollection().stream().filter(block -> {
                ResourceLocation registryName = block.getRegistryName();
                if (registryName == null) {
                    return false;
                }
                return registryName.toString().toLowerCase().contains(blockId.toLowerCase());
            }).collect(Collectors.toList());
            if (blockIdsList.size() > 0) {
                states.addAll(blockIdsList);
                continue;
            }
            notfound.add(blockId);
        }
        if (notfound.size() > 0) {
            LOGGER.debug(String.format("Blocks not found from config name : %s. Those blocks won't be considered in the overridable or excluded blocks list when capturing with capsule.", String.join((CharSequence)", ", notfound.toArray(new CharSequence[0]))));
        }
        Block[] output = new Block[states.size()];
        return states.toArray(output);
    }

    public static String[] serializeBlockArray(Block[] states) {
        String[] blocksNames = new String[states.length];
        for (int i = 0; i < states.length; ++i) {
            blocksNames[i] = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)states[i])).toString();
        }
        return blocksNames;
    }
}

