/*
 * Decompiled with CFR 0.152.
 */
package capsule.items;

import capsule.CommonProxy;
import capsule.Config;
import capsule.Main;
import capsule.StructureSaver;
import capsule.client.CapsulePreviewHandler;
import capsule.helpers.Capsule;
import capsule.helpers.MinecraftNBT;
import capsule.helpers.Spacial;
import capsule.items.CapsuleItems;
import capsule.network.CapsuleContentPreviewQueryToServer;
import capsule.network.CapsuleLeftClickQueryToServer;
import capsule.network.CapsuleThrowQueryToServer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CapsuleItem
extends Item {
    public static final int ACTIVE_DURATION_IN_TICKS = 60;
    public static final int STATE_EMPTY = 0;
    public static final int STATE_EMPTY_ACTIVATED = 4;
    public static final int STATE_ACTIVATED = 1;
    public static final int STATE_LINKED = 2;
    public static final int STATE_DEPLOYED = 3;
    public static final int STATE_ONE_USE = 5;
    public static final int STATE_ONE_USE_ACTIVATED = 6;
    public static final int STATE_BLUEPRINT = 7;
    public static final int CAPSULE_MAX_CAPTURE_SIZE = 255;
    protected static final Logger LOGGER = LogManager.getLogger(CapsuleItem.class);
    public static final float TO_RAD = (float)Math.PI / 180;
    public static final float GRAVITY_PER_TICK = 0.04f;
    public static long lastRotationTime = 0L;

    public CapsuleItem(String unlocalizedName) {
        this.func_77627_a(true);
        this.func_77655_b(unlocalizedName);
        this.func_77625_d(1);
        this.func_77656_e(0);
    }

    public static boolean isOneUse(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77942_o() && stack.func_77978_p().func_74764_b("oneUse") && stack.func_77978_p().func_74767_n("oneUse");
    }

    public static void setOneUse(ItemStack capsule) {
        if (!capsule.func_77942_o()) {
            capsule.func_77982_d(new NBTTagCompound());
        }
        capsule.func_77964_b(5);
        capsule.func_77978_p().func_74757_a("oneUse", true);
    }

    public static boolean isBlueprint(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() instanceof CapsuleItem && stack.func_77942_o() && stack.func_77978_p().func_74764_b("sourceInventory");
    }

    public static void setBlueprint(ItemStack capsule) {
        if (!capsule.func_77942_o()) {
            capsule.func_77982_d(new NBTTagCompound());
        }
        CapsuleItem.saveSourceInventory(capsule, null, 0);
    }

    public static boolean isReward(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77942_o() && stack.func_77978_p().func_74764_b("isReward") && stack.func_77978_p().func_74767_n("isReward") && CapsuleItem.isOneUse(stack);
    }

    public static void setIsReward(ItemStack capsule) {
        if (!capsule.func_77942_o()) {
            capsule.func_77982_d(new NBTTagCompound());
        }
        capsule.func_77978_p().func_74757_a("isReward", true);
        CapsuleItem.setOneUse(capsule);
    }

    public static boolean isInstantAndUndeployed(ItemStack capsule) {
        return capsule.func_77952_i() == 7 || CapsuleItem.getSize(capsule) == 1 && capsule.func_77952_i() != 3;
    }

    public static boolean hasStructureLink(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77942_o() && stack.func_77978_p().func_74764_b("structureName");
    }

    public static boolean isLinkedStateCapsule(ItemStack itemstack) {
        return !itemstack.func_190926_b() && itemstack.func_77973_b() instanceof CapsuleItem && 2 == itemstack.func_77952_i();
    }

    public static String getLabel(ItemStack stack) {
        if (stack.func_190926_b()) {
            return "";
        }
        if (!CapsuleItem.hasStructureLink(stack) && stack.func_77952_i() != 2) {
            return I18n.func_74838_a((String)"item.capsule.content_empty");
        }
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("label") && !"".equals(stack.func_77978_p().func_74779_i("label"))) {
            return "\u00ab" + TextFormatting.ITALIC + stack.func_77978_p().func_74779_i("label") + TextFormatting.RESET + "\u00bb";
        }
        return I18n.func_74838_a((String)"item.capsule.content_unlabeled");
    }

    public static void setLabel(ItemStack capsule, String label) {
        if (capsule != null && !capsule.func_77942_o()) {
            capsule.func_77982_d(new NBTTagCompound());
        }
        capsule.func_77978_p().func_74778_a("label", label);
    }

    public static int getSize(ItemStack capsule) {
        int size = 1;
        if (!capsule.func_190926_b() && capsule.func_77942_o() && capsule.func_77978_p().func_74764_b("size")) {
            size = capsule.func_77978_p().func_74762_e("size");
        }
        if (size > 255) {
            size = 255;
            capsule.func_77978_p().func_74768_a("size", size);
            LOGGER.error("Capsule sizes are capped to 255. Resized to : " + size);
        } else if (size % 2 == 0) {
            capsule.func_77978_p().func_74768_a("size", ++size);
            LOGGER.error("Capsule size must be an odd number to achieve consistency on deployment. Resized to : " + size);
        }
        return size;
    }

    public static void setSize(ItemStack capsule, int size) {
        if (!capsule.func_77942_o()) {
            capsule.func_77982_d(new NBTTagCompound());
        }
        if (size > 255) {
            size = 255;
            LOGGER.warn("Capsule sizes are capped to 255. Resized to : " + size);
        } else if (size % 2 == 0) {
            LOGGER.warn("Capsule size must be an odd number to achieve consistency on deployment. Resized to : " + ++size);
        }
        capsule.func_77978_p().func_74768_a("size", size);
    }

    public static String getStructureName(ItemStack capsule) {
        String name = null;
        if (capsule != null && capsule.func_77942_o() && capsule.func_77978_p().func_74764_b("structureName")) {
            name = capsule.func_77978_p().func_74779_i("structureName");
        }
        return name;
    }

    public static void setStructureName(ItemStack capsule, String structureName) {
        if (!capsule.func_77942_o()) {
            capsule.func_77982_d(new NBTTagCompound());
        }
        capsule.func_77978_p().func_74778_a("structureName", structureName);
    }

    public static String getAuthor(ItemStack capsule) {
        String name = null;
        if (capsule != null && capsule.func_77942_o() && capsule.func_77978_p().func_74764_b("author")) {
            name = capsule.func_77978_p().func_74779_i("author");
        }
        return name;
    }

    public static void setAuthor(ItemStack capsule, String author) {
        if (!capsule.func_77942_o()) {
            capsule.func_77982_d(new NBTTagCompound());
        }
        if (!StringUtils.func_151246_b((String)author)) {
            capsule.func_77978_p().func_74778_a("author", author);
        }
    }

    public static int getBaseColor(ItemStack capsule) {
        return MinecraftNBT.getColor(capsule);
    }

    public static void setBaseColor(ItemStack capsule, int color) {
        MinecraftNBT.setColor(capsule, color);
    }

    public static int getMaterialColor(ItemStack capsule) {
        int color = 0;
        if (capsule != null && capsule.func_77942_o() && capsule.func_77978_p().func_74764_b("color")) {
            color = capsule.func_77978_p().func_74762_e("color");
        }
        return color;
    }

    public static void setMaterialColor(ItemStack capsule, int color) {
        if (!capsule.func_77942_o()) {
            capsule.func_77982_d(new NBTTagCompound());
        }
        capsule.func_77978_p().func_74768_a("color", color);
    }

    public static int getUpgradeLevel(ItemStack stack) {
        int upgradeLevel = 0;
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("upgraded")) {
            upgradeLevel = stack.func_77978_p().func_74762_e("upgraded");
        }
        return upgradeLevel;
    }

    public static void setUpgradeLevel(ItemStack capsule, int upgrades) {
        if (!capsule.func_77942_o()) {
            capsule.func_77982_d(new NBTTagCompound());
        }
        capsule.func_77978_p().func_74768_a("upgraded", upgrades);
    }

    public static Integer getDimension(ItemStack capsule) {
        Integer dim = null;
        if (capsule != null && capsule.func_77942_o() && capsule.func_77978_p().func_74764_b("spawnPosition")) {
            dim = capsule.func_77978_p().func_74775_l("spawnPosition").func_74762_e("dim");
        }
        return dim;
    }

    public static void setState(ItemStack stack, int state) {
        stack.func_77964_b(state);
    }

    public static boolean isOverpowered(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b("overpowered") && stack.func_77978_p().func_74771_c("overpowered") == 1;
    }

    private static boolean isActivated(ItemStack capsule) {
        return capsule.func_77952_i() == 1 || capsule.func_77952_i() == 4 || capsule.func_77952_i() == 6;
    }

    public static void setCanRotate(ItemStack capsule, boolean canRotate) {
        if (!capsule.func_77942_o()) {
            capsule.func_77982_d(new NBTTagCompound());
        }
        capsule.func_77978_p().func_74757_a("canRotate", canRotate);
    }

    public static boolean canRotate(ItemStack capsule) {
        return CapsuleItem.isBlueprint(capsule) || capsule.func_77952_i() != 3 && capsule.func_77942_o() && capsule.func_77978_p().func_74764_b("canRotate") && capsule.func_77978_p().func_74767_n("canRotate");
    }

    public static void revertStateFromActivated(ItemStack capsule) {
        if (CapsuleItem.isBlueprint(capsule)) {
            CapsuleItem.setState(capsule, 7);
        } else if (CapsuleItem.isOneUse(capsule)) {
            CapsuleItem.setState(capsule, 5);
        } else if (CapsuleItem.hasStructureLink(capsule)) {
            CapsuleItem.setState(capsule, 2);
        } else {
            CapsuleItem.setState(capsule, 0);
        }
        if (capsule.func_77942_o()) {
            capsule.func_77978_p().func_82580_o("activetimer");
        }
    }

    public String func_77653_i(ItemStack stack) {
        String content;
        String name = I18n.func_74838_a((String)"item.capsule.name");
        String state = "";
        switch (stack.func_77952_i()) {
            case 1: 
            case 4: 
            case 6: {
                state = TextFormatting.DARK_GREEN + I18n.func_74838_a((String)"item.capsule.state_activated") + TextFormatting.RESET;
                break;
            }
            case 2: {
                state = "";
                break;
            }
            case 3: {
                if (CapsuleItem.isBlueprint(stack)) {
                    name = I18n.func_74838_a((String)"item.capsule.state_blueprint");
                    break;
                }
                state = I18n.func_74838_a((String)"item.capsule.state_deployed");
                break;
            }
            case 5: {
                if (CapsuleItem.isReward(stack)) {
                    state = I18n.func_74838_a((String)"item.capsule.state_one_use");
                    break;
                }
                state = I18n.func_74838_a((String)"item.capsule.state_recovery");
                break;
            }
            case 7: {
                name = I18n.func_74838_a((String)"item.capsule.state_blueprint");
            }
        }
        if (state.length() > 0) {
            state = state + " ";
        }
        if ((content = CapsuleItem.getLabel(stack)).length() > 0) {
            content = content + " ";
        }
        return TextFormatting.RESET + state + content + name;
    }

    public int func_77619_b() {
        return 5;
    }

    public int getItemEnchantability(ItemStack stack) {
        return this.func_77619_b();
    }

    public boolean func_77616_k(ItemStack stack) {
        return stack.func_77952_i() != 5;
    }

    public boolean func_77636_d(ItemStack stack) {
        return CapsuleItem.isOverpowered(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack capsule, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        String author = CapsuleItem.getAuthor(capsule);
        if (author != null) {
            tooltip.add(TextFormatting.DARK_AQUA + "" + TextFormatting.ITALIC + I18n.func_74838_a((String)"capsule.tooltip.author") + " " + author + TextFormatting.RESET);
        }
        if (capsule.func_77952_i() == 5) {
            tooltip.add(I18n.func_74838_a((String)"capsule.tooltip.one_use").trim());
        }
        if (CapsuleItem.isOverpowered(capsule)) {
            tooltip.add(TextFormatting.DARK_PURPLE + I18n.func_74838_a((String)"capsule.tooltip.overpowered") + TextFormatting.RESET);
        }
        int size = CapsuleItem.getSize(capsule);
        int upgradeLevel = CapsuleItem.getUpgradeLevel(capsule);
        String sizeTxt = size + "\u00d7" + size + "\u00d7" + size;
        if (upgradeLevel > 0) {
            sizeTxt = sizeTxt + " (" + upgradeLevel + "/" + Config.upgradeLimit + " " + I18n.func_74838_a((String)"capsule.tooltip.upgraded") + ")";
        }
        if (CapsuleItem.isInstantAndUndeployed(capsule) || CapsuleItem.isBlueprint(capsule)) {
            sizeTxt = sizeTxt + " (" + I18n.func_74838_a((String)"capsule.tooltip.instant").trim() + ")";
        }
        tooltip.add(I18n.func_74838_a((String)"capsule.tooltip.size") + ": " + sizeTxt);
        if (CapsuleItem.isBlueprint(capsule)) {
            if (capsule.func_77952_i() == 3) {
                this.tooltipAddMultiline(tooltip, "capsule.tooltip.blueprintUseUncharged", TextFormatting.WHITE);
            } else {
                this.tooltipAddMultiline(tooltip, "capsule.tooltip.canRotate", TextFormatting.WHITE);
                this.tooltipAddMultiline(tooltip, "capsule.tooltip.blueprintUseCharged", TextFormatting.WHITE);
            }
        } else if (CapsuleItem.canRotate(capsule)) {
            this.tooltipAddMultiline(tooltip, "capsule.tooltip.canRotate", TextFormatting.WHITE);
        } else if (capsule.func_77942_o() && capsule.func_77978_p().func_74764_b("canRotate")) {
            this.tooltipAddMultiline(tooltip, "capsule.tooltip.cannotRotate", TextFormatting.DARK_GRAY);
        }
        if (flagIn == ITooltipFlag.TooltipFlags.ADVANCED) {
            tooltip.add(TextFormatting.GOLD + "structureName: " + CapsuleItem.getStructureName(capsule));
            tooltip.add(TextFormatting.GOLD + "oneUse: " + CapsuleItem.isOneUse(capsule));
            tooltip.add(TextFormatting.GOLD + "isReward: " + CapsuleItem.isReward(capsule));
            if (CapsuleItem.isBlueprint(capsule)) {
                tooltip.add(TextFormatting.GOLD + "sourceInventory: " + CapsuleItem.getSourceInventoryLocation(capsule) + " in dimension " + CapsuleItem.getSourceInventoryDimension(capsule));
            }
            tooltip.add(TextFormatting.GOLD + "color (material): " + Integer.toHexString(CapsuleItem.getMaterialColor(capsule)));
            PlacementSettings p = CapsuleItem.getPlacement(capsule);
            tooltip.add(TextFormatting.GOLD + "\u232f Symmetry: " + Capsule.getMirrorLabel(p));
            tooltip.add(TextFormatting.GOLD + "\u27f3 Rotation: " + Capsule.getRotationLabel(p));
        }
    }

    public void tooltipAddMultiline(List<String> tooltip, String key, TextFormatting formatting) {
        for (String s : I18n.func_74838_a((String)key).trim().split("\\\\n")) {
            tooltip.add(formatting == null ? s : formatting + s);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            subItems.addAll(CapsuleItems.capsuleList.keySet());
            subItems.addAll(CapsuleItems.opCapsuleList.keySet());
            for (Pair<ItemStack, IRecipe> blueprintCapsule : CapsuleItems.blueprintCapsules) {
                subItems.add(blueprintCapsule.getKey());
            }
            if (CapsuleItems.unlabelledCapsule != null) {
                subItems.add(CapsuleItems.unlabelledCapsule.getKey());
            }
            if (CapsuleItems.recoveryCapsule != null) {
                subItems.add(CapsuleItems.recoveryCapsule.getKey());
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onLeftClick(PlayerInteractEvent.LeftClickEmpty event) {
        ItemStack stack = event.getEntityPlayer().func_184614_ca();
        if (event.getWorld().field_72995_K && stack.func_77973_b() instanceof CapsuleItem && (CapsuleItem.isBlueprint(stack) || CapsuleItem.canRotate(stack))) {
            CommonProxy.simpleNetworkWrapper.sendToServer((IMessage)new CapsuleLeftClickQueryToServer());
            this.askPreviewIfNeeded(stack);
        }
    }

    @SubscribeEvent
    public void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        ItemStack stack;
        if (!event.isCanceled() && (stack = event.getEntityPlayer().func_184614_ca()).func_77973_b() instanceof CapsuleItem && CapsuleItem.canRotate(stack)) {
            event.setCanceled(true);
            if (event.getWorld().field_72995_K && lastRotationTime + 60L < Minecraft.func_71386_F()) {
                lastRotationTime = Minecraft.func_71386_F();
                CommonProxy.simpleNetworkWrapper.sendToServer((IMessage)new CapsuleLeftClickQueryToServer());
                this.askPreviewIfNeeded(stack);
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void heldItemChange(LivingEquipmentChangeEvent event) {
        if (event.getEntity() instanceof EntityPlayer && event.getSlot().equals((Object)EntityEquipmentSlot.MAINHAND) && CapsuleItem.isBlueprint(event.getTo())) {
            this.askPreviewIfNeeded(event.getTo());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void askPreviewIfNeeded(ItemStack stack) {
        if (!CapsulePreviewHandler.currentPreview.containsKey(CapsuleItem.getStructureName(stack))) {
            CommonProxy.simpleNetworkWrapper.sendToServer((IMessage)new CapsuleContentPreviewQueryToServer(CapsuleItem.getStructureName(stack)));
        }
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        TileEntity te;
        if (hand == EnumHand.OFF_HAND) {
            return EnumActionResult.PASS;
        }
        ItemStack capsule = player.func_184586_b(hand);
        if (player.func_70093_af() && CapsuleItem.isBlueprint(capsule) && (te = world.func_175625_s(pos)) != null && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            if (CapsuleItem.hasSourceInventory(capsule) && pos.equals((Object)CapsuleItem.getSourceInventoryLocation(capsule)) && CapsuleItem.getSourceInventoryDimension(capsule).equals(world.field_73011_w.getDimension())) {
                CapsuleItem.saveSourceInventory(capsule, null, 0);
            } else {
                CapsuleItem.saveSourceInventory(capsule, pos, world.field_73011_w.getDimension());
            }
            return EnumActionResult.SUCCESS;
        }
        return super.onItemUseFirst(player, world, pos, side, hitX, hitY, hitZ, hand);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack capsule = playerIn.func_184586_b(handIn);
        if (handIn == EnumHand.OFF_HAND) {
            return new ActionResult(EnumActionResult.FAIL, (Object)capsule);
        }
        if (playerIn.func_70093_af() && (capsule.func_77952_i() == 2 || capsule.func_77952_i() == 3 || capsule.func_77952_i() == 5 || capsule.func_77952_i() == 7)) {
            Main.proxy.openGuiScreen(playerIn);
        } else if (!worldIn.field_72995_K) {
            if (!CapsuleItem.isInstantAndUndeployed(capsule)) {
                this.activateCapsule(capsule, worldIn, playerIn);
            }
        } else if (worldIn.field_72995_K) {
            BlockPos dest;
            RayTraceResult rtr;
            if (!(CapsuleItem.isInstantAndUndeployed(capsule) || capsule.func_77952_i() != 2 && capsule.func_77952_i() != 5)) {
                rtr = CapsuleItem.hasStructureLink(capsule) ? Spacial.clientRayTracePreview(playerIn, 0.0f, CapsuleItem.getSize(capsule)) : null;
                BlockPos blockPos = dest = rtr != null && rtr.field_72313_a == RayTraceResult.Type.BLOCK ? rtr.func_178782_a().func_177971_a(rtr.field_178784_b.func_176730_m()) : null;
                if (dest != null) {
                    CommonProxy.simpleNetworkWrapper.sendToServer((IMessage)new CapsuleContentPreviewQueryToServer(capsule.func_77978_p().func_74779_i("structureName")));
                }
            }
            if (CapsuleItem.isInstantAndUndeployed(capsule)) {
                rtr = Spacial.clientRayTracePreview(playerIn, 0.0f, CapsuleItem.getSize(capsule));
                dest = null;
                if (rtr != null && rtr.field_72313_a == RayTraceResult.Type.BLOCK) {
                    dest = capsule.func_77952_i() == 0 ? rtr.func_178782_a() : rtr.func_178782_a().func_177971_a(rtr.field_178784_b.func_176730_m());
                }
                if (dest != null) {
                    CommonProxy.simpleNetworkWrapper.sendToServer((IMessage)new CapsuleThrowQueryToServer(dest, true));
                }
            } else if (CapsuleItem.isActivated(capsule)) {
                rtr = CapsuleItem.hasStructureLink(capsule) ? Spacial.clientRayTracePreview(playerIn, 0.0f, CapsuleItem.getSize(capsule)) : null;
                dest = rtr != null && rtr.field_72313_a == RayTraceResult.Type.BLOCK ? rtr.func_178782_a().func_177971_a(rtr.field_178784_b.func_176730_m()) : null;
                CommonProxy.simpleNetworkWrapper.sendToServer((IMessage)new CapsuleThrowQueryToServer(dest, false));
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)capsule);
    }

    public void activateCapsule(ItemStack capsule, World worldIn, EntityPlayer playerIn) {
        if (capsule.func_77952_i() == 0) {
            CapsuleItem.setState(capsule, 4);
            this.startTimer(worldIn, playerIn, capsule);
        } else if (capsule.func_77952_i() == 2) {
            CapsuleItem.setState(capsule, 1);
            this.startTimer(worldIn, playerIn, capsule);
        } else if (capsule.func_77952_i() == 5) {
            CapsuleItem.setState(capsule, 6);
            this.startTimer(worldIn, playerIn, capsule);
        } else if (capsule.func_77952_i() == 3) {
            try {
                Capsule.resentToCapsule(capsule, playerIn);
                worldIn.func_184133_a(null, playerIn.func_180425_c(), SoundEvents.field_187837_fU, SoundCategory.BLOCKS, 0.2f, 0.4f);
            }
            catch (Exception e) {
                LOGGER.error("Couldn't resend the content into the capsule", (Throwable)e);
            }
        }
    }

    private void startTimer(World worldIn, EntityPlayer playerIn, ItemStack capsule) {
        NBTTagCompound timer = capsule.func_190925_c("activetimer");
        timer.func_74768_a("starttime", playerIn.field_70173_aa);
        worldIn.func_184133_a(null, playerIn.func_180425_c(), SoundEvents.field_187839_fV, SoundCategory.BLOCKS, 0.2f, 0.9f);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        if (!worldIn.field_72995_K) {
            NBTTagCompound timer = stack.func_179543_a("activetimer");
            if (timer != null && CapsuleItem.isActivated(stack) && timer.func_74764_b("starttime") && entityIn.field_70173_aa >= timer.func_74762_e("starttime") + 60) {
                CapsuleItem.revertStateFromActivated(stack);
                worldIn.func_184133_a(null, entityIn.func_180425_c(), SoundEvents.field_187837_fU, SoundCategory.BLOCKS, 0.2f, 0.4f);
            }
            if (CapsuleItem.isActivated(stack) && !timer.func_74764_b("starttime")) {
                CapsuleItem.revertStateFromActivated(stack);
            }
        }
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        super.onEntityItemUpdate(entityItem);
        ItemStack capsule = entityItem.func_92059_d();
        if (capsule == null) {
            return false;
        }
        if (!entityItem.func_130014_f_().field_72995_K && entityItem.field_70173_aa > 2 && CapsuleItem.isActivated(capsule) && (entityItem.field_70132_H || Spacial.entityItemShouldAndCollideLiquid(entityItem))) {
            Capsule.handleEntityItemOnGround(entityItem, capsule);
        }
        if (!entityItem.func_130014_f_().field_72995_K && CapsuleItem.isActivated(capsule) && capsule.func_77942_o() && capsule.func_77978_p().func_74764_b("deployAt") && !entityItem.field_70132_H && !Spacial.entityItemShouldAndCollideLiquid(entityItem)) {
            Spacial.moveEntityItemToDeployPos(entityItem, capsule, true);
        }
        return false;
    }

    @SubscribeEvent
    public void onTickPlayerEvent(TickEvent.PlayerTickEvent event) {
        if (!event.player.field_70170_p.field_72995_K) {
            for (int i = 0; i < event.player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack itemstack = event.player.field_71071_by.func_70301_a(i);
                if (!itemstack.func_77942_o() || !itemstack.func_77978_p().func_74764_b("templateShouldBeCopied")) continue;
                this.func_77622_d(itemstack, event.player.field_70170_p, event.player);
            }
        }
    }

    public void func_77622_d(ItemStack capsule, World worldIn, EntityPlayer playerIn) {
        String srcStructurePath;
        if (!worldIn.field_72995_K && capsule.func_77973_b() instanceof CapsuleItem && CapsuleItem.isBlueprint(capsule) && (srcStructurePath = CapsuleItem.getStructureName(capsule)) != null) {
            String templateName = StructureSaver.createBlueprintTemplate(srcStructurePath, capsule, (WorldServer)worldIn, playerIn);
            CapsuleItem.setStructureName(capsule, templateName);
            if (capsule.func_77978_p() != null) {
                capsule.func_77978_p().func_82580_o("templateShouldBeCopied");
            }
        }
    }

    public static Map<BlockPos, Block> getOccupiedSourcePos(ItemStack capsule) {
        HashMap<BlockPos, Block> occupiedSources = null;
        if (capsule.func_77942_o() && capsule.func_77978_p().func_74764_b("occupiedSpawnPositions")) {
            occupiedSources = new HashMap<BlockPos, Block>();
            NBTTagList list = capsule.func_77978_p().func_150295_c("occupiedSpawnPositions", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound entry = list.func_150305_b(i);
                occupiedSources.put(BlockPos.func_177969_a((long)entry.func_74763_f("pos")), Block.func_149729_e((int)entry.func_74762_e("blockId")));
            }
        }
        return occupiedSources;
    }

    public static void cleanDeploymentTags(ItemStack capsule) {
        capsule.func_77978_p().func_82580_o("spawnPosition");
        capsule.func_77978_p().func_82580_o("occupiedSpawnPositions");
    }

    public static List<Block> getExcludedBlocs(ItemStack stack) {
        List<Block> excludedBlocks = Config.excludedBlocks;
        if (CapsuleItem.isOverpowered(stack)) {
            excludedBlocks = Config.opExcludedBlocks;
        }
        return excludedBlocks;
    }

    public static int getColorFromItemstack(ItemStack stack, int renderPass) {
        int color = 0xFFFFFF;
        if (renderPass == 0) {
            color = MinecraftNBT.getColor(stack);
        } else if (renderPass == 1) {
            if (CapsuleItem.isBlueprint(stack) && stack.func_77952_i() == 3) {
                color = 8176874;
            } else if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("color")) {
                color = stack.func_77978_p().func_74762_e("color");
            }
        } else if (renderPass == 2) {
            color = CapsuleItem.isBlueprint(stack) ? 3912700 : 0xFFFFFF;
        }
        return color;
    }

    public static void saveSpawnPosition(ItemStack capsule, BlockPos dest, int dimID) {
        if (!capsule.func_77942_o()) {
            capsule.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound pos = new NBTTagCompound();
        pos.func_74768_a("x", dest.func_177958_n());
        pos.func_74768_a("y", dest.func_177956_o());
        pos.func_74768_a("z", dest.func_177952_p());
        pos.func_74768_a("dim", dimID);
        capsule.func_77978_p().func_74782_a("spawnPosition", (NBTBase)pos);
    }

    public static void saveSourceInventory(ItemStack capsule, BlockPos dest, int dimID) {
        if (!capsule.func_77942_o()) {
            capsule.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound pos = new NBTTagCompound();
        if (dest != null) {
            pos.func_74768_a("x", dest.func_177958_n());
            pos.func_74768_a("y", dest.func_177956_o());
            pos.func_74768_a("z", dest.func_177952_p());
            pos.func_74768_a("dim", dimID);
        }
        capsule.func_77978_p().func_74782_a("sourceInventory", (NBTBase)pos);
    }

    public static boolean hasSourceInventory(ItemStack capsule) {
        if (!capsule.func_77942_o()) {
            capsule.func_77982_d(new NBTTagCompound());
        }
        return capsule.func_77978_p().func_74764_b("sourceInventory") && capsule.func_77978_p().func_74775_l("sourceInventory").func_74764_b("x");
    }

    @Nullable
    public static BlockPos getSourceInventoryLocation(ItemStack capsule) {
        if (CapsuleItem.hasSourceInventory(capsule)) {
            NBTTagCompound sourceInventory = capsule.func_77978_p().func_74775_l("sourceInventory");
            return new BlockPos(sourceInventory.func_74762_e("x"), sourceInventory.func_74762_e("y"), sourceInventory.func_74762_e("z"));
        }
        return null;
    }

    @Nullable
    public static Integer getSourceInventoryDimension(ItemStack capsule) {
        if (CapsuleItem.hasSourceInventory(capsule)) {
            return capsule.func_77978_p().func_74775_l("sourceInventory").func_74762_e("dim");
        }
        return null;
    }

    @Nullable
    public static IItemHandler getSourceInventory(ItemStack blueprint, WorldServer w) {
        BlockPos location = CapsuleItem.getSourceInventoryLocation(blueprint);
        Integer dimension = CapsuleItem.getSourceInventoryDimension(blueprint);
        if (location == null || dimension == null) {
            return null;
        }
        WorldServer world = w.func_73046_m().func_71218_a(dimension.intValue());
        TileEntity te = world.func_175625_s(location);
        if (te != null && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            return (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        }
        return null;
    }

    public static void setPlacement(ItemStack blueprint, PlacementSettings placementSettings) {
        if (!blueprint.func_77942_o()) {
            blueprint.func_77982_d(new NBTTagCompound());
        }
        blueprint.func_77978_p().func_74778_a("rotation", placementSettings == null ? Rotation.NONE.name() : placementSettings.func_186215_c().name());
        blueprint.func_77978_p().func_74778_a("mirror", placementSettings == null ? Mirror.NONE.name() : placementSettings.func_186212_b().name());
    }

    public static PlacementSettings getPlacement(ItemStack capsule) {
        if (CapsuleItem.hasPlacement(capsule)) {
            PlacementSettings placementSettings = new PlacementSettings().func_186214_a(Mirror.valueOf((String)capsule.func_77978_p().func_74779_i("mirror"))).func_186220_a(Rotation.valueOf((String)capsule.func_77978_p().func_74779_i("rotation"))).func_186222_a(false).func_186218_a(null).func_186225_a(null).func_186226_b(false);
            return placementSettings;
        }
        return new PlacementSettings();
    }

    public static boolean hasPlacement(ItemStack blueprint) {
        if (!blueprint.func_77942_o()) {
            blueprint.func_77982_d(new NBTTagCompound());
        }
        return blueprint.func_77978_p().func_74764_b("mirror") && blueprint.func_77978_p().func_74764_b("rotation");
    }

    public static void clearCapsule(ItemStack capsule) {
        CapsuleItem.setState(capsule, 0);
        if (!capsule.func_77942_o()) {
            return;
        }
        capsule.func_77978_p().func_82580_o("structureName");
        capsule.func_77978_p().func_82580_o("sourceInventory");
    }
}

