/*
 * Decompiled with CFR 0.152.
 */
package capsule.network;

import capsule.StructureSaver;
import capsule.structure.CapsuleTemplate;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CapsuleFullContentAnswerToClient
implements IMessage {
    protected static final Logger LOGGER = LogManager.getLogger(CapsuleFullContentAnswerToClient.class);
    public static final long BUFFER_MAX_SIZE = 1000000L;
    private CapsuleTemplate template = null;
    private String structureName = null;

    public CapsuleFullContentAnswerToClient(CapsuleTemplate template, String structureName) {
        this.template = template;
        this.structureName = structureName;
    }

    public CapsuleFullContentAnswerToClient() {
    }

    public void fromBytes(ByteBuf buf) {
        block5: {
            try {
                this.structureName = ByteBufUtils.readUTF8String((ByteBuf)buf);
                boolean isSmallEnough = buf.readBoolean();
                this.template = null;
                if (!isSmallEnough) break block5;
                byte[] abyte = new byte[buf.readableBytes()];
                buf.readBytes(abyte);
                ByteArrayInputStream bytearrayoutputstream = new ByteArrayInputStream(abyte);
                NBTTagCompound nbt = null;
                try {
                    nbt = CompressedStreamTools.func_74796_a((InputStream)bytearrayoutputstream);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (nbt != null) {
                    this.template = new CapsuleTemplate();
                    this.template.read(nbt);
                }
            }
            catch (IndexOutOfBoundsException ioe) {
                LOGGER.error("Exception while reading CapsuleFullContentAnswerToClient: " + ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.structureName);
        NBTTagCompound nbt = StructureSaver.getTemplateNBTData(this.template);
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
        try {
            CompressedStreamTools.func_74799_a((NBTTagCompound)nbt, (OutputStream)bytearrayoutputstream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if ((long)bytearrayoutputstream.size() < 1000000L) {
                buf.writeBoolean(true);
                buf.writeBytes(bytearrayoutputstream.toByteArray());
            } else {
                buf.writeBoolean(false);
            }
        }
    }

    public String toString() {
        return this.getClass().toString();
    }

    public String getStructureName() {
        return this.structureName;
    }

    public CapsuleTemplate getTemplate() {
        return this.template;
    }
}

