/*
 * Decompiled with CFR 0.152.
 */
package capsule.structure;

import capsule.structure.CapsuleTemplate;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CapsuleTemplateManager {
    protected static final Logger LOGGER = LogManager.getLogger(CapsuleTemplateManager.class);
    private final Map<String, CapsuleTemplate> templates = Maps.newHashMap();
    private final String baseFolder;
    private final DataFixer fixer;

    public CapsuleTemplateManager(String p_i47239_1_, DataFixer p_i47239_2_) {
        this.baseFolder = p_i47239_1_;
        this.fixer = p_i47239_2_;
    }

    public CapsuleTemplate getTemplate(@Nullable MinecraftServer server, ResourceLocation id) {
        CapsuleTemplate template = this.get(server, id);
        if (template == null) {
            template = new CapsuleTemplate();
            this.templates.put(id.func_110623_a(), template);
        }
        return template;
    }

    @Nullable
    public CapsuleTemplate get(@Nullable MinecraftServer server, ResourceLocation templatePath) {
        String s = templatePath.func_110623_a();
        if (this.templates.containsKey(s)) {
            return this.templates.get(s);
        }
        if (server == null) {
            this.readTemplateFromJar(templatePath);
        } else {
            this.readTemplate(templatePath);
        }
        return this.templates.containsKey(s) ? this.templates.get(s) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readTemplate(ResourceLocation server) {
        boolean flag;
        String s = server.func_110623_a();
        File file1 = new File(this.baseFolder, s + ".nbt");
        if (!file1.exists()) {
            return this.readTemplateFromSchematic(server) || this.readTemplateFromJar(server);
        }
        FileInputStream inputstream = null;
        try {
            inputstream = new FileInputStream(file1);
            this.readTemplateFromStream(s, inputstream);
            flag = true;
        }
        catch (Throwable var10) {
            try {
                flag = false;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputstream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)inputstream);
        }
        IOUtils.closeQuietly((InputStream)inputstream);
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readTemplateFromJar(ResourceLocation id) {
        boolean flag;
        String s = id.func_110624_b();
        String s1 = id.func_110623_a();
        InputStream inputstream = null;
        try {
            LOGGER.info("reading from jar at/" + s1 + ".nbt");
            inputstream = MinecraftServer.class.getResourceAsStream("/" + s1 + ".nbt");
            this.readTemplateFromStream(s1, inputstream);
            flag = true;
        }
        catch (Throwable var10) {
            try {
                flag = false;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                IOUtils.closeQuietly(inputstream);
            }
        }
        IOUtils.closeQuietly((InputStream)inputstream);
        return flag;
    }

    public void readTemplateFromStream(String id, InputStream stream) throws IOException {
        NBTTagCompound nbttagcompound = CompressedStreamTools.func_74796_a((InputStream)stream);
        if (!nbttagcompound.func_150297_b("DataVersion", 99)) {
            nbttagcompound.func_74768_a("DataVersion", 500);
        }
        CapsuleTemplate template = new CapsuleTemplate();
        template.read(this.fixer.func_188257_a((IFixType)FixTypes.STRUCTURE, nbttagcompound));
        this.templates.put(id, template);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeTemplate(@Nullable MinecraftServer server, ResourceLocation id) {
        block6: {
            boolean flag;
            String s = id.func_110623_a();
            if (server == null || !this.templates.containsKey(s)) break block6;
            File file1 = new File(this.baseFolder);
            if (!file1.exists() ? !file1.mkdirs() : !file1.isDirectory()) {
                return false;
            }
            File file2 = new File(file1, s + ".nbt");
            CapsuleTemplate template = this.templates.get(s);
            FileOutputStream outputstream = null;
            try {
                NBTTagCompound nbttagcompound = template.writeToNBT(new NBTTagCompound());
                outputstream = new FileOutputStream(file2);
                CompressedStreamTools.func_74799_a((NBTTagCompound)nbttagcompound, (OutputStream)outputstream);
                flag = true;
            }
            catch (Throwable var13) {
                try {
                    LOGGER.error((Object)var13);
                    flag = false;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    IOUtils.closeQuietly(outputstream);
                }
            }
            IOUtils.closeQuietly((OutputStream)outputstream);
            return flag;
        }
        return false;
    }

    public void remove(ResourceLocation templatePath) {
        this.templates.remove(templatePath.func_110623_a());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readTemplateFromSchematic(ResourceLocation server) {
        boolean flag;
        String s = server.func_110623_a();
        File file1 = new File(this.baseFolder, s + ".schematic");
        if (!file1.exists()) {
            return false;
        }
        FileInputStream inputstream = null;
        try {
            inputstream = new FileInputStream(file1);
            NBTTagCompound schematicNBT = CompressedStreamTools.func_74796_a((InputStream)inputstream);
            CapsuleTemplate template = new CapsuleTemplate();
            template.readSchematic(schematicNBT);
            this.templates.put(s, template);
            flag = true;
        }
        catch (Throwable var10) {
            try {
                flag = false;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputstream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)inputstream);
        }
        IOUtils.closeQuietly((InputStream)inputstream);
        return flag;
    }

    public boolean deleteTemplate(@Nullable MinecraftServer server, ResourceLocation id) {
        String s = id.func_110623_a();
        if (server != null && this.templates.containsKey(s)) {
            File file1 = new File(this.baseFolder);
            if (!file1.exists()) {
                return true;
            }
            if (!file1.isDirectory()) {
                return true;
            }
            File file2 = new File(file1, s + ".nbt");
            boolean deleted = file2.delete();
            if (deleted) {
                this.remove(id);
            }
            return deleted;
        }
        return false;
    }
}

