/*
 * Decompiled with CFR 0.152.
 */
package capsule;

import capsule.Config;
import capsule.command.CapsuleCommand;
import capsule.gui.LabelGui;
import capsule.itemGroups.CapsuleItemGroups;
import capsule.recipes.PrefabsBlueprintAggregatorRecipe;
import com.mojang.brigadier.CommandDispatcher;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemGroup;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="capsule")
public class CapsuleMod {
    protected static final Logger LOGGER = LogManager.getLogger(CapsuleMod.class);
    public static final String MODID = "capsule";
    public static ItemGroup tabCapsule = new CapsuleItemGroups(ItemGroup.getGroupCountSafe(), "capsule");
    public static Consumer<PlayerEntity> openGuiScreenCommon = (Consumer)DistExecutor.runForDist(() -> () -> CapsuleMod::openGuiScreenClient, () -> () -> CapsuleMod::openGuiScreenServer);
    public static MinecraftServer server = null;

    public CapsuleMod() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, Config.COMMON_CONFIG);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, CapsuleMod::serverStarting);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, CapsuleMod::serverStopped);
    }

    public static void serverStarting(FMLServerStartingEvent e) {
        CapsuleCommand.register((CommandDispatcher<CommandSource>)e.getCommandDispatcher());
        server = e.getServer();
        Config.populateConfigFolders(server);
        if (PrefabsBlueprintAggregatorRecipe.instance != null) {
            PrefabsBlueprintAggregatorRecipe.instance.populateRecipes(server);
        }
    }

    public static void serverStopped(FMLServerStoppedEvent e) {
        server = null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void openGuiScreenClient(PlayerEntity player) {
        LabelGui screen = new LabelGui(player);
        Minecraft.func_71410_x().func_147108_a((Screen)screen);
    }

    public static void openGuiScreenServer(PlayerEntity player) {
    }
}

