/*
 * Decompiled with CFR 0.152.
 */
package capsule;

import capsule.CapsuleSavedData;
import capsule.Config;
import capsule.items.CapsuleItem;
import capsule.structure.CapsuleTemplate;
import capsule.structure.CapsuleTemplateManager;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.minecart.ContainerMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IClearable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.datafix.DataFixesManager;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StructureSaver {
    protected static final Logger LOGGER = LogManager.getLogger(StructureSaver.class);
    public static final String BLUEPRINT_PREFIX = "b-";
    public static Map<String, CapsuleTemplateManager> CapsulesManagers = new HashMap<String, CapsuleTemplateManager>();
    private static CapsuleTemplateManager RewardManager = null;
    private static final List<String> outExcluded = new ArrayList<String>();

    public static CapsuleTemplateManager getRewardManager(MinecraftServer server) {
        if (RewardManager == null) {
            RewardManager = new CapsuleTemplateManager(server, server.func_71238_n(), DataFixesManager.func_210901_a());
            File rewardDir = new File(Config.rewardTemplatesPath);
            if (!rewardDir.exists()) {
                rewardDir.mkdirs();
            }
        }
        return RewardManager;
    }

    public static CapsuleTemplate undeploy(ServerWorld worldserver, UUID playerID, String capsuleStructureId, BlockPos startPos, int size, List<Block> excluded, Map<BlockPos, Block> legacyItemOccupied) {
        boolean writingOK;
        MinecraftServer minecraftserver = worldserver.func_73046_m();
        if (minecraftserver == null) {
            LOGGER.error("worldserver.getServer() returned null");
            return null;
        }
        ArrayList<Entity> outCapturedEntities = new ArrayList<Entity>();
        CapsuleTemplateManager templatemanager = StructureSaver.getTemplateManager(worldserver);
        if (templatemanager == null) {
            LOGGER.error("getTemplateManager returned null");
            return null;
        }
        CapsuleTemplate template = templatemanager.getTemplateDefaulted(new ResourceLocation(capsuleStructureId));
        Map<BlockPos, Block> occupiedPositions = template.occupiedPositions;
        if (legacyItemOccupied != null) {
            occupiedPositions = legacyItemOccupied;
        }
        List<BlockPos> transferedPositions = template.snapshotBlocksFromWorld((World)worldserver, startPos, new BlockPos(size, size, size), occupiedPositions, excluded, outCapturedEntities);
        template.removeOccupiedPositions();
        PlayerEntity player = null;
        if (playerID != null && (player = worldserver.func_217371_b(playerID)) != null) {
            template.setAuthor(player.func_146103_bH().getName());
        }
        if (writingOK = templatemanager.writeToFile(new ResourceLocation(capsuleStructureId))) {
            List<BlockPos> couldNotBeRemoved = StructureSaver.removeTransferedBlockFromWorld(transferedPositions, worldserver, player);
            for (Entity e : outCapturedEntities) {
                if (e instanceof ContainerMinecartEntity) {
                    ContainerMinecartEntity eMinecart = (ContainerMinecartEntity)e;
                    eMinecart.dropContentsWhenDead(false);
                }
                e.func_70106_y();
            }
            if (couldNotBeRemoved != null) {
                template.removeBlocks(couldNotBeRemoved, startPos);
            }
            templatemanager.writeToFile(new ResourceLocation(capsuleStructureId));
        } else {
            StructureSaver.printWriteTemplateError(player, capsuleStructureId);
        }
        return template;
    }

    public static boolean undeployBlueprint(ServerWorld worldserver, UUID playerID, ItemStack blueprintItemStack, BlockPos startPos, int size, List<Block> excluded) {
        MinecraftServer minecraftserver = worldserver.func_73046_m();
        if (minecraftserver == null) {
            return false;
        }
        Pair<CapsuleTemplateManager, CapsuleTemplate> blueprint = StructureSaver.getTemplate(blueprintItemStack, worldserver);
        CapsuleTemplate blueprintTemplate = (CapsuleTemplate)blueprint.getRight();
        if (blueprintTemplate == null) {
            return false;
        }
        CapsuleTemplate tempTemplate = new CapsuleTemplate();
        Map<BlockPos, Block> occupiedPositions = blueprintTemplate.occupiedPositions;
        Map<BlockPos, Block> legacyItemOccupied = CapsuleItem.getOccupiedSourcePos(blueprintItemStack);
        if (legacyItemOccupied != null) {
            occupiedPositions = legacyItemOccupied;
        }
        List<BlockPos> transferedPositions = tempTemplate.snapshotBlocksFromWorld((World)worldserver, startPos, new BlockPos(size, size, size), occupiedPositions, excluded, null);
        List worldBlocks = tempTemplate.getBlocks().stream().filter(b -> !StructureSaver.isFlowingLiquid(b)).collect(Collectors.toList());
        List blueprintBLocks = blueprintTemplate.getBlocks().stream().filter(b -> !StructureSaver.isFlowingLiquid(b)).collect(Collectors.toList());
        PlayerEntity player = null;
        if (playerID != null) {
            player = worldserver.func_217371_b(playerID);
        }
        if (blueprintBLocks.size() != worldBlocks.size()) {
            return false;
        }
        List tempTemplateSorted = worldBlocks.stream().map(StructureSaver::serializeComparable).sorted().collect(Collectors.toList());
        List blueprintTemplateSorted = blueprintBLocks.stream().map(StructureSaver::serializeComparable).sorted().collect(Collectors.toList());
        boolean blueprintMatch = IntStream.range(0, tempTemplateSorted.size()).allMatch(i -> ((String)tempTemplateSorted.get(i)).equals(blueprintTemplateSorted.get(i)));
        boolean bl = blueprintMatch = blueprintMatch && worldBlocks.stream().allMatch(b -> b.field_186244_c == null || !b.field_186244_c.func_74764_b("Items") || b.field_186244_c.func_150295_c("Items", 10).isEmpty());
        if (blueprintMatch) {
            blueprintTemplate.removeOccupiedPositions();
            String capsuleStructureId = CapsuleItem.getStructureName(blueprintItemStack);
            boolean written = ((CapsuleTemplateManager)blueprint.getLeft()).writeToFile(new ResourceLocation(capsuleStructureId));
            if (written) {
                List<BlockPos> couldNotBeRemoved = StructureSaver.removeTransferedBlockFromWorld(transferedPositions, worldserver, player);
                if (couldNotBeRemoved != null) {
                    return false;
                }
            } else {
                StructureSaver.printWriteTemplateError(player, capsuleStructureId);
            }
        }
        return blueprintMatch;
    }

    public static String serializeComparable(Template.BlockInfo b) {
        return b.field_186243_b.func_177230_c().func_149739_a() + "@" + b.field_186243_b.func_177230_c().func_176223_P() + (b.field_186244_c == null ? "" : StructureSaver.nbtStringNotEmpty(StructureSaver.filterIdentityNBT(b)));
    }

    public static CompoundNBT filterIdentityNBT(Template.BlockInfo b) {
        CompoundNBT nbt = b.field_186244_c.func_74737_b();
        List<String> converted = Config.getBlueprintIdentityNBT(b.field_186243_b.func_177230_c());
        nbt.func_150296_c().removeIf(key -> converted == null || !converted.contains(key));
        return nbt;
    }

    public static String nbtStringNotEmpty(CompoundNBT nbt) {
        if (nbt.isEmpty()) {
            return "";
        }
        return nbt.toString();
    }

    public static boolean isFlowingLiquid(Template.BlockInfo b) {
        return b.field_186243_b.func_177230_c() instanceof FlowingFluidBlock && (Integer)b.field_186243_b.func_177229_b((IProperty)FlowingFluidBlock.field_176367_b) != 0;
    }

    @Nullable
    public static CapsuleTemplateManager getTemplateManager(ServerWorld world) {
        if (world == null) {
            return null;
        }
        File directory = world.func_217485_w().func_75765_b();
        String directoryPath = directory.getPath();
        if (!CapsulesManagers.containsKey(directoryPath)) {
            File capsuleDir = new File(directory, "generated/capsules/structures");
            capsuleDir.mkdirs();
            CapsulesManagers.put(directoryPath, new CapsuleTemplateManager(world.func_73046_m(), capsuleDir, DataFixesManager.func_210901_a()));
        }
        return CapsulesManagers.get(directoryPath);
    }

    public static List<BlockPos> removeTransferedBlockFromWorld(List<BlockPos> transferedPositions, ServerWorld world, PlayerEntity player) {
        ArrayList<BlockPos> couldNotBeRemoved = null;
        GameRules.BooleanValue entityDropsGameRule = (GameRules.BooleanValue)world.func_82736_K().func_223585_a(GameRules.field_223604_g);
        GameRules.BooleanValue tileDropsGameRule = (GameRules.BooleanValue)world.func_82736_K().func_223585_a(GameRules.field_223603_f);
        boolean flagdoEntityDrops = world.func_82736_K().func_223586_b(GameRules.field_223604_g);
        boolean flagdoTileDrops = world.func_82736_K().func_223586_b(GameRules.field_223603_f);
        entityDropsGameRule.func_223570_a(false, world.func_73046_m());
        tileDropsGameRule.func_223570_a(false, world.func_73046_m());
        world.restoringBlockSnapshots = true;
        for (BlockPos pos : transferedPositions) {
            BlockState b = world.func_180495_p(pos);
            try {
                if (StructureSaver.playerCanRemove(world, pos, player)) {
                    TileEntity tileentity;
                    TileEntity tileEntity = tileentity = b.hasTileEntity() ? world.func_175625_s(pos) : null;
                    if (tileentity != null) {
                        IClearable.func_213131_a((Object)tileentity);
                        world.func_180501_a(pos, Blocks.field_180401_cv.func_176223_P(), 20);
                    }
                    world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                    continue;
                }
                if (couldNotBeRemoved == null) {
                    couldNotBeRemoved = new ArrayList<BlockPos>();
                }
                couldNotBeRemoved.add(pos);
            }
            catch (Exception e) {
                StructureSaver.printDeployError(player, e, "Block crashed during Capsule capture phase : couldn't be removed. Will be ignored.");
                try {
                    world.func_175656_a(pos, b);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (couldNotBeRemoved == null) {
                    couldNotBeRemoved = new ArrayList();
                }
                couldNotBeRemoved.add(pos);
            }
        }
        world.restoringBlockSnapshots = false;
        entityDropsGameRule.func_223570_a(flagdoEntityDrops, world.func_73046_m());
        tileDropsGameRule.func_223570_a(flagdoTileDrops, world.func_73046_m());
        return couldNotBeRemoved;
    }

    public static boolean deploy(ItemStack capsule, ServerWorld playerWorld, UUID thrower, BlockPos dest, List<Block> overridableBlocks, List<UUID> outEntityBlocking, PlacementSettings placementsettings) {
        Pair<CapsuleTemplateManager, CapsuleTemplate> templatepair = StructureSaver.getTemplate(capsule, playerWorld);
        CapsuleTemplate template = (CapsuleTemplate)templatepair.getRight();
        if (template == null) {
            return false;
        }
        ServerPlayerEntity player = null;
        if (thrower != null) {
            player = playerWorld.func_73046_m().func_184103_al().func_177451_a(thrower);
        }
        HashMap<BlockPos, Block> outOccupiedSpawnPositions = new HashMap<BlockPos, Block>();
        int size = CapsuleItem.getSize(capsule);
        ArrayList<ITextComponent> outErrors = new ArrayList<ITextComponent>();
        StructureSaver.checkDestination(template, placementsettings, playerWorld, dest, size, overridableBlocks, outOccupiedSpawnPositions, outErrors);
        if (outErrors.size() > 0) {
            if (player != null) {
                StructureSaver.printDeployFailure((PlayerEntity)player, outErrors);
            }
            return false;
        }
        if (player != null && !StructureSaver.playerCanPlace(playerWorld, dest, template, (PlayerEntity)player, placementsettings)) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("capsule.error.notAllowed", new Object[0]));
            return false;
        }
        HashMap<BlockPos, Block> occupiedPositions = outOccupiedSpawnPositions;
        ArrayList<BlockPos> spawnedBlocks = new ArrayList<BlockPos>();
        ArrayList<Entity> spawnedEntities = new ArrayList<Entity>();
        CapsuleTemplateManager templateManager = (CapsuleTemplateManager)templatepair.getLeft();
        String capsuleStructureId = CapsuleItem.getStructureName(capsule);
        template.saveOccupiedPositions(occupiedPositions);
        if (!templateManager.writeToFile(new ResourceLocation(capsuleStructureId))) {
            StructureSaver.printWriteTemplateError((PlayerEntity)player, capsuleStructureId);
            return false;
        }
        try {
            template.spawnBlocksAndEntities((World)playerWorld, dest, placementsettings, occupiedPositions, overridableBlocks, spawnedBlocks, spawnedEntities);
            StructureSaver.placePlayerOnTop(playerWorld, dest, size);
            return true;
        }
        catch (Exception err) {
            StructureSaver.printDeployError((PlayerEntity)player, err, "Couldn't deploy the capsule");
            StructureSaver.removeTransferedBlockFromWorld(spawnedBlocks, playerWorld, (PlayerEntity)player);
            template.removeOccupiedPositions();
            if (!templateManager.writeToFile(new ResourceLocation(capsuleStructureId))) {
                StructureSaver.printWriteTemplateError((PlayerEntity)player, capsuleStructureId);
            }
            for (Entity e : spawnedEntities) {
                if (e instanceof ContainerMinecartEntity) {
                    ContainerMinecartEntity eMinecart = (ContainerMinecartEntity)e;
                    eMinecart.dropContentsWhenDead(false);
                }
                e.func_70106_y();
            }
            return false;
        }
    }

    private static void printDeployFailure(PlayerEntity player, List<ITextComponent> outErrors) {
        StringTextComponent msg = new StringTextComponent("");
        int outErrorsSize = outErrors.size();
        for (int i = 0; i < outErrorsSize; ++i) {
            ITextComponent outError = outErrors.get(i);
            msg.func_150257_a(outError);
            if (i >= outErrors.size() - 1) continue;
            msg.func_150258_a("\n");
        }
        player.func_145747_a((ITextComponent)msg);
    }

    public static void placePlayerOnTop(ServerWorld playerWorld, BlockPos dest, int size) {
        List players = playerWorld.func_175647_a(LivingEntity.class, new AxisAlignedBB((double)dest.func_177958_n(), (double)dest.func_177956_o(), (double)dest.func_177952_p(), (double)(dest.func_177958_n() + size), (double)(dest.func_177956_o() + size), (double)(dest.func_177952_p() + size)), entity -> entity instanceof PlayerEntity);
        for (LivingEntity p : players) {
            for (int y = 0; y < size; ++y) {
                if (!playerWorld.func_72829_c(p.func_174813_aQ())) continue;
                p.func_70634_a(p.func_226277_ct_(), p.func_226278_cu_() + 1.0, p.func_226281_cx_());
            }
        }
    }

    public static void printDeployError(PlayerEntity player, Exception err, String s) {
        LOGGER.error(s, (Throwable)err);
        if (player != null) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("capsule.error.technicalError", new Object[0]));
        }
    }

    public static void printWriteTemplateError(PlayerEntity player, String capsuleStructureId) {
        LOGGER.error("Couldn't write template " + capsuleStructureId);
        if (player != null) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("capsule.error.technicalError", new Object[0]));
        }
    }

    private static boolean playerCanPlace(ServerWorld worldserver, BlockPos dest, CapsuleTemplate template, PlayerEntity player, PlacementSettings placementsettings) {
        if (player != null) {
            List<BlockPos> expectedOut = template.calculateDeployPositions((World)worldserver, dest, placementsettings);
            for (BlockPos blockPos : expectedOut) {
                if (blockPos.func_177956_o() < worldserver.func_217301_I() && StructureSaver.isEntityPlaceEventAllowed(worldserver, blockPos, player)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean playerCanRemove(ServerWorld worldserver, BlockPos blockPos, PlayerEntity player) {
        if (player != null) {
            return StructureSaver.isEntityPlaceEventAllowed(worldserver, blockPos, player);
        }
        return true;
    }

    private static boolean isEntityPlaceEventAllowed(ServerWorld worldserver, BlockPos blockPos, PlayerEntity player) {
        BlockSnapshot blocksnapshot = new BlockSnapshot((IWorld)worldserver, blockPos, Blocks.field_150350_a.func_176223_P());
        BlockEvent.EntityPlaceEvent event = new BlockEvent.EntityPlaceEvent(blocksnapshot, Blocks.field_150346_d.func_176223_P(), (Entity)player);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return !event.isCanceled();
    }

    public static Pair<CapsuleTemplateManager, CapsuleTemplate> getTemplate(ItemStack capsule, ServerWorld playerWorld) {
        Pair<CapsuleTemplateManager, CapsuleTemplate> template = null;
        boolean isReward = CapsuleItem.isReward(capsule);
        String structureName = CapsuleItem.getStructureName(capsule);
        template = isReward || structureName.startsWith("config/") && CapsuleItem.isBlueprint(capsule) ? StructureSaver.getTemplateForReward(playerWorld.func_73046_m(), structureName) : StructureSaver.getTemplateForCapsule(playerWorld, structureName);
        return template;
    }

    public static Pair<CapsuleTemplateManager, CapsuleTemplate> getTemplateForCapsule(ServerWorld playerWorld, String structurePath) {
        CapsuleTemplateManager templatemanager = StructureSaver.getTemplateManager(playerWorld);
        if (templatemanager == null || StringUtils.func_151246_b((String)structurePath)) {
            return Pair.of(null, null);
        }
        String path = structurePath.toLowerCase();
        CapsuleTemplate template = templatemanager.getTemplateDefaulted(new ResourceLocation(path));
        return Pair.of((Object)templatemanager, (Object)template);
    }

    public static Pair<CapsuleTemplateManager, CapsuleTemplate> getTemplateForReward(MinecraftServer server, String structurePath) {
        CapsuleTemplateManager templatemanager = StructureSaver.getRewardManager(server);
        if (templatemanager == null || StringUtils.func_151246_b((String)structurePath)) {
            return Pair.of(null, null);
        }
        String path = structurePath.toLowerCase();
        CapsuleTemplate template = templatemanager.getTemplateDefaulted(new ResourceLocation(path));
        return Pair.of((Object)templatemanager, (Object)template);
    }

    public static void checkDestination(CapsuleTemplate template, PlacementSettings placementIn, ServerWorld destWorld, BlockPos destOriginPos, int size, List<Block> overridable, Map<BlockPos, Block> outOccupiedPositions, List<ITextComponent> outErrors) {
        BlockState air = Blocks.field_150350_a.func_176223_P();
        List<Template.BlockInfo> srcblocks = template.getBlocks();
        HashMap<BlockPos, Template.BlockInfo> blockInfoByPosition = new HashMap<BlockPos, Template.BlockInfo>();
        for (Template.BlockInfo template$blockinfo : srcblocks) {
            BlockPos blockpos = CapsuleTemplate.transformedBlockPos(placementIn, template$blockinfo.field_186242_a).func_177971_a((Vec3i)destOriginPos).func_177971_a((Vec3i)CapsuleTemplate.recenterRotation((size - 1) / 2, placementIn));
            blockInfoByPosition.put(blockpos, template$blockinfo);
        }
        for (int y = size - 1; y >= 0; --y) {
            for (int x = 0; x < size; ++x) {
                for (int z = 0; z < size; ++z) {
                    boolean worldDestOccupied;
                    BlockPos destPos = destOriginPos.func_177982_a(x, y, z);
                    Template.BlockInfo srcInfo = (Template.BlockInfo)blockInfoByPosition.get(destPos);
                    BlockState templateBlockState = air;
                    if (srcInfo != null) {
                        templateBlockState = srcInfo.field_186243_b;
                    }
                    if (!destWorld.func_175667_e(destPos)) {
                        outErrors.add((ITextComponent)new TranslationTextComponent("capsule.error.areaNotLoaded", new Object[0]));
                        return;
                    }
                    BlockState worldDestState = destWorld.func_180495_p(destPos);
                    boolean bl = worldDestOccupied = !worldDestState.isAir((IBlockReader)destWorld, destPos) && !overridable.contains(worldDestState.func_177230_c());
                    if (!worldDestState.isAir((IBlockReader)destWorld, destPos) && outOccupiedPositions != null) {
                        outOccupiedPositions.put(destPos, worldDestState.func_177230_c());
                    }
                    boolean srcOccupied = !templateBlockState.isAir((IBlockReader)destWorld, destPos) && !overridable.contains(templateBlockState.func_177230_c());
                    List entities = destWorld.func_175647_a(LivingEntity.class, new AxisAlignedBB((double)destPos.func_177958_n(), (double)destPos.func_177956_o(), (double)destPos.func_177952_p(), (double)(destPos.func_177958_n() + 1), (double)(destPos.func_177956_o() + 1), (double)(destPos.func_177952_p() + 1)), entity -> !(entity instanceof PlayerEntity));
                    if (entities.size() > 0 && srcOccupied) {
                        boolean found = false;
                        for (Object e : entities) {
                            Entity entity2 = (Entity)e;
                            if (entity2 == null) continue;
                            outErrors.add((ITextComponent)new TranslationTextComponent("capsule.error.cantMergeWithDestinationEntity", new Object[]{entity2.func_145748_c_()}));
                            found = true;
                        }
                        if (!found) {
                            outErrors.add((ITextComponent)new TranslationTextComponent("capsule.error.cantMergeWithDestinationEntity", new Object[]{"???"}));
                        }
                        return;
                    }
                    if (!worldDestOccupied || overridable.contains(templateBlockState.func_177230_c())) continue;
                    outErrors.add((ITextComponent)new TranslationTextComponent("capsule.error.cantMergeWithDestination", new Object[]{destPos.toString()}));
                    return;
                }
            }
        }
    }

    public static String getUniqueName(ServerWorld playerWorld, String player) {
        CapsuleSavedData csd = StructureSaver.getCapsuleSavedData(playerWorld);
        String p = player.toLowerCase();
        String capsuleID = "c-" + p + "-" + csd.getNextCount();
        CapsuleTemplateManager templatemanager = StructureSaver.getTemplateManager(playerWorld);
        if (templatemanager == null) {
            LOGGER.error("getTemplateManager returned null");
            return "cexception-" + p + "-" + csd.getNextCount();
        }
        while (templatemanager.getTemplate(new ResourceLocation(capsuleID)) != null) {
            capsuleID = "c-" + p + "-" + csd.getNextCount();
        }
        return capsuleID;
    }

    public static String getBlueprintUniqueName(ServerWorld world) {
        CapsuleSavedData csd = StructureSaver.getCapsuleSavedData(world);
        String capsuleID = BLUEPRINT_PREFIX + csd.getNextCount();
        CapsuleTemplateManager templatemanager = StructureSaver.getTemplateManager(world);
        if (templatemanager == null) {
            LOGGER.error("getTemplateManager returned null");
            return "bexception-" + csd.getNextCount();
        }
        while (templatemanager.getTemplate(new ResourceLocation(capsuleID)) != null) {
            capsuleID = BLUEPRINT_PREFIX + csd.getNextCount();
        }
        return capsuleID;
    }

    public static boolean copyFromCapsuleTemplate(ItemStack capsule, String destinationStructureName, CapsuleTemplateManager destManager, ServerWorld worldServer, boolean onlyBlocks, List<String> outExcluded) {
        CompoundNBT srcTemplateData = StructureSaver.getTemplateNBTData(capsule, worldServer);
        if (srcTemplateData == null) {
            return false;
        }
        return StructureSaver.duplicateTemplate(srcTemplateData, destinationStructureName, destManager, onlyBlocks, outExcluded);
    }

    public static boolean duplicateTemplate(CompoundNBT templateData, String destinationStructureName, CapsuleTemplateManager destManager, MinecraftServer server) {
        return StructureSaver.duplicateTemplate(templateData, destinationStructureName, destManager, false, null);
    }

    public static boolean duplicateTemplate(CompoundNBT templateData, String destinationStructureName, CapsuleTemplateManager destManager, boolean onlyWhitelisted, List<String> outExcluded) {
        String sanitized = destinationStructureName.toLowerCase();
        ResourceLocation destinationLocation = new ResourceLocation(sanitized);
        CapsuleTemplate destTemplate = destManager.getTemplateDefaulted(destinationLocation);
        destTemplate.read(templateData);
        destTemplate.occupiedPositions = null;
        if (onlyWhitelisted) {
            destTemplate.filterFromWhitelist(Config.blueprintWhitelist, outExcluded);
        }
        return destManager.writeToFile(destinationLocation);
    }

    public static CompoundNBT getTemplateNBTData(ItemStack capsule, ServerWorld worldServer) {
        return StructureSaver.getTemplateNBTData((CapsuleTemplate)StructureSaver.getTemplate(capsule, worldServer).getRight());
    }

    public static CompoundNBT getTemplateNBTData(String path, ServerWorld worldServer) {
        Pair<CapsuleTemplateManager, CapsuleTemplate> sourcetemplatepair = path.startsWith(Config.rewardTemplatesPath) || path.startsWith("config/") ? StructureSaver.getTemplateForReward(worldServer.func_73046_m(), path) : StructureSaver.getTemplateForCapsule(worldServer, path);
        return StructureSaver.getTemplateNBTData((CapsuleTemplate)sourcetemplatepair.getRight());
    }

    public static CompoundNBT getTemplateNBTData(CapsuleTemplate template) {
        if (template == null) {
            return null;
        }
        CompoundNBT data = new CompoundNBT();
        template.writeToNBT(data);
        return data;
    }

    public static CapsuleSavedData getCapsuleSavedData(ServerWorld capsuleWorld) {
        return (CapsuleSavedData)capsuleWorld.func_217481_x().func_215752_a(CapsuleSavedData::new, "capsuleData");
    }

    @Nullable
    public static String createBlueprintTemplate(String srcStructurePath, ItemStack destCapsule, ServerWorld worldServer, PlayerEntity playerIn) {
        boolean created;
        if (worldServer == null) {
            LOGGER.error("worldServer is null");
            return null;
        }
        String destStructureName = StructureSaver.getBlueprintUniqueName(worldServer) + "-" + srcStructurePath.replace("/", "_");
        CapsuleTemplateManager templateManager = StructureSaver.getTemplateManager(worldServer);
        outExcluded.clear();
        boolean bl = created = templateManager != null && StructureSaver.duplicateTemplate(StructureSaver.getTemplateNBTData(srcStructurePath, worldServer), destStructureName, templateManager, true, outExcluded);
        if (destCapsule.func_77978_p() != null && destCapsule.func_77978_p().func_74764_b("prevStructureName") && templateManager != null) {
            templateManager.deleteTemplate(new ResourceLocation(destCapsule.func_77978_p().func_74779_i("prevStructureName")));
        }
        if (!created && playerIn != null) {
            playerIn.func_145747_a((ITextComponent)new TranslationTextComponent("capsule.error.blueprintCreationError", new Object[0]));
        }
        if (outExcluded.size() > 0 && playerIn != null) {
            playerIn.func_145747_a((ITextComponent)new TranslationTextComponent("capsule.error.blueprintExcluded", new Object[]{"\n* " + String.join((CharSequence)"\n* ", outExcluded)}));
        }
        return destStructureName;
    }

    public static class ItemStackKey
    implements Comparable<ItemStackKey> {
        public ItemStack itemStack;

        public ItemStackKey(ItemStack itemStack) {
            this.itemStack = itemStack;
        }

        public boolean equals(Object someOther) {
            if (!(someOther instanceof ItemStackKey)) {
                return false;
            }
            ItemStack otherStack = ((ItemStackKey)someOther).itemStack;
            return otherStack.func_77969_a(this.itemStack) && (!otherStack.func_77942_o() && !this.itemStack.func_77942_o() || otherStack.func_77978_p().equals((Object)this.itemStack.func_77978_p()));
        }

        public int hashCode() {
            int val = this.itemStack.func_77973_b().hashCode() * 29 + CapsuleItem.getState(this.itemStack).getValue();
            return val;
        }

        @Override
        public int compareTo(ItemStackKey o) {
            if (o == null || o.itemStack == null) {
                return 1;
            }
            return this.equals(o) ? 0 : ItemStackKey.serializeItemStack(this.itemStack).compareTo(ItemStackKey.serializeItemStack(o.itemStack));
        }

        public static String serializeItemStack(ItemStack itemstack) {
            return itemstack.func_77973_b().func_77658_a() + "@" + (Object)((Object)CapsuleItem.getState(itemstack));
        }
    }
}

