/*
 * Decompiled with CFR 0.152.
 */
package capsule.blocks;

import capsule.CapsuleMod;
import capsule.blocks.BlockCapsuleMarker;
import capsule.blocks.BlockCaptureCrasher;
import capsule.blocks.BlockDeployCrasher;
import capsule.blocks.CaptureTESR;
import capsule.blocks.TileEntityCapture;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class CapsuleBlocks {
    private static final ResourceLocation CAPSULE_MARKER_REGISTERY_NAME = new ResourceLocation("capsule", "capsulemarker");
    public static final ResourceLocation CAPSULE_MARKER_TE_REGISTERY_NAME = new ResourceLocation("capsule", "capsulemarker_te");
    public static BlockCapsuleMarker CAPSULE_MARKER;
    public static TileEntityType<TileEntityCapture> MARKER_TE;
    public static BlockCaptureCrasher blockCaptureCrasher;
    public static final String CAPTURE_CRASHER_REGISTERY_NAME = "capturecrasher";
    public static BlockDeployCrasher blockDeployCrasher;
    public static final String DEPLOY_CRASHER_REGISTERY_NAME = "deploycrasher";

    private static <T extends TileEntity> TileEntityType<T> buildTileEntity(Supplier<T> supplier, ResourceLocation name, Block ... blocks) {
        TileEntityType te = TileEntityType.Builder.func_223042_a(supplier, (Block[])blocks).func_206865_a(null);
        te.setRegistryName(name);
        return te;
    }

    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        CAPSULE_MARKER = new BlockCapsuleMarker();
        CAPSULE_MARKER.setRegistryName(CAPSULE_MARKER_REGISTERY_NAME);
        event.getRegistry().register((IForgeRegistryEntry)CAPSULE_MARKER);
        Map<String, String> env = System.getenv();
        if ("DEV".equals(env.get("__ENV__"))) {
            blockCaptureCrasher = new BlockCaptureCrasher();
            blockCaptureCrasher.setRegistryName(CAPTURE_CRASHER_REGISTERY_NAME);
            event.getRegistry().register((IForgeRegistryEntry)blockCaptureCrasher);
            blockDeployCrasher = new BlockDeployCrasher();
            blockDeployCrasher.setRegistryName(DEPLOY_CRASHER_REGISTERY_NAME);
            event.getRegistry().register((IForgeRegistryEntry)blockDeployCrasher);
        }
    }

    public static void registerItemBlocks(RegistryEvent.Register<Item> event) {
        BlockItem markerItem = new BlockItem((Block)CAPSULE_MARKER, new Item.Properties().func_200916_a(CapsuleMod.tabCapsule));
        markerItem.setRegistryName(CAPSULE_MARKER_REGISTERY_NAME);
        event.getRegistry().register((IForgeRegistryEntry)markerItem);
        Map<String, String> env = System.getenv();
        if ("DEV".equals(env.get("__ENV__"))) {
            event.getRegistry().register(new BlockItem((Block)blockCaptureCrasher, new Item.Properties().func_200916_a(CapsuleMod.tabCapsule)).setRegistryName(blockCaptureCrasher.getRegistryName()));
            event.getRegistry().register(new BlockItem((Block)blockDeployCrasher, new Item.Properties().func_200916_a(CapsuleMod.tabCapsule)).setRegistryName(blockDeployCrasher.getRegistryName()));
        }
    }

    public static void registerTileEntities(RegistryEvent.Register<TileEntityType<?>> event) {
        MARKER_TE = CapsuleBlocks.buildTileEntity(TileEntityCapture::new, CAPSULE_MARKER_TE_REGISTERY_NAME, CAPSULE_MARKER);
        event.getRegistry().register(MARKER_TE);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void bindTileEntitiesRenderer() {
        ClientRegistry.bindTileEntityRenderer(MARKER_TE, CaptureTESR::new);
    }
}

