/*
 * Decompiled with CFR 0.152.
 */
package capsule.client;

import capsule.Config;
import capsule.blocks.BlockCapsuleMarker;
import capsule.blocks.CaptureTESR;
import capsule.blocks.TileEntityCapture;
import capsule.client.RendererUtils;
import capsule.helpers.Spacial;
import capsule.items.CapsuleItem;
import capsule.structure.CapsuleTemplate;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="capsule", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class CapsulePreviewHandler {
    public static final Map<String, List<AxisAlignedBB>> currentPreview = new HashMap<String, List<AxisAlignedBB>>();
    private static int lastSize = 0;
    private static int lastColor = 0;

    @SubscribeEvent
    public static void onWorldRenderLast(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g != null) {
            CapsulePreviewHandler.tryPreviewRecall(mc.field_71439_g.func_184614_ca());
            CapsulePreviewHandler.tryPreviewDeploy(mc.field_71439_g, event.getPartialTicks(), mc.field_71439_g.func_184614_ca());
            CapsulePreviewHandler.tryPreviewLinkedInventory(mc.field_71439_g, mc.field_71439_g.func_184614_ca());
        }
    }

    @SubscribeEvent
    public static void onLivingUpdateEvent(TickEvent.PlayerTickEvent event) {
        if (event.player instanceof ClientPlayerEntity && event.phase.equals((Object)TickEvent.Phase.START)) {
            ClientPlayerEntity player = (ClientPlayerEntity)event.player;
            CapsulePreviewHandler.tryPreviewCapture(player, player.func_184614_ca());
        }
    }

    private static boolean tryPreviewCapture(ClientPlayerEntity player, ItemStack heldItem) {
        if (!heldItem.func_190926_b()) {
            Item heldItemItem = heldItem.func_77973_b();
            if (heldItemItem instanceof CapsuleItem && (CapsuleItem.hasState(heldItem, CapsuleItem.CapsuleState.EMPTY) || CapsuleItem.hasState(heldItem, CapsuleItem.CapsuleState.EMPTY_ACTIVATED))) {
                if (heldItem.func_77942_o() && heldItem.func_77978_p().func_74764_b("size")) {
                    CapsulePreviewHandler.setCaptureTESizeColor(heldItem.func_77978_p().func_74762_e("size"), CapsuleItem.getBaseColor(heldItem), player.func_130014_f_());
                    return true;
                }
            } else {
                CapsulePreviewHandler.setCaptureTESizeColor(0, 0, player.func_130014_f_());
            }
        } else {
            CapsulePreviewHandler.setCaptureTESizeColor(0, 0, player.func_130014_f_());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void tryPreviewDeploy(ClientPlayerEntity thePlayer, float partialTicks, ItemStack heldItemMainhand) {
        int size;
        BlockRayTraceResult rtc;
        if (heldItemMainhand.func_77973_b() instanceof CapsuleItem && heldItemMainhand.func_77942_o() && CapsulePreviewHandler.isDeployable(heldItemMainhand) && (rtc = Spacial.clientRayTracePreview((PlayerEntity)thePlayer, partialTicks, size = CapsuleItem.getSize(heldItemMainhand))) != null && rtc.func_216346_c() == RayTraceResult.Type.BLOCK) {
            int extendSize = (size - 1) / 2;
            BlockPos destOriginPos = rtc.func_216350_a().func_177971_a(rtc.func_216354_b().func_176730_m()).func_177963_a((double)(-extendSize), 0.01, (double)(-extendSize));
            String structureName = heldItemMainhand.func_77978_p().func_74779_i("structureName");
            AxisAlignedBB errorBoundingBox = new AxisAlignedBB(0.0, 0.01, 0.0, 1.01, 1.01, 1.01);
            Map<String, List<AxisAlignedBB>> map = currentPreview;
            synchronized (map) {
                if (currentPreview.containsKey(structureName) || size == 1) {
                    BlockPos pos;
                    List<Object> blockspos = new ArrayList();
                    if (size > 1) {
                        blockspos = currentPreview.get(structureName);
                    } else if (CapsuleItem.hasState(heldItemMainhand, CapsuleItem.CapsuleState.EMPTY)) {
                        pos = rtc.func_216350_a().func_177973_b((Vec3i)destOriginPos);
                        blockspos.add(new AxisAlignedBB(pos, pos));
                    }
                    if (blockspos.isEmpty()) {
                        pos = new BlockPos(extendSize, 0, extendSize);
                        blockspos.add(new AxisAlignedBB(pos, pos));
                    }
                    RendererUtils.doPositionPrologue(Minecraft.func_71410_x().func_175598_ae().field_217783_c);
                    RendererUtils.doWirePrologue();
                    Tessellator tessellator = Tessellator.func_178181_a();
                    BufferBuilder bufferBuilder = tessellator.func_178180_c();
                    PlacementSettings placement = CapsuleItem.getPlacement(heldItemMainhand);
                    for (AxisAlignedBB axisAlignedBB : blockspos) {
                        BlockPos recenter = CapsuleTemplate.recenterRotation(extendSize, placement);
                        AxisAlignedBB dest = CapsuleTemplate.transformedAxisAlignedBB(placement, axisAlignedBB).func_72317_d((double)destOriginPos.func_177958_n(), (double)destOriginPos.func_177956_o() + 0.01, (double)destOriginPos.func_177952_p()).func_72317_d((double)recenter.func_177958_n(), (double)recenter.func_177956_o(), (double)recenter.func_177952_p()).func_72321_a(1.0, 1.0, 1.0);
                        int color = 0xDDDDDD;
                        if (CapsuleItem.hasState(heldItemMainhand, CapsuleItem.CapsuleState.EMPTY)) {
                            GlStateManager.func_227701_d_((float)5.0f);
                            color = CapsuleItem.getBaseColor(heldItemMainhand);
                        } else {
                            for (double j = dest.field_72339_c; j < dest.field_72334_f; j += 1.0) {
                                for (double k = dest.field_72338_b; k < dest.field_72337_e; k += 1.0) {
                                    for (double l = dest.field_72340_a; l < dest.field_72336_d; l += 1.0) {
                                        BlockPos pos2 = new BlockPos(l, k, j);
                                        if (Config.overridableBlocks.contains(thePlayer.func_130014_f_().func_180495_p(pos2).func_177230_c())) continue;
                                        GlStateManager.func_227701_d_((float)5.0f);
                                        bufferBuilder.func_181668_a(2, DefaultVertexFormats.field_181705_e);
                                        RendererUtils.setColor(0xAA0000, 50);
                                        RendererUtils.drawCapsuleCube(errorBoundingBox.func_186670_a(pos2), bufferBuilder);
                                        tessellator.func_78381_a();
                                    }
                                }
                            }
                        }
                        GlStateManager.func_227701_d_((float)1.0f);
                        bufferBuilder.func_181668_a(2, DefaultVertexFormats.field_181705_e);
                        RendererUtils.setColor(color, 50);
                        RendererUtils.drawCapsuleCube(dest, bufferBuilder);
                        tessellator.func_78381_a();
                    }
                    RendererUtils.setColor(0xFFFFFF, 255);
                    RendererUtils.doWireEpilogue();
                    RendererUtils.doPositionEpilogue();
                }
            }
        }
    }

    private static boolean isDeployable(ItemStack heldItemMainhand) {
        return CapsuleItem.hasState(heldItemMainhand, CapsuleItem.CapsuleState.ACTIVATED) || CapsuleItem.hasState(heldItemMainhand, CapsuleItem.CapsuleState.ONE_USE_ACTIVATED) || CapsuleItem.hasState(heldItemMainhand, CapsuleItem.CapsuleState.BLUEPRINT) || CapsuleItem.getSize(heldItemMainhand) == 1 && !CapsuleItem.hasState(heldItemMainhand, CapsuleItem.CapsuleState.DEPLOYED);
    }

    private static void tryPreviewRecall(ItemStack heldItem) {
        Item heldItemItem;
        if (heldItem != null && (heldItemItem = heldItem.func_77973_b()) instanceof CapsuleItem && (CapsuleItem.hasState(heldItem, CapsuleItem.CapsuleState.DEPLOYED) || CapsuleItem.hasState(heldItem, CapsuleItem.CapsuleState.BLUEPRINT)) && heldItem.func_77942_o() && heldItem.func_77978_p().func_74764_b("spawnPosition")) {
            CapsulePreviewHandler.previewRecall(heldItem);
        }
    }

    private static void tryPreviewLinkedInventory(ClientPlayerEntity player, ItemStack heldItem) {
        Item heldItemItem;
        if (heldItem != null && (heldItemItem = heldItem.func_77973_b()) instanceof CapsuleItem && CapsuleItem.isBlueprint(heldItem) && CapsuleItem.hasSourceInventory(heldItem)) {
            BlockPos location = CapsuleItem.getSourceInventoryLocation(heldItem);
            Integer dimension = CapsuleItem.getSourceInventoryDimension(heldItem);
            if (location != null && dimension != null && dimension.equals(player.field_71093_bK.func_186068_a()) && location.func_218140_a(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), true) < 3600.0) {
                CapsulePreviewHandler.previewLinkedInventory(location, heldItem);
            }
        }
    }

    private static void previewLinkedInventory(BlockPos location, ItemStack capsule) {
        RendererUtils.doPositionPrologue(Minecraft.func_71410_x().func_175598_ae().field_217783_c);
        RendererUtils.doOverlayPrologue();
        RendererUtils.setColor(6003967, 80);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        RendererUtils.drawCube(location, 0.0f, bufferBuilder);
        tessellator.func_78381_a();
        RendererUtils.setColor(0xFFFFFF, 255);
        RendererUtils.doOverlayEpilogue();
        RendererUtils.doPositionEpilogue();
    }

    private static void previewRecall(ItemStack capsule) {
        if (capsule.func_77978_p() == null) {
            return;
        }
        CompoundNBT linkPos = capsule.func_77978_p().func_74775_l("spawnPosition");
        int size = CapsuleItem.getSize(capsule);
        int extendSize = (size - 1) / 2;
        int color = CapsuleItem.getBaseColor(capsule);
        CaptureTESR.drawCaptureZone(linkPos.func_74762_e("x") + extendSize, linkPos.func_74762_e("y") - 1, linkPos.func_74762_e("z") + extendSize, size, extendSize, color, Minecraft.func_71410_x().func_175598_ae().field_217783_c);
    }

    private static void setCaptureTESizeColor(int size, int color, World worldIn) {
        if (size == lastSize && color == lastColor) {
            return;
        }
        for (TileEntityCapture te : new ArrayList<TileEntityCapture>(TileEntityCapture.instances)) {
            TileEntityCapture tec;
            CompoundNBT teData;
            if (te.func_145831_w() != worldIn || (teData = (tec = te).getTileData()).func_74762_e("size") == size && teData.func_74762_e("color") == color) continue;
            tec.getTileData().func_74768_a("size", size);
            tec.getTileData().func_74768_a("color", color);
            if (!te.func_195044_w().func_196959_b(BlockCapsuleMarker.PROJECTING)) continue;
            worldIn.func_175656_a(te.func_174877_v(), (BlockState)te.func_195044_w().func_206870_a(BlockCapsuleMarker.PROJECTING, (Comparable)Boolean.valueOf(size > 0)));
        }
        lastSize = size;
        lastColor = color;
    }
}

