/*
 * Decompiled with CFR 0.152.
 */
package capsule.client;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

public class RendererUtils {
    public static void doPositionPrologue(ActiveRenderInfo info) {
        RenderSystem.pushMatrix();
        RenderSystem.rotatef((float)info.func_216777_e(), (float)1.0f, (float)0.0f, (float)0.0f);
        RenderSystem.rotatef((float)(info.func_216778_f() + 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        RenderSystem.translated((double)(-info.func_216785_c().field_72450_a), (double)(-info.func_216785_c().field_72448_b), (double)(-info.func_216785_c().field_72449_c));
    }

    public static void doPositionEpilogue() {
        RenderSystem.popMatrix();
    }

    public static void doOverlayPrologue() {
        RenderSystem.disableLighting();
        RenderSystem.disableTexture();
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
    }

    public static void doOverlayEpilogue() {
        RenderSystem.enableLighting();
        RenderSystem.enableTexture();
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
    }

    public static void doWirePrologue() {
        RenderSystem.disableCull();
        RenderSystem.disableLighting();
        RenderSystem.disableTexture();
        RenderSystem.lineWidth((float)3.0f);
    }

    public static void doWireEpilogue() {
        RenderSystem.lineWidth((float)1.0f);
        RenderSystem.enableTexture();
        RenderSystem.enableLighting();
        RenderSystem.enableCull();
    }

    public static void drawCube(BlockPos pos, float sizeOffset, BufferBuilder buffer) {
        RendererUtils.drawCube((float)pos.func_177958_n() - sizeOffset, (float)pos.func_177956_o() - sizeOffset, (float)pos.func_177952_p() - sizeOffset, (float)(pos.func_177958_n() + 1) + sizeOffset, (float)(pos.func_177956_o() + 1) + sizeOffset, (float)(pos.func_177952_p() + 1) + sizeOffset, buffer);
    }

    public static void drawCube(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, BufferBuilder buffer) {
        RendererUtils.drawPlaneNegX(minX, minY, maxY, minZ, maxZ, buffer);
        RendererUtils.drawPlanePosX(maxX, minY, maxY, minZ, maxZ, buffer);
        RendererUtils.drawPlaneNegY(minY, minX, maxX, minZ, maxZ, buffer);
        RendererUtils.drawPlanePosY(maxY, minX, maxX, minZ, maxZ, buffer);
        RendererUtils.drawPlaneNegZ(minZ, minX, maxX, minY, maxY, buffer);
        RendererUtils.drawPlanePosZ(maxZ, minX, maxX, minY, maxY, buffer);
    }

    public static void drawPlaneNegX(double x, double minY, double maxY, double minZ, double maxZ, BufferBuilder buffer) {
        buffer.func_225582_a_(x, minY, minZ).func_181675_d();
        buffer.func_225582_a_(x, minY, maxZ).func_181675_d();
        buffer.func_225582_a_(x, maxY, maxZ).func_181675_d();
        buffer.func_225582_a_(x, maxY, minZ).func_181675_d();
    }

    public static void drawPlanePosX(double x, double minY, double maxY, double minZ, double maxZ, BufferBuilder buffer) {
        buffer.func_225582_a_(x, minY, minZ).func_181675_d();
        buffer.func_225582_a_(x, maxY, minZ).func_181675_d();
        buffer.func_225582_a_(x, maxY, maxZ).func_181675_d();
        buffer.func_225582_a_(x, minY, maxZ).func_181675_d();
    }

    public static void drawPlaneNegY(double y, double minX, double maxX, double minZ, double maxZ, BufferBuilder buffer) {
        buffer.func_225582_a_(minX, y, minZ).func_181675_d();
        buffer.func_225582_a_(maxX, y, minZ).func_181675_d();
        buffer.func_225582_a_(maxX, y, maxZ).func_181675_d();
        buffer.func_225582_a_(minX, y, maxZ).func_181675_d();
    }

    public static void drawPlanePosY(double y, double minX, double maxX, double minZ, double maxZ, BufferBuilder buffer) {
        buffer.func_225582_a_(minX, y, minZ).func_181675_d();
        buffer.func_225582_a_(minX, y, maxZ).func_181675_d();
        buffer.func_225582_a_(maxX, y, maxZ).func_181675_d();
        buffer.func_225582_a_(maxX, y, minZ).func_181675_d();
    }

    public static void drawPlaneNegZ(double z, double minX, double maxX, double minY, double maxY, BufferBuilder buffer) {
        buffer.func_225582_a_(minX, minY, z).func_181675_d();
        buffer.func_225582_a_(minX, maxY, z).func_181675_d();
        buffer.func_225582_a_(maxX, maxY, z).func_181675_d();
        buffer.func_225582_a_(maxX, minY, z).func_181675_d();
    }

    public static void drawPlanePosZ(double z, double minX, double maxX, double minY, double maxY, BufferBuilder buffer) {
        buffer.func_225582_a_(minX, minY, z).func_181675_d();
        buffer.func_225582_a_(maxX, minY, z).func_181675_d();
        buffer.func_225582_a_(maxX, maxY, z).func_181675_d();
        buffer.func_225582_a_(minX, maxY, z).func_181675_d();
    }

    public static void drawCapsuleCube(AxisAlignedBB boundingBox, BufferBuilder bufferBuilder) {
        RendererUtils.drawCubeBottom(boundingBox, bufferBuilder);
        RendererUtils.drawCubeTop(boundingBox, bufferBuilder);
        RendererUtils.drawCubeSides(boundingBox, bufferBuilder);
    }

    public static void drawCubeBottom(AxisAlignedBB boundingBox, BufferBuilder bufferBuilder) {
        bufferBuilder.func_225582_a_(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72339_c).func_181675_d();
        bufferBuilder.func_225582_a_(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72339_c).func_181675_d();
        bufferBuilder.func_225582_a_(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72334_f).func_181675_d();
        bufferBuilder.func_225582_a_(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72334_f).func_181675_d();
        bufferBuilder.func_225582_a_(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72339_c).func_181675_d();
    }

    public static void drawCubeTop(AxisAlignedBB boundingBox, BufferBuilder bufferBuilder) {
        bufferBuilder.func_225582_a_(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72339_c).func_181675_d();
        bufferBuilder.func_225582_a_(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72339_c).func_181675_d();
        bufferBuilder.func_225582_a_(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72334_f).func_181675_d();
        bufferBuilder.func_225582_a_(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72334_f).func_181675_d();
        bufferBuilder.func_225582_a_(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72339_c).func_181675_d();
    }

    public static void drawCubeSides(AxisAlignedBB boundingBox, BufferBuilder bufferBuilder) {
        bufferBuilder.func_225582_a_(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72339_c).func_181675_d();
        bufferBuilder.func_225582_a_(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72339_c).func_181675_d();
        bufferBuilder.func_225582_a_(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72339_c).func_181675_d();
        bufferBuilder.func_225582_a_(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72339_c).func_181675_d();
        bufferBuilder.func_225582_a_(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72334_f).func_181675_d();
        bufferBuilder.func_225582_a_(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72334_f).func_181675_d();
        bufferBuilder.func_225582_a_(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72334_f).func_181675_d();
        bufferBuilder.func_225582_a_(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72334_f).func_181675_d();
    }

    public static void setColor(int rgb, int alpha) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        float af = (float)alpha / 255.0f;
        float rf = (float)r / 255.0f;
        float gf = (float)g / 255.0f;
        float bf = (float)b / 255.0f;
        RenderSystem.color4f((float)rf, (float)gf, (float)bf, (float)af);
    }
}

