/*
 * Decompiled with CFR 0.152.
 */
package capsule.command;

import capsule.Config;
import capsule.StructureSaver;
import capsule.helpers.Capsule;
import capsule.helpers.Files;
import capsule.helpers.Spacial;
import capsule.items.CapsuleItem;
import capsule.loot.CapsuleLootEntry;
import capsule.loot.CapsuleLootTableHook;
import capsule.structure.CapsuleTemplate;
import capsule.structure.CapsuleTemplateManager;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootParameters;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;

public class CapsuleCommand {
    public static List<ServerPlayerEntity> sentUsageURL = new ArrayList<ServerPlayerEntity>();

    public static String[] getStructuresList(ServerWorld world) {
        return (String[])ArrayUtils.addAll((Object[])new File(world.func_217485_w().func_75765_b(), "generated/minecraft/structures").list(), (Object[])new File(world.func_217485_w().func_75765_b(), "generated/capsule/structures").list());
    }

    public static String[] getRewardsList() {
        return new File(Config.rewardTemplatesPath).list();
    }

    private static SuggestionProvider<CommandSource> SUGGEST_REWARD() {
        return (__, builder) -> {
            String[] rewards = CapsuleCommand.getRewardsList();
            if (rewards == null) {
                rewards = new String[]{};
            }
            return ISuggestionProvider.func_197008_a((String[])rewards, (SuggestionsBuilder)builder);
        };
    }

    private static SuggestionProvider<CommandSource> SUGGEST_TEMPLATE() {
        return (context, builder) -> {
            String[] tpls = CapsuleCommand.getStructuresList(((CommandSource)context.getSource()).func_197023_e());
            if (tpls == null) {
                tpls = new String[]{};
            }
            return ISuggestionProvider.func_197008_a((String[])tpls, (SuggestionsBuilder)builder);
        };
    }

    private static SuggestionProvider<CommandSource> SUGGEST_COLORS() {
        return (context, builder) -> ISuggestionProvider.func_197008_a((String[])CapsuleLootEntry.COLOR_PALETTE, (SuggestionsBuilder)builder);
    }

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder capsuleCommand = (LiteralArgumentBuilder)Commands.func_197057_a((String)"capsule").requires(player -> player.func_197034_c(2));
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)capsuleCommand.then(Commands.func_197057_a((String)"help").executes(ctx -> {
            int count = 0;
            if (!sentUsageURL.contains(((CommandSource)ctx.getSource()).func_197035_h())) {
                StringTextComponent msg = new StringTextComponent("see Capsule commands usages at " + TextFormatting.UNDERLINE + "https://github.com/Lythom/capsule/wiki/Commands");
                msg.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://github.com/Lythom/capsule/wiki/Commands"));
                ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)msg, false);
                sentUsageURL.add(((CommandSource)ctx.getSource()).func_197035_h());
                ++count;
            }
            Map map = dispatcher.getSmartUsage(ctx.getRootNode().getChild("capsule"), ctx.getSource());
            for (String s : map.values()) {
                ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new StringTextComponent("/" + s), false);
            }
            return map.size() + count;
        }))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"giveEmpty").executes(ctx -> CapsuleCommand.executeGiveEmpty(((CommandSource)ctx.getSource()).func_197035_h(), 3, false))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"size", (ArgumentType)IntegerArgumentType.integer((int)1, (int)255)).executes(ctx -> CapsuleCommand.executeGiveEmpty(((CommandSource)ctx.getSource()).func_197035_h(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"size"), false))).then(Commands.func_197056_a((String)"overpowered", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> CapsuleCommand.executeGiveEmpty(((CommandSource)ctx.getSource()).func_197035_h(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"size"), BoolArgumentType.getBool((CommandContext)ctx, (String)"overpowered"))))))).then(Commands.func_197057_a((String)"giveLinked").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"rewardTemplateName", (ArgumentType)StringArgumentType.string()).suggests(CapsuleCommand.SUGGEST_REWARD()).executes(ctx -> CapsuleCommand.executeGiveLinked(((CommandSource)ctx.getSource()).func_197035_h(), StringArgumentType.getString((CommandContext)ctx, (String)"rewardTemplateName")))).then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197096_c()).executes(ctx -> CapsuleCommand.executeGiveLinked(EntityArgument.func_197089_d((CommandContext)ctx, (String)"target"), StringArgumentType.getString((CommandContext)ctx, (String)"rewardTemplateName"))))))).then(Commands.func_197057_a((String)"giveBlueprint").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"rewardTemplateName", (ArgumentType)StringArgumentType.string()).suggests(CapsuleCommand.SUGGEST_REWARD()).executes(ctx -> CapsuleCommand.executeGiveBlueprint(((CommandSource)ctx.getSource()).func_197035_h(), StringArgumentType.getString((CommandContext)ctx, (String)"rewardTemplateName")))).then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197096_c()).executes(ctx -> CapsuleCommand.executeGiveBlueprint(EntityArgument.func_197089_d((CommandContext)ctx, (String)"target"), StringArgumentType.getString((CommandContext)ctx, (String)"rewardTemplateName"))))))).then(Commands.func_197057_a((String)"exportHeldItem").executes(ctx -> CapsuleCommand.executeExportHeldItem(((CommandSource)ctx.getSource()).func_197035_h())))).then(Commands.func_197057_a((String)"exportSeenBlock").executes(ctx -> CapsuleCommand.executeExportSeenBlock(((CommandSource)ctx.getSource()).func_197035_h())))).then(Commands.func_197057_a((String)"fromExistingReward").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"rewardTemplateName", (ArgumentType)StringArgumentType.string()).suggests(CapsuleCommand.SUGGEST_REWARD()).executes(ctx -> CapsuleCommand.executeFromExistingReward(((CommandSource)ctx.getSource()).func_197035_h(), StringArgumentType.getString((CommandContext)ctx, (String)"rewardTemplateName")))).then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197096_c()).executes(ctx -> CapsuleCommand.executeFromExistingReward(EntityArgument.func_197089_d((CommandContext)ctx, (String)"target"), StringArgumentType.getString((CommandContext)ctx, (String)"rewardTemplateName"))))))).then(Commands.func_197057_a((String)"fromStructure").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"rewardTemplateName", (ArgumentType)StringArgumentType.string()).suggests(CapsuleCommand.SUGGEST_TEMPLATE()).executes(ctx -> CapsuleCommand.executeFromStructure(((CommandSource)ctx.getSource()).func_197035_h(), StringArgumentType.getString((CommandContext)ctx, (String)"rewardTemplateName")))).then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197096_c()).executes(ctx -> CapsuleCommand.executeFromStructure(EntityArgument.func_197089_d((CommandContext)ctx, (String)"target"), StringArgumentType.getString((CommandContext)ctx, (String)"rewardTemplateName"))))))).then(Commands.func_197057_a((String)"fromHeldCapsule").then(Commands.func_197056_a((String)"outputTemplateName", (ArgumentType)StringArgumentType.string()).executes(ctx -> CapsuleCommand.executeFromHeldCapsule(((CommandSource)ctx.getSource()).func_197035_h(), StringArgumentType.getString((CommandContext)ctx, (String)"outputTemplateName")))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"giveRandomLoot").executes(ctx -> CapsuleCommand.executeGiveRandomLoot(((CommandSource)ctx.getSource()).func_197035_h()))).then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197096_c()).executes(ctx -> CapsuleCommand.executeGiveRandomLoot(EntityArgument.func_197089_d((CommandContext)ctx, (String)"target")))))).then(Commands.func_197057_a((String)"reloadLootList").executes(ctx -> {
            IReloadableResourceManager resourceManager = ((CommandSource)ctx.getSource()).func_197028_i().func_195570_aG();
            Files.populateAndLoadLootList(Config.getCapsuleConfigDir().toFile(), Config.lootTemplatesData, (IResourceManager)resourceManager);
            return 1;
        }))).then(Commands.func_197057_a((String)"reloadWhitelist").executes(ctx -> {
            IReloadableResourceManager resourceManager = ((CommandSource)ctx.getSource()).func_197028_i().func_195570_aG();
            Files.populateAndLoadLootList(Config.getCapsuleConfigDir().toFile(), Config.lootTemplatesData, (IResourceManager)resourceManager);
            Config.starterTemplatesList = Files.populateStarters(Config.getCapsuleConfigDir().toFile(), Config.starterTemplatesPath, (IResourceManager)resourceManager);
            Config.blueprintWhitelist = Files.populateWhitelistConfig(Config.getCapsuleConfigDir().toFile(), (IResourceManager)resourceManager);
            return 1;
        }))).then(Commands.func_197057_a((String)"setAuthor").then(Commands.func_197056_a((String)"authorName", (ArgumentType)StringArgumentType.string()).executes(ctx -> CapsuleCommand.executeSetAuthor(((CommandSource)ctx.getSource()).func_197035_h(), StringArgumentType.getString((CommandContext)ctx, (String)"authorName")))))).then(Commands.func_197057_a((String)"setBaseColor").then(Commands.func_197056_a((String)"color", (ArgumentType)StringArgumentType.string()).suggests(CapsuleCommand.SUGGEST_COLORS()).executes(ctx -> CapsuleCommand.executeSetBaseColor(((CommandSource)ctx.getSource()).func_197035_h(), StringArgumentType.getString((CommandContext)ctx, (String)"color")))))).then(Commands.func_197057_a((String)"setMaterialColor").then(Commands.func_197056_a((String)"color", (ArgumentType)StringArgumentType.string()).suggests(CapsuleCommand.SUGGEST_COLORS()).executes(ctx -> CapsuleCommand.executeSetMaterialColor(((CommandSource)ctx.getSource()).func_197035_h(), StringArgumentType.getString((CommandContext)ctx, (String)"color")))));
        dispatcher.register(capsuleCommand);
    }

    private static int executeGiveEmpty(ServerPlayerEntity player, int size, boolean overpowered) {
        if (player != null) {
            ItemStack capsule = Capsule.newEmptyCapsuleItemStack(0xFFFFFF, 0xFFFFFF, size, overpowered, null, null);
            CapsuleCommand.giveCapsule(capsule, (PlayerEntity)player);
            return 1;
        }
        return 0;
    }

    private static int executeGiveLinked(ServerPlayerEntity player, String rewardTemplateName) {
        String templateName = rewardTemplateName.replaceAll(".nbt", "").replaceAll(".schematic", "");
        if (player != null && !StringUtils.func_151246_b((String)templateName) && player.func_130014_f_() instanceof ServerWorld) {
            ItemStack capsule = Capsule.createLinkedCapsuleFromReward(Config.getRewardPathFromName(templateName), player);
            if (capsule.func_190926_b()) {
                throw new CommandException((ITextComponent)new StringTextComponent("Reward Capsule " + rewardTemplateName + " not found "));
            }
            CapsuleCommand.giveCapsule(capsule, (PlayerEntity)player);
            return 1;
        }
        return 0;
    }

    private static int executeGiveBlueprint(ServerPlayerEntity player, String rewardTemplateName) {
        String templateName = rewardTemplateName.replaceAll(".nbt", "").replaceAll(".schematic", "");
        if (player != null && !StringUtils.func_151246_b((String)templateName) && player.func_130014_f_() instanceof ServerWorld) {
            CapsuleTemplate srcTemplate = Capsule.getRewardTemplateIfExists(Config.getRewardPathFromName(templateName), player.func_184102_h());
            if (srcTemplate != null) {
                int size = Math.max(srcTemplate.getSize().func_177958_n(), Math.max(srcTemplate.getSize().func_177956_o(), srcTemplate.getSize().func_177952_p()));
                if (size % 2 == 0) {
                    ++size;
                }
                ItemStack capsule = Capsule.newEmptyCapsuleItemStack(3949738, 0xFFFFFF, size, false, Capsule.labelFromPath(templateName), 0);
                CapsuleItem.setState(capsule, CapsuleItem.CapsuleState.DEPLOYED);
                CapsuleItem.setBlueprint(capsule);
                String destTemplate = StructureSaver.createBlueprintTemplate(Config.getRewardPathFromName(templateName), capsule, player.func_71121_q(), (PlayerEntity)player);
                CapsuleItem.setStructureName(capsule, destTemplate);
                CapsuleCommand.giveCapsule(capsule, (PlayerEntity)player);
            } else {
                throw new CommandException((ITextComponent)new StringTextComponent("Reward Capsule " + rewardTemplateName + " not found "));
            }
        }
        return 0;
    }

    private static int executeGiveRandomLoot(ServerPlayerEntity player) throws CommandException {
        if (player != null) {
            LootContext.Builder lootcontext$builder = new LootContext.Builder(player.func_71121_q()).func_216015_a(LootParameters.field_216286_f, (Object)player.func_180425_c()).func_216021_b(LootParameters.field_216281_a, (Object)player.getEntity());
            ArrayList loots = new ArrayList();
            CapsuleLootTableHook.capsulePool.func_216091_a(loots::add, lootcontext$builder.func_216022_a(LootParameterSets.field_227557_c_));
            if (loots.size() <= 0) {
                player.func_145747_a((ITextComponent)new StringTextComponent("No loot this time !"));
            } else {
                Iterator iterator = loots.iterator();
                if (iterator.hasNext()) {
                    ItemStack loot = (ItemStack)iterator.next();
                    CapsuleCommand.giveCapsule(loot, (PlayerEntity)player);
                    return 1;
                }
            }
        }
        return 0;
    }

    private static int executeFromExistingReward(ServerPlayerEntity player, String templateName) throws CommandException {
        if (player != null && !StringUtils.func_151246_b((String)templateName) && player.func_130014_f_() instanceof ServerWorld) {
            int size;
            String structurePath = Config.getRewardPathFromName(templateName);
            CapsuleTemplateManager templatemanager = StructureSaver.getRewardManager(player.func_184102_h());
            CapsuleTemplate template = templatemanager.getTemplateDefaulted(new ResourceLocation(structurePath));
            if (template != null) {
                size = Math.max(template.getSize().func_177958_n(), Math.max(template.getSize().func_177956_o(), template.getSize().func_177952_p()));
                if (size % 2 == 0) {
                    ++size;
                }
            } else {
                throw new CommandException((ITextComponent)new StringTextComponent("Reward Capsule \"" + templateName + "\" not found "));
            }
            ItemStack capsule = Capsule.newRewardCapsuleItemStack(structurePath, CapsuleLootEntry.getRandomColor(), CapsuleLootEntry.getRandomColor(), size, Capsule.labelFromPath(templateName), template.getAuthor());
            CapsuleItem.setCanRotate(capsule, template.canRotate());
            CapsuleCommand.giveCapsule(capsule, (PlayerEntity)player);
            return 1;
        }
        return 0;
    }

    private static int executeFromStructure(ServerPlayerEntity player, String templateName) throws CommandException {
        if (player != null && !StringUtils.func_151246_b((String)templateName) && player.func_130014_f_() instanceof ServerWorld) {
            String path;
            CompoundNBT data = new CompoundNBT();
            int size = -1;
            String author = null;
            TemplateManager templatemanager = player.func_71121_q().func_184163_y();
            Template template = templatemanager.func_200219_b(new ResourceLocation(path = templateName.endsWith(".nbt") ? templateName.replace(".nbt", "") : templateName));
            if (template != null) {
                size = Math.max(template.func_186259_a().func_177958_n(), Math.max(template.func_186259_a().func_177956_o(), template.func_186259_a().func_177952_p()));
                author = template.func_186261_b();
                template.func_189552_a(data);
            } else {
                CapsuleTemplateManager capsuletemplatemanager = StructureSaver.getTemplateManager(player.func_71121_q());
                CapsuleTemplate ctemplate = capsuletemplatemanager.getTemplateDefaulted(new ResourceLocation(path));
                size = Math.max(ctemplate.getSize().func_177958_n(), Math.max(ctemplate.getSize().func_177956_o(), ctemplate.getSize().func_177952_p()));
                author = ctemplate.getAuthor();
                ctemplate.writeToNBT(data);
            }
            if (size > -1) {
                if (size % 2 == 0) {
                    ++size;
                }
                ResourceLocation destinationLocation = new ResourceLocation(Config.rewardTemplatesPath + "/" + path);
                CapsuleTemplateManager destManager = StructureSaver.getRewardManager(player.func_184102_h());
                CapsuleTemplate destTemplate = destManager.getTemplateDefaulted(destinationLocation);
                destTemplate.read(data);
                destManager.writeToFile(destinationLocation);
                ItemStack capsule = Capsule.newRewardCapsuleItemStack(destinationLocation.toString(), CapsuleLootEntry.getRandomColor(), CapsuleLootEntry.getRandomColor(), size, path, author);
                CapsuleItem.setCanRotate(capsule, destTemplate.canRotate());
                CapsuleCommand.giveCapsule(capsule, (PlayerEntity)player);
                return 1;
            }
            throw new CommandException((ITextComponent)new StringTextComponent("Structure \"" + path + "\" not found "));
        }
        return 0;
    }

    private static int executeFromHeldCapsule(ServerPlayerEntity player, String templateName) throws CommandSyntaxException {
        ItemStack heldItem;
        if (player != null && (heldItem = player.func_184614_ca()).func_77973_b() instanceof CapsuleItem && heldItem.func_77942_o()) {
            String outputName = StringUtils.func_151246_b((String)templateName) ? heldItem.func_77978_p().func_74779_i("label") : templateName;
            if (StringUtils.func_151246_b((String)outputName)) {
                throw new SimpleCommandExceptionType((Message)new StringTextComponent("/capsule fromHeldCapsule [outputName]. Please label the held capsule or provide an output name to be used for output template.")).create();
            }
            String destinationTemplateLocation = Config.getRewardPathFromName(outputName.toLowerCase().replace(" ", "_").replace(":", "-"));
            boolean created = StructureSaver.copyFromCapsuleTemplate(heldItem, destinationTemplateLocation, StructureSaver.getRewardManager(player.func_184102_h()), player.func_71121_q(), false, null);
            if (!created) {
                player.func_145747_a((ITextComponent)new StringTextComponent("Could not duplicate the capsule template. Either the source template don't exist or the destination folder dont exist."));
                return 0;
            }
            ItemStack capsule = Capsule.newRewardCapsuleItemStack(destinationTemplateLocation, CapsuleItem.getBaseColor(heldItem), CapsuleItem.getMaterialColor(heldItem), CapsuleItem.getSize(heldItem), outputName, CapsuleItem.getAuthor(heldItem));
            CapsuleItem.setCanRotate(capsule, CapsuleItem.canRotate(heldItem));
            CapsuleCommand.giveCapsule(capsule, (PlayerEntity)player);
            return 1;
        }
        return 0;
    }

    private static int executeSetMaterialColor(ServerPlayerEntity player, String colorAsInt) throws CommandSyntaxException {
        ItemStack heldItem;
        int color;
        try {
            color = Integer.decode(colorAsInt);
        }
        catch (NumberFormatException e) {
            throw new SimpleCommandExceptionType((Message)new StringTextComponent("Color parameter must be a valid integer. ie. 0xCC3D2E or 123456")).create();
        }
        if (player != null && (heldItem = player.func_184614_ca()).func_77973_b() instanceof CapsuleItem) {
            CapsuleItem.setMaterialColor(heldItem, color);
            return 1;
        }
        return 0;
    }

    private static int executeSetBaseColor(ServerPlayerEntity player, String colorAsInt) throws CommandSyntaxException {
        ItemStack heldItem;
        int color = 0;
        try {
            color = Integer.decode(colorAsInt);
        }
        catch (NumberFormatException e) {
            throw new SimpleCommandExceptionType((Message)new StringTextComponent("Color parameter must be a valid integer. ie. 0xCC3D2E or 123456")).create();
        }
        if (player != null && (heldItem = player.func_184614_ca()).func_77973_b() instanceof CapsuleItem) {
            CapsuleItem.setBaseColor(heldItem, color);
            return 1;
        }
        return 0;
    }

    private static int executeSetAuthor(ServerPlayerEntity player, String authorName) {
        ItemStack heldItem;
        if (player != null && !(heldItem = player.func_184614_ca()).func_190926_b() && heldItem.func_77973_b() instanceof CapsuleItem && heldItem.func_77942_o()) {
            if (!StringUtils.func_151246_b((String)authorName)) {
                heldItem.func_77978_p().func_74778_a("author", authorName);
                Pair<CapsuleTemplateManager, CapsuleTemplate> templatepair = StructureSaver.getTemplate(heldItem, player.func_71121_q());
                CapsuleTemplate template = (CapsuleTemplate)templatepair.getRight();
                CapsuleTemplateManager templatemanager = (CapsuleTemplateManager)templatepair.getLeft();
                if (template != null && templatemanager != null) {
                    template.setAuthor(authorName);
                    templatemanager.writeToFile(new ResourceLocation(CapsuleItem.getStructureName(heldItem)));
                }
            } else {
                heldItem.func_77978_p().func_82580_o("author");
                Pair<CapsuleTemplateManager, CapsuleTemplate> templatepair = StructureSaver.getTemplate(heldItem, player.func_71121_q());
                CapsuleTemplate template = (CapsuleTemplate)templatepair.getRight();
                CapsuleTemplateManager templatemanager = (CapsuleTemplateManager)templatepair.getLeft();
                if (template != null && templatemanager != null) {
                    template.setAuthor("?");
                    templatemanager.writeToFile(new ResourceLocation(CapsuleItem.getStructureName(heldItem)));
                }
            }
            return 1;
        }
        return 0;
    }

    private static int executeExportSeenBlock(ServerPlayerEntity player) {
        if (player != null) {
            if (player.func_184102_h() != null && !player.func_184102_h().func_71262_S()) {
                BlockRayTraceResult rtc = Spacial.clientRayTracePreview((PlayerEntity)player, Minecraft.func_71410_x().func_184121_ak(), 50);
                if (rtc.func_216346_c() == RayTraceResult.Type.BLOCK) {
                    BlockPos position = rtc.func_216350_a();
                    BlockState state = player.func_71121_q().func_180495_p(position);
                    TileEntity tileentity = player.func_71121_q().func_175625_s(position);
                    String BlockEntityTag = tileentity == null ? "" : "{BlockEntityTag:" + tileentity.serializeNBT().toString() + "}";
                    String command = "/give @p " + state.func_177230_c().getRegistryName() + BlockEntityTag + " 1 ";
                    StringTextComponent msg = new StringTextComponent(command);
                    msg.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new StringTextComponent("Copy/Paste from client log (click to open)")));
                    msg.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_FILE, "logs/latest.log"));
                    player.func_145747_a((ITextComponent)msg);
                    return 1;
                }
            } else {
                player.func_145747_a((ITextComponent)new StringTextComponent("This command only works on an integrated server, not on an dedicated one"));
            }
        }
        return 0;
    }

    private static int executeExportHeldItem(ServerPlayerEntity player) {
        ItemStack heldItem;
        if (player != null && !(heldItem = player.func_184614_ca()).func_190926_b()) {
            String tag = heldItem.func_77942_o() ? String.valueOf(heldItem.func_77978_p()) : "";
            String command = "/give @p " + heldItem.func_77973_b().getRegistryName() + tag + " 1 ";
            StringTextComponent msg = new StringTextComponent(command);
            msg.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new StringTextComponent("Copy/Paste from client log (click to open)")));
            msg.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_FILE, "logs/latest.log"));
            player.func_145747_a((ITextComponent)msg);
            return 1;
        }
        return 0;
    }

    private static void giveCapsule(ItemStack capsule, PlayerEntity player) {
        ItemEntity entity = new ItemEntity(player.func_130014_f_(), (double)player.func_180425_c().func_177958_n(), (double)player.func_180425_c().func_177956_o(), (double)player.func_180425_c().func_177952_p(), capsule);
        entity.func_174868_q();
        entity.func_70100_b_(player);
    }
}

