/*
 * Decompiled with CFR 0.152.
 */
package capsule.enchantments;

import capsule.enchantments.Enchantments;
import capsule.helpers.Spacial;
import capsule.items.CapsuleItem;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="capsule", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class RecallEnchant
extends Enchantment {
    protected RecallEnchant(ResourceLocation enchName, Enchantment.Rarity rarity, EnchantmentType enchType) {
        super(rarity, enchType, EquipmentSlotType.values());
        this.setRegistryName(enchName);
    }

    public boolean func_92089_a(ItemStack stack) {
        return this.canApplyAtEnchantingTable(stack);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return stack.func_77973_b() instanceof CapsuleItem && !CapsuleItem.isBlueprint(stack) && !CapsuleItem.isOneUse(stack) || this.field_77351_y != null && super.canApplyAtEnchantingTable(stack);
    }

    public int func_77321_a(int enchantmentLevel) {
        return 1;
    }

    public int func_223551_b(int enchantmentLevel) {
        return this.func_77321_a(enchantmentLevel) + 40;
    }

    public int func_77325_b() {
        return 1;
    }

    public static void pickupItemBack(ItemEntity entity, PlayerEntity player) {
        if (player != null) {
            entity.func_174868_q();
            entity.func_70100_b_(player);
        }
    }

    @SubscribeEvent
    public static void onWorldTickEvent(TickEvent.WorldTickEvent wte) {
        if (wte.side == LogicalSide.CLIENT || wte.phase != TickEvent.Phase.END) {
            return;
        }
        ServerWorld world = (ServerWorld)wte.world;
        List recallEntities = world.func_217482_a(EntityType.field_200765_E, Enchantments.hasRecallEnchant);
        List recallItemEntities = recallEntities.stream().filter(entity -> entity instanceof ItemEntity).map(entity -> (ItemEntity)entity).collect(Collectors.toList());
        for (ItemEntity entity2 : recallItemEntities) {
            if (entity2.func_200214_m() == null || !entity2.field_70132_H && !Spacial.ItemEntityShouldAndCollideLiquid(entity2)) continue;
            if (!entity2.func_180799_ab()) {
                entity2.func_70071_h_();
            }
            if (!entity2.func_70089_S()) continue;
            RecallEnchant.pickupItemBack(entity2, world.func_217371_b(entity2.func_200214_m()));
        }
    }
}

