/*
 * Decompiled with CFR 0.152.
 */
package capsule.helpers;

import capsule.Config;
import capsule.StructureSaver;
import capsule.helpers.Capsule;
import capsule.helpers.Files;
import capsule.structure.CapsuleTemplate;
import capsule.structure.CapsuleTemplateManager;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FarmlandBlock;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.MovingPistonBlock;
import net.minecraft.block.PistonHeadBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BedPart;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.DataFixesManager;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.ModList;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.TriConsumer;

public class Blueprint {
    protected static final Logger LOGGER = LogManager.getLogger(Blueprint.class);

    public static ItemStack getBlockItemCost(Template.BlockInfo blockInfo) {
        BlockState state = blockInfo.field_186243_b;
        Block block = state.func_177230_c();
        CompoundNBT blockNBT = blockInfo.field_186244_c;
        try {
            if (block instanceof DoorBlock) {
                if (state.func_177229_b((IProperty)DoorBlock.field_176523_O) == DoubleBlockHalf.LOWER) {
                    return new ItemStack((IItemProvider)block.func_199767_j(), 1);
                }
                return ItemStack.field_190927_a;
            }
            if (block instanceof BedBlock) {
                if (state.func_177229_b((IProperty)BedBlock.field_176472_a) == BedPart.HEAD) {
                    return new ItemStack((IItemProvider)block.func_199767_j(), 1);
                }
                return ItemStack.field_190927_a;
            }
            if (block instanceof SlabBlock && state.func_177229_b((IProperty)SlabBlock.field_196505_a) == SlabType.DOUBLE) {
                return new ItemStack((IItemProvider)block.func_199767_j(), 2);
            }
            if (block instanceof FarmlandBlock) {
                return new ItemStack((IItemProvider)Blocks.field_150346_d);
            }
            if (block instanceof FlowingFluidBlock) {
                FlowingFluidBlock fblock = (FlowingFluidBlock)block;
                if (Blueprint.isLiquidSource(state, fblock)) {
                    ItemStack item = FluidUtil.getFilledBucket((FluidStack)new FluidStack((Fluid)fblock.getFluid(), 1000));
                    return item.func_190926_b() ? null : item;
                }
                return ItemStack.field_190927_a;
            }
            if (block instanceof PistonHeadBlock || block instanceof MovingPistonBlock) {
                return ItemStack.field_190927_a;
            }
            ItemStack item = new ItemStack((IItemProvider)block.func_199767_j(), 1);
            if (blockNBT != null) {
                CompoundNBT itemNBT = new CompoundNBT();
                JsonObject allowedNBT = Config.getBlueprintAllowedNBT(block);
                for (String key : blockNBT.func_150296_c()) {
                    if (!allowedNBT.has(key) || allowedNBT.get(key).isJsonNull()) continue;
                    String targetKey = allowedNBT.get(key).getAsString();
                    itemNBT.func_218657_a(targetKey, blockNBT.func_74781_a(key));
                }
                if (itemNBT.func_186856_d() > 0) {
                    item.func_77982_d(itemNBT);
                }
            }
            return item;
        }
        catch (Exception e) {
            return new ItemStack((IItemProvider)Item.func_150898_a((Block)block), 1);
        }
    }

    public static boolean isLiquidSource(BlockState state, FlowingFluidBlock block) {
        return block.func_204507_t(state).func_206889_d();
    }

    @Nullable
    public static Map<StructureSaver.ItemStackKey, Integer> getMaterialList(ItemStack blueprint, ServerWorld worldserver, PlayerEntity player) {
        CapsuleTemplate blueprintTemplate = (CapsuleTemplate)StructureSaver.getTemplate(blueprint, worldserver).getRight();
        if (blueprintTemplate == null) {
            return null;
        }
        return Blueprint.getMaterialList(blueprintTemplate, player);
    }

    public static Map<StructureSaver.ItemStackKey, Integer> getMaterialList(CapsuleTemplate blueprintTemplate, @Nullable PlayerEntity player) {
        HashMap<StructureSaver.ItemStackKey, Integer> list = new HashMap<StructureSaver.ItemStackKey, Integer>();
        for (Template.BlockInfo block : blueprintTemplate.getBlocks()) {
            ItemStack itemStack = Blueprint.getBlockItemCost(block);
            StructureSaver.ItemStackKey stackKey = new StructureSaver.ItemStackKey(itemStack);
            if (itemStack == null) {
                if (player != null) {
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("capsule.error.technicalError", new Object[0]));
                }
                if (player != null) {
                    LOGGER.error("Unknown item during blueprint undo for block " + block.field_186243_b.func_177230_c().getRegistryName());
                }
                return null;
            }
            if (itemStack.func_190926_b() || itemStack.func_77973_b() == Items.field_190931_a) continue;
            Integer currValue = (Integer)list.get(stackKey);
            if (currValue == null) {
                currValue = 0;
            }
            list.put(stackKey, currValue + itemStack.func_190916_E());
        }
        return list;
    }

    public static TreeMap<Triple<StructureSaver.ItemStackKey, StructureSaver.ItemStackKey, StructureSaver.ItemStackKey>, String> sortTemplatesByIngredients(List<String> prefabsTemplatesList, CapsuleTemplateManager tempManager) {
        TreeMap<Triple<StructureSaver.ItemStackKey, StructureSaver.ItemStackKey, StructureSaver.ItemStackKey>, String> templatesByIngrendients = new TreeMap<Triple<StructureSaver.ItemStackKey, StructureSaver.ItemStackKey, StructureSaver.ItemStackKey>, String>(Triple::compareTo);
        for (String templateName : prefabsTemplatesList) {
            try {
                Map<StructureSaver.ItemStackKey, Integer> fullList;
                CapsuleTemplate template = tempManager.getTemplateDefaulted(new ResourceLocation(templateName));
                if (template == null || (fullList = Blueprint.getMaterialList(template, null)) == null) continue;
                StructureSaver.ItemStackKey[] list = (StructureSaver.ItemStackKey[])fullList.entrySet().stream().sorted(Collections.reverseOrder(Map.Entry.comparingByValue())).limit(5L).map(Map.Entry::getKey).toArray(StructureSaver.ItemStackKey[]::new);
                Triple key = Triple.of((Object)list[0], (Object)(list.length > 1 ? list[1] : null), list.length > 2 ? list[2] : null);
                if (templatesByIngrendients.containsKey(key)) {
                    key = Triple.of((Object)list[0], (Object)(list.length > 2 ? list[2] : null), list.length > 1 ? list[1] : null);
                }
                if (templatesByIngrendients.containsKey(key)) {
                    key = Triple.of((Object)(list.length > 1 ? list[1] : null), (Object)list[0], list.length > 2 ? list[2] : null);
                }
                if (templatesByIngrendients.containsKey(key)) {
                    key = Triple.of((Object)(list.length > 2 ? list[2] : null), (Object)list[0], list.length > 1 ? list[1] : null);
                }
                if (templatesByIngrendients.containsKey(key)) {
                    key = Triple.of((Object)(list.length > 1 ? list[1] : null), (Object)(list.length > 2 ? list[2] : null), (Object)list[0]);
                }
                if (templatesByIngrendients.containsKey(key)) {
                    key = Triple.of((Object)(list.length > 2 ? list[2] : null), (Object)(list.length > 1 ? list[1] : null), (Object)list[0]);
                }
                templatesByIngrendients.put((Triple<StructureSaver.ItemStackKey, StructureSaver.ItemStackKey, StructureSaver.ItemStackKey>)key, templateName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return templatesByIngrendients;
    }

    public static Map<Triple<StructureSaver.ItemStackKey, StructureSaver.ItemStackKey, StructureSaver.ItemStackKey>, String> reduceIngredientCount(TreeMap<Triple<StructureSaver.ItemStackKey, StructureSaver.ItemStackKey, StructureSaver.ItemStackKey>, String> templatesByIngrendients) {
        HashMap<Triple<StructureSaver.ItemStackKey, StructureSaver.ItemStackKey, StructureSaver.ItemStackKey>, String> reduced = new HashMap<Triple<StructureSaver.ItemStackKey, StructureSaver.ItemStackKey, StructureSaver.ItemStackKey>, String>();
        templatesByIngrendients.forEach((ingredients, value) -> {
            Triple withOneIngredient = Triple.of((Object)ingredients.getLeft(), null, null);
            if (!reduced.containsKey(withOneIngredient)) {
                reduced.put((Triple<StructureSaver.ItemStackKey, StructureSaver.ItemStackKey, StructureSaver.ItemStackKey>)withOneIngredient, (String)value);
            } else if (ingredients.getMiddle() != null) {
                Triple withTwoIngredient = Triple.of((Object)ingredients.getLeft(), (Object)ingredients.getMiddle(), null);
                if (!reduced.containsKey(withTwoIngredient)) {
                    reduced.put((Triple<StructureSaver.ItemStackKey, StructureSaver.ItemStackKey, StructureSaver.ItemStackKey>)withTwoIngredient, (String)value);
                } else if (ingredients.getRight() != null) {
                    if (!reduced.containsKey(ingredients)) {
                        reduced.put((Triple<StructureSaver.ItemStackKey, StructureSaver.ItemStackKey, StructureSaver.ItemStackKey>)ingredients, (String)value);
                    } else {
                        LOGGER.warn("Could not create prefab recipe with 2 ingredients or less.");
                    }
                } else {
                    LOGGER.warn("Could not create prefab recipe with 2 ingredients or less.");
                }
            } else {
                LOGGER.warn("Could not create prefab recipe with 1 ingredient.");
            }
        });
        return reduced;
    }

    public static void createDynamicPrefabRecipes(MinecraftServer server, List<String> prefabsTemplatesList, TriConsumer<ResourceLocation, JsonObject, Triple<StructureSaver.ItemStackKey, StructureSaver.ItemStackKey, StructureSaver.ItemStackKey>> parseTemplate) {
        JsonObject referenceRecipe = Files.readJSON(new File(Config.getCapsuleConfigDir().toString(), "prefab_blueprint_recipe.json"));
        if (referenceRecipe != null) {
            CapsuleTemplateManager tempManager = new CapsuleTemplateManager(server, Config.getCapsuleConfigDir().toFile().getParentFile().getParentFile(), DataFixesManager.func_210901_a());
            List<String> enabledPrefabsTemplatesList = Blueprint.getModEnabledTemplates(prefabsTemplatesList);
            TreeMap<Triple<StructureSaver.ItemStackKey, StructureSaver.ItemStackKey, StructureSaver.ItemStackKey>, String> templatesByIngrendients = Blueprint.sortTemplatesByIngredients(enabledPrefabsTemplatesList, tempManager);
            Map<Triple<StructureSaver.ItemStackKey, StructureSaver.ItemStackKey, StructureSaver.ItemStackKey>, String> reduced = Blueprint.reduceIngredientCount(templatesByIngrendients);
            reduced.forEach((ingredients, templateName) -> {
                CapsuleTemplate template = tempManager.getTemplateDefaulted(new ResourceLocation(templateName));
                JsonObject jsonRecipe = Files.copy(referenceRecipe);
                if (ingredients.getLeft() == null && ingredients.getMiddle() == null && ingredients.getRight() == null) {
                    LOGGER.error("template " + templateName + " cannot be turned into recipe because capsule failed to turn any block of the structure into ingredient. Please ensure all the modded blocks you are using in the template have their corresponding mod loaded in a version compatible with the template you are using.");
                } else if (jsonRecipe != null && template != null) {
                    jsonRecipe.getAsJsonObject("result").getAsJsonObject("nbt").addProperty("structureName", templateName);
                    jsonRecipe.getAsJsonObject("result").getAsJsonObject("nbt").addProperty("label", Capsule.labelFromPath(templateName));
                    int size = Math.max(template.getSize().func_177958_n(), Math.max(template.getSize().func_177956_o(), template.getSize().func_177952_p()));
                    jsonRecipe.getAsJsonObject("result").getAsJsonObject("nbt").addProperty("size", (Number)size);
                    parseTemplate.accept((Object)new ResourceLocation(templateName), (Object)jsonRecipe, ingredients);
                }
            });
        }
    }

    public static List<String> getModEnabledTemplates(List<String> prefabsTemplatesList) {
        return prefabsTemplatesList.stream().filter(templatePath -> {
            String[] path = templatePath.replaceAll(Config.prefabsTemplatesPath + "/", "").split("/");
            return path.length == 1 || ModList.get().isLoaded(path[0]);
        }).collect(Collectors.toList());
    }
}

