/*
 * Decompiled with CFR 0.152.
 */
package capsule.helpers;

import capsule.Config;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Files {
    protected static final Logger LOGGER = LogManager.getLogger(Files.class);
    private static Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JsonObject readJSON(File file) {
        if (!file.exists()) return null;
        try (FileInputStream stream = new FileInputStream(file);){
            JsonObject jsonContent;
            JsonObject jsonObject = jsonContent = (JsonObject)JSONUtils.func_193839_a((Gson)GSON, (Reader)new InputStreamReader(stream), JsonObject.class);
            return jsonObject;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static JsonObject copy(JsonObject original) {
        try {
            return (JsonObject)GSON.fromJson(GSON.toJson((Object)original, JsonObject.class), JsonObject.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static HashMap<String, JsonObject> populateWhitelistConfig(File capsuleConfigDir, IResourceManager ressourceManager) {
        if (!capsuleConfigDir.exists()) {
            capsuleConfigDir.mkdirs();
        }
        HashMap<String, JsonObject> blueprintWhitelist = new HashMap<String, JsonObject>();
        if (capsuleConfigDir.exists() && capsuleConfigDir.isDirectory()) {
            File whitelistFile = new File(capsuleConfigDir, "blueprint_whitelist.json");
            if (!whitelistFile.exists()) {
                LOGGER.info("First load: initializing the configs in " + capsuleConfigDir.getPath() + ".");
                Files.populateFolder(capsuleConfigDir, "initialconfig/root", ressourceManager);
            }
            if (whitelistFile.exists()) {
                try (FileInputStream stream = new FileInputStream(whitelistFile);){
                    JsonArray whitelistElements = (JsonArray)JSONUtils.func_193839_a((Gson)GSON, (Reader)new InputStreamReader(stream), JsonArray.class);
                    if (whitelistElements != null) {
                        for (JsonElement elem : whitelistElements) {
                            if (elem.isJsonPrimitive()) {
                                blueprintWhitelist.put(elem.getAsString(), null);
                                continue;
                            }
                            if (!elem.isJsonObject()) continue;
                            JsonObject obj = elem.getAsJsonObject();
                            blueprintWhitelist.put(obj.get("block").getAsString(), obj.has("keepNBT") ? obj.get("keepNBT").getAsJsonObject() : null);
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            } else {
                LOGGER.error(whitelistFile.getPath() + " was expected to be found in config/capsule. Maybe it could not be created.");
            }
        }
        return blueprintWhitelist;
    }

    public static ArrayList<String> populateStarters(File capsuleConfigDir, String starterTemplatesPath, IResourceManager ressourceManager) {
        if (StringUtils.func_151246_b((String)starterTemplatesPath)) {
            return new ArrayList<String>();
        }
        File startersFolder = new File(capsuleConfigDir.getParentFile().getParentFile(), starterTemplatesPath);
        if (!startersFolder.exists()) {
            startersFolder.mkdirs();
            LOGGER.info("First load: initializing the starters in " + starterTemplatesPath + ". You can change the content of folder with any nbt structure block, schematic or capsule file, or empty it for no starter capsule.");
            Files.populateFolder(startersFolder, "initialconfig/starters", ressourceManager);
        }
        ArrayList<String> starterTemplatesList = new ArrayList<String>();
        Files.iterateTemplates(startersFolder, templateName -> starterTemplatesList.add(starterTemplatesPath + "/" + templateName));
        return starterTemplatesList;
    }

    public static void populateAndLoadLootList(File capsuleConfigDir, Map<String, Config.LootPathData> lootTemplatesData, IResourceManager ressourceManager) {
        for (Config.LootPathData data : lootTemplatesData.values()) {
            File templateFolder = new File(capsuleConfigDir.getParentFile().getParentFile(), data.path);
            if (!templateFolder.exists()) {
                templateFolder.mkdirs();
                LOGGER.info("First load: initializing the loots in " + data.path + ". You can change the content of folder with any nbt structure block, schematic, or capsule file. You can remove the folders from capsule.config to remove loots.");
                String assetPath = null;
                if (templateFolder.getPath().contains(File.separatorChar + "uncommon")) {
                    assetPath = "initialconfig/loot/uncommon";
                }
                if (templateFolder.getPath().contains(File.separatorChar + "rare")) {
                    assetPath = "initialconfig/loot/rare";
                }
                if (templateFolder.getPath().contains(File.separatorChar + "common")) {
                    assetPath = "initialconfig/loot/common";
                }
                if (assetPath != null) {
                    Files.populateFolder(templateFolder, assetPath, ressourceManager);
                }
            }
            data.files = new ArrayList<String>();
            Files.iterateTemplates(templateFolder, templateName -> data.files.add((String)templateName));
        }
    }

    public static ArrayList<String> populatePrefabs(File capsuleConfigDir, String prefabsTemplatesPath, IResourceManager ressourceManager) {
        File prefabsFolder = new File(capsuleConfigDir.getParentFile().getParentFile(), prefabsTemplatesPath);
        if (!prefabsFolder.exists()) {
            prefabsFolder.mkdirs();
            LOGGER.info("First load: initializing the prefabs in " + prefabsTemplatesPath + ". You can change the content of folder with any nbt structure block, schematic or capsule file, or empty it for no blueprint prefabs recipes.");
            Files.populateFolder(prefabsFolder, "initialconfig/prefabs", ressourceManager);
        }
        ArrayList<String> prefabsTemplatesList = new ArrayList<String>();
        Files.iterateTemplates(prefabsFolder, templateName -> prefabsTemplatesList.add(prefabsTemplatesPath + "/" + templateName));
        return prefabsTemplatesList;
    }

    public static void populateFolder(File templateFolder, String assetPath, IResourceManager ressourceManager) {
        try {
            for (ResourceLocation ressourceLoc : ressourceManager.func_199003_a(assetPath, s -> s.endsWith(".nbt") || s.endsWith(".json") || s.endsWith(".schematics"))) {
                IResource ressource = ressourceManager.func_199002_a(ressourceLoc);
                InputStream sourceTemplate = ressource.func_199027_b();
                String sourcePath = ressourceLoc.func_110623_a();
                String fileName = sourcePath.replace(assetPath + "/", "");
                Path assetFile = templateFolder.toPath().resolve(fileName);
                LOGGER.debug("copying asset " + assetPath + "/" + fileName + " to " + assetFile.toString());
                try {
                    File assetAsFile = assetFile.toFile();
                    if (assetAsFile.isDirectory()) {
                        if (!assetAsFile.exists()) {
                            assetAsFile.mkdirs();
                        }
                        Files.populateFolder(assetAsFile, assetPath + "/" + fileName, ressourceManager);
                        continue;
                    }
                    File parentFolder = assetFile.getParent().toFile();
                    if (!parentFolder.exists()) {
                        parentFolder.mkdirs();
                    }
                    java.nio.file.Files.copy(sourceTemplate, assetFile, new CopyOption[0]);
                }
                catch (Exception e) {
                    LOGGER.error((Object)e);
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("Error while copying initial capsule templates, there will be no loots, prefabs or starters!", (Throwable)e);
        }
    }

    public static void iterateTemplates(File templateFolder, Consumer<String> onTemplateFound) {
        if (templateFolder.exists() && templateFolder.isDirectory()) {
            Iterator iterator = null;
            try {
                iterator = java.nio.file.Files.walk(templateFolder.toPath(), new FileVisitOption[0]).iterator();
                while (iterator.hasNext()) {
                    Path path = (Path)iterator.next();
                    File file = path.toFile();
                    if (!file.isFile() || !file.getName().endsWith(".nbt") && !file.getName().endsWith(".schematic")) continue;
                    Path relative = templateFolder.toPath().relativize(path);
                    onTemplateFound.accept(relative.toString().replaceAll("\\\\", "/").replaceAll(".nbt", "").replaceAll(".schematic", ""));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

