/*
 * Decompiled with CFR 0.152.
 */
package capsule.helpers;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.gen.feature.template.Template;

public class Spacial {
    public static final float MAX_BLOCKS_PER_TICK_THROW = 1.2f;

    public static BlockPos findBottomBlock(ItemEntity ItemEntity2) {
        return Spacial.findBottomBlock(ItemEntity2.func_226277_ct_(), ItemEntity2.func_226278_cu_(), ItemEntity2.func_226281_cx_());
    }

    public static BlockPos findBottomBlock(double x, double y, double z) {
        return BlockPos.func_218281_b((BlockPos)new BlockPos(x, y - 1.0, z), (BlockPos)new BlockPos(x + 1.0, y + 1.0, z + 1.0)).min(Comparator.comparingDouble(pos -> pos.func_218140_a(x, y, z, true))).orElse(null);
    }

    public static boolean isImmergedInLiquid(Entity entity) {
        if (entity == null) {
            return false;
        }
        return !entity.func_70038_c(0.0, 1.5, 0.0);
    }

    public static BlockRayTraceResult clientRayTracePreview(PlayerEntity thePlayer, float partialTicks, int size) {
        int blockReachDistance = 18 + size;
        Vec3d vec3d = thePlayer.func_174824_e(partialTicks);
        Vec3d vec3d1 = thePlayer.func_70676_i(partialTicks);
        Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * (double)blockReachDistance, vec3d1.field_72448_b * (double)blockReachDistance, vec3d1.field_72449_c * (double)blockReachDistance);
        boolean stopOnLiquid = !Spacial.isImmergedInLiquid((Entity)thePlayer);
        return thePlayer.func_130014_f_().func_217299_a(new RayTraceContext(vec3d, vec3d2, RayTraceContext.BlockMode.COLLIDER, stopOnLiquid ? RayTraceContext.FluidMode.ANY : RayTraceContext.FluidMode.NONE, (Entity)thePlayer));
    }

    @Nullable
    public static BlockPos findSpecificBlock(ItemEntity ItemEntity2, int maxRange, Class<? extends Block> searchedBlock) {
        if (searchedBlock == null) {
            return null;
        }
        double i = ItemEntity2.func_226277_ct_();
        double j = ItemEntity2.func_226278_cu_();
        double k = ItemEntity2.func_226281_cx_();
        for (int range = 1; range < maxRange; ++range) {
            Iterable blockPoss = BlockPos.func_218278_a((BlockPos)new BlockPos(i - (double)range, j - (double)range, k - (double)range), (BlockPos)new BlockPos(i + (double)range, j + (double)range, k + (double)range));
            for (BlockPos pos : blockPoss) {
                Block block = ItemEntity2.func_130014_f_().func_175667_e(pos) ? ItemEntity2.func_130014_f_().func_180495_p(pos).func_177230_c() : null;
                if (block == null || !block.getClass().equals(searchedBlock)) continue;
                return new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
        }
        return null;
    }

    public static List<AxisAlignedBB> mergeVoxels(List<Template.BlockInfo> blocks) {
        HashMap blocksByPos = new HashMap();
        HashMap bbByPos = new HashMap();
        blocks.forEach(b -> blocksByPos.put(b.field_186242_a, b));
        blocks.forEach(block -> {
            BlockPos destPos = block.field_186242_a;
            BlockPos below = block.field_186242_a.func_177982_a(0, -1, 0);
            if (bbByPos.containsKey(below) && blocksByPos.containsKey(below) && ((Template.BlockInfo)blocksByPos.get((Object)below)).field_186243_b.func_177230_c() == block.field_186243_b.func_177230_c()) {
                MutableBoundingBox bb = (MutableBoundingBox)bbByPos.get(below);
                ++bb.field_78894_e;
                bbByPos.put(destPos, bb);
            } else {
                MutableBoundingBox column = new MutableBoundingBox((Vec3i)block.field_186242_a, (Vec3i)block.field_186242_a);
                bbByPos.put(destPos, column);
            }
        });
        List<MutableBoundingBox> allBB = bbByPos.values().stream().distinct().collect(Collectors.toList());
        ArrayList toRemove = new ArrayList();
        allBB.forEach(bb -> {
            if (!toRemove.contains(bb)) {
                MutableBoundingBox matchingBB = Spacial.findMatchingExpandingX(bb, allBB);
                while (matchingBB != null) {
                    toRemove.add(matchingBB);
                    bb.func_78888_b(matchingBB);
                    matchingBB = Spacial.findMatchingExpandingX(bb, allBB);
                }
            }
        });
        allBB.removeAll(toRemove);
        toRemove.clear();
        allBB.forEach(bb -> {
            if (!toRemove.contains(bb)) {
                MutableBoundingBox matchingBB = Spacial.findMatchingExpandingZ(bb, allBB);
                while (matchingBB != null) {
                    toRemove.add(matchingBB);
                    bb.func_78888_b(matchingBB);
                    matchingBB = Spacial.findMatchingExpandingZ(bb, allBB);
                }
            }
        });
        allBB.removeAll(toRemove);
        return allBB.stream().map(bb -> new AxisAlignedBB(new BlockPos(bb.field_78897_a, bb.field_78895_b, bb.field_78896_c), new BlockPos(bb.field_78893_d, bb.field_78894_e, bb.field_78892_f))).collect(Collectors.toList());
    }

    private static MutableBoundingBox findMatchingExpandingX(MutableBoundingBox bb, List<MutableBoundingBox> allBB) {
        return allBB.stream().filter(candidate -> candidate != bb && candidate.field_78895_b == bb.field_78895_b && candidate.field_78894_e == bb.field_78894_e && candidate.field_78896_c == bb.field_78896_c && candidate.field_78892_f == bb.field_78892_f && candidate.field_78897_a == bb.field_78893_d + 1).findFirst().orElse(null);
    }

    private static MutableBoundingBox findMatchingExpandingZ(MutableBoundingBox bb, List<MutableBoundingBox> allBB) {
        return allBB.stream().filter(candidate -> candidate != bb && candidate.field_78895_b == bb.field_78895_b && candidate.field_78894_e == bb.field_78894_e && candidate.field_78897_a == bb.field_78897_a && candidate.field_78893_d == bb.field_78893_d && candidate.field_78896_c == bb.field_78892_f + 1).findFirst().orElse(null);
    }

    public static boolean isThrowerUnderLiquid(ItemEntity ItemEntity2) {
        UUID thrower = ItemEntity2.func_200214_m();
        if (thrower == null) {
            return false;
        }
        PlayerEntity player = ItemEntity2.func_130014_f_().func_217371_b(thrower);
        boolean underLiquid = Spacial.isImmergedInLiquid((Entity)player);
        return underLiquid;
    }

    public static boolean isEntityCollidingLiquid(ItemEntity ItemEntity2) {
        return !ItemEntity2.func_70038_c(0.0, -0.1, 0.0);
    }

    public static boolean ItemEntityShouldAndCollideLiquid(ItemEntity ItemEntity2) {
        boolean throwerInLiquid = Spacial.isThrowerUnderLiquid(ItemEntity2);
        boolean entityInLiquid = Spacial.isEntityCollidingLiquid(ItemEntity2);
        return !throwerInLiquid && entityInLiquid;
    }

    public static void moveItemEntityToDeployPos(ItemEntity ItemEntity2, ItemStack capsule, boolean keepMomentum) {
        if (capsule.func_77978_p() == null) {
            return;
        }
        BlockPos dest = BlockPos.func_218283_e((long)capsule.func_77978_p().func_74763_f("deployAt"));
        double diffX = (double)dest.func_177958_n() + 0.5 - ItemEntity2.func_226277_ct_();
        double diffZ = (double)dest.func_177952_p() + 0.5 - ItemEntity2.func_226281_cx_();
        double distance = MathHelper.func_76133_a((double)(diffX * diffX + diffZ * diffZ));
        double requiredVelocity = distance / 10.0;
        double velocity = Math.min(requiredVelocity, (double)1.2f);
        double normalizedDiffX = diffX / distance;
        double normalizedDiffZ = diffZ / distance;
        Vec3d motion = ItemEntity2.func_213322_ci();
        ItemEntity2.func_213293_j(keepMomentum ? 0.9 * motion.field_72450_a + 0.1 * normalizedDiffX * velocity : normalizedDiffX * velocity, motion.field_72448_b, keepMomentum ? 0.9 * motion.field_72449_c + 0.1 * normalizedDiffZ * velocity : normalizedDiffZ * velocity);
    }
}

