/*
 * Decompiled with CFR 0.152.
 */
package capsule.items;

import capsule.CapsuleMod;
import capsule.Config;
import capsule.StructureSaver;
import capsule.client.CapsulePreviewHandler;
import capsule.helpers.Capsule;
import capsule.helpers.MinecraftNBT;
import capsule.helpers.Spacial;
import capsule.items.CapsuleItems;
import capsule.network.CapsuleContentPreviewQueryToServer;
import capsule.network.CapsuleLeftClickQueryToServer;
import capsule.network.CapsuleNetwork;
import capsule.network.CapsuleThrowQueryToServer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.StringUtils;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="capsule", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CapsuleItem
extends Item {
    public static final int ACTIVE_DURATION_IN_TICKS = 60;
    public static final int CAPSULE_MAX_CAPTURE_SIZE = 255;
    protected static final Logger LOGGER = LogManager.getLogger(CapsuleItem.class);
    public static final float TO_RAD = (float)Math.PI / 180;
    public static final float GRAVITY_PER_TICK = 0.04f;
    public static long lastRotationTime = 0L;

    public CapsuleItem() {
        super(new Item.Properties().func_200916_a(CapsuleMod.tabCapsule).func_200917_a(1).func_200918_c(0).setNoRepair());
        this.func_185043_a(new ResourceLocation("capsule", "state"), (stack, world, entity) -> CapsuleItem.getState(stack).getValue());
    }

    public static boolean isOneUse(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_196082_o().func_74764_b("oneUse") && stack.func_77978_p().func_74767_n("oneUse");
    }

    public static void setOneUse(ItemStack capsule) {
        CapsuleItem.setState(capsule, CapsuleState.ONE_USE);
        capsule.func_196082_o().func_74757_a("oneUse", true);
    }

    public static boolean isBlueprint(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() instanceof CapsuleItem && stack.func_196082_o().func_74764_b("sourceInventory");
    }

    public static void setBlueprint(ItemStack capsule) {
        CapsuleItem.saveSourceInventory(capsule, null, 0);
    }

    public static boolean isReward(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_196082_o().func_74764_b("isReward") && stack.func_77978_p().func_74767_n("isReward") && CapsuleItem.isOneUse(stack);
    }

    public static void setIsReward(ItemStack capsule) {
        capsule.func_196082_o().func_74757_a("isReward", true);
        CapsuleItem.setOneUse(capsule);
    }

    public static boolean isInstantAndUndeployed(ItemStack capsule) {
        return CapsuleItem.hasState(capsule, CapsuleState.BLUEPRINT) || CapsuleItem.getSize(capsule) == 1 && !CapsuleItem.hasState(capsule, CapsuleState.DEPLOYED);
    }

    public static boolean hasStructureLink(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_196082_o().func_74764_b("structureName");
    }

    public static boolean isLinkedStateCapsule(ItemStack itemstack) {
        return !itemstack.func_190926_b() && itemstack.func_77973_b() instanceof CapsuleItem && CapsuleItem.hasState(itemstack, CapsuleState.LINKED);
    }

    public static String getLabel(ItemStack stack) {
        if (stack.func_190926_b()) {
            return "";
        }
        if (!CapsuleItem.hasStructureLink(stack) && !CapsuleItem.hasState(stack, CapsuleState.LINKED)) {
            return I18n.func_135052_a((String)"items.capsule.content_empty", (Object[])new Object[0]);
        }
        if (stack.func_196082_o().func_74764_b("label") && !"".equals(stack.func_77978_p().func_74779_i("label"))) {
            return "\u00ab" + TextFormatting.ITALIC + stack.func_77978_p().func_74779_i("label") + TextFormatting.RESET + "\u00bb";
        }
        return I18n.func_135052_a((String)"items.capsule.content_unlabeled", (Object[])new Object[0]);
    }

    public static void setLabel(ItemStack capsule, String label) {
        capsule.func_196082_o().func_74778_a("label", label);
    }

    public static int getSize(ItemStack capsule) {
        int size = 1;
        if (!capsule.func_190926_b() && capsule.func_77942_o() && capsule.func_77978_p().func_74764_b("size")) {
            size = capsule.func_77978_p().func_74762_e("size");
        }
        if (size > 255) {
            size = 255;
            capsule.func_77978_p().func_74768_a("size", size);
            LOGGER.error("Capsule sizes are capped to 255. Resized to : " + size);
        } else if (size % 2 == 0) {
            capsule.func_77978_p().func_74768_a("size", ++size);
            LOGGER.error("Capsule size must be an odd number to achieve consistency on deployment. Resized to : " + size);
        }
        return size;
    }

    public static void setSize(ItemStack capsule, int size) {
        if (size > 255) {
            size = 255;
            LOGGER.warn("Capsule sizes are capped to 255. Resized to : " + size);
        } else if (size % 2 == 0) {
            LOGGER.warn("Capsule size must be an odd number to achieve consistency on deployment. Resized to : " + ++size);
        }
        capsule.func_196082_o().func_74768_a("size", size);
    }

    public static String getStructureName(ItemStack capsule) {
        String name = null;
        if (capsule != null && capsule.func_77942_o() && capsule.func_77978_p().func_74764_b("structureName")) {
            name = capsule.func_77978_p().func_74779_i("structureName");
        }
        return name;
    }

    public static void setStructureName(ItemStack capsule, String structureName) {
        if (!capsule.func_77942_o()) {
            capsule.func_77982_d(new CompoundNBT());
        }
        capsule.func_77978_p().func_74778_a("structureName", structureName);
    }

    public static String getAuthor(ItemStack capsule) {
        String name = null;
        if (capsule != null && capsule.func_77942_o() && capsule.func_77978_p().func_74764_b("author")) {
            name = capsule.func_77978_p().func_74779_i("author");
        }
        return name;
    }

    public static void setAuthor(ItemStack capsule, String author) {
        if (!capsule.func_77942_o()) {
            capsule.func_77982_d(new CompoundNBT());
        }
        if (!StringUtils.func_151246_b((String)author)) {
            capsule.func_77978_p().func_74778_a("author", author);
        }
    }

    public static int getBaseColor(ItemStack capsule) {
        return MinecraftNBT.getColor(capsule);
    }

    public static void setBaseColor(ItemStack capsule, int color) {
        MinecraftNBT.setColor(capsule, color);
    }

    public static int getMaterialColor(ItemStack capsule) {
        int color = 0;
        if (capsule != null && capsule.func_77942_o() && capsule.func_77978_p().func_74764_b("color")) {
            color = capsule.func_77978_p().func_74762_e("color");
        }
        return color;
    }

    public static void setMaterialColor(ItemStack capsule, int color) {
        if (!capsule.func_77942_o()) {
            capsule.func_77982_d(new CompoundNBT());
        }
        capsule.func_77978_p().func_74768_a("color", color);
    }

    public static int getUpgradeLevel(ItemStack stack) {
        int upgradeLevel = 0;
        if (stack.func_196082_o().func_74764_b("upgraded")) {
            upgradeLevel = stack.func_77978_p().func_74762_e("upgraded");
        }
        return upgradeLevel;
    }

    public static void setUpgradeLevel(ItemStack capsule, int upgrades) {
        if (!capsule.func_77942_o()) {
            capsule.func_77982_d(new CompoundNBT());
        }
        capsule.func_77978_p().func_74768_a("upgraded", upgrades);
    }

    public static Integer getDimension(ItemStack capsule) {
        Integer dim = null;
        if (capsule != null && capsule.func_77942_o() && capsule.func_77978_p().func_74764_b("spawnPosition")) {
            dim = capsule.func_77978_p().func_74775_l("spawnPosition").func_74762_e("dim");
        }
        return dim;
    }

    public static void setState(ItemStack stack, CapsuleState state) {
        stack.func_196082_o().func_74768_a("state", state.getValue());
    }

    public static boolean isOverpowered(ItemStack stack) {
        return stack.func_196082_o().func_74764_b("overpowered") && stack.func_77978_p().func_74771_c("overpowered") == 1;
    }

    private static boolean isActivated(ItemStack capsule) {
        return CapsuleItem.hasState(capsule, CapsuleState.ACTIVATED) || CapsuleItem.hasState(capsule, CapsuleState.EMPTY_ACTIVATED) || CapsuleItem.hasState(capsule, CapsuleState.ONE_USE_ACTIVATED);
    }

    public static void setCanRotate(ItemStack capsule, boolean canRotate) {
        if (!capsule.func_77942_o()) {
            capsule.func_77982_d(new CompoundNBT());
        }
        capsule.func_77978_p().func_74757_a("canRotate", canRotate);
    }

    public static boolean canRotate(ItemStack capsule) {
        return CapsuleItem.isBlueprint(capsule) || !CapsuleItem.hasState(capsule, CapsuleState.DEPLOYED) && capsule.func_77942_o() && capsule.func_77978_p().func_74764_b("canRotate") && capsule.func_77978_p().func_74767_n("canRotate");
    }

    public static void revertStateFromActivated(ItemStack capsule) {
        if (CapsuleItem.isBlueprint(capsule)) {
            CapsuleItem.setState(capsule, CapsuleState.BLUEPRINT);
        } else if (CapsuleItem.isOneUse(capsule)) {
            CapsuleItem.setState(capsule, CapsuleState.ONE_USE);
        } else if (CapsuleItem.hasStructureLink(capsule)) {
            CapsuleItem.setState(capsule, CapsuleState.LINKED);
        } else {
            CapsuleItem.setState(capsule, CapsuleState.EMPTY);
        }
        if (capsule.func_77942_o()) {
            capsule.func_77978_p().func_82580_o("activetimer");
        }
    }

    public static CapsuleState getState(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return CapsuleState.valueOf(0);
        }
        if (stack.func_77978_p().func_74764_b("state")) {
            return CapsuleState.valueOf(stack.func_77978_p().func_74762_e("state"));
        }
        return CapsuleState.valueOf(stack.func_77978_p().func_74762_e("Damage"));
    }

    public static boolean hasState(ItemStack stack, CapsuleState state) {
        return stack.func_77942_o() && stack.func_77978_p().func_74762_e("state") == state.getValue();
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        String content;
        String name = I18n.func_135052_a((String)"items.capsule.name", (Object[])new Object[0]);
        String state = "";
        switch (CapsuleItem.getState(stack)) {
            case ACTIVATED: 
            case EMPTY_ACTIVATED: 
            case ONE_USE_ACTIVATED: {
                state = TextFormatting.DARK_GREEN + I18n.func_135052_a((String)"items.capsule.state_activated", (Object[])new Object[0]) + TextFormatting.RESET;
                break;
            }
            case LINKED: {
                state = "";
                break;
            }
            case DEPLOYED: {
                if (CapsuleItem.isBlueprint(stack)) {
                    name = I18n.func_135052_a((String)"items.capsule.state_blueprint", (Object[])new Object[0]);
                    break;
                }
                state = I18n.func_135052_a((String)"items.capsule.state_deployed", (Object[])new Object[0]);
                break;
            }
            case ONE_USE: {
                if (CapsuleItem.isReward(stack)) {
                    state = I18n.func_135052_a((String)"items.capsule.state_one_use", (Object[])new Object[0]);
                    break;
                }
                state = I18n.func_135052_a((String)"items.capsule.state_recovery", (Object[])new Object[0]);
                break;
            }
            case BLUEPRINT: {
                name = I18n.func_135052_a((String)"items.capsule.state_blueprint", (Object[])new Object[0]);
            }
        }
        if (state.length() > 0) {
            state = state + " ";
        }
        if ((content = CapsuleItem.getLabel(stack)).length() > 0) {
            content = content + " ";
        }
        return new StringTextComponent(TextFormatting.RESET + state + content + name);
    }

    public int func_77619_b() {
        return 5;
    }

    public int getItemEnchantability(ItemStack stack) {
        return this.func_77619_b();
    }

    public boolean func_77616_k(ItemStack stack) {
        return !CapsuleItem.hasState(stack, CapsuleState.ONE_USE);
    }

    public boolean func_77636_d(ItemStack stack) {
        return CapsuleItem.isOverpowered(stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack capsule, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        String author = CapsuleItem.getAuthor(capsule);
        if (author != null) {
            tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.DARK_AQUA + "" + TextFormatting.ITALIC + I18n.func_135052_a((String)"capsule.tooltip.author", (Object[])new Object[0]) + " " + author + TextFormatting.RESET));
        }
        if (CapsuleItem.hasState(capsule, CapsuleState.ONE_USE)) {
            tooltip.add((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"capsule.tooltip.one_use", (Object[])new Object[0]).trim()));
        }
        if (CapsuleItem.isOverpowered(capsule)) {
            tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.DARK_PURPLE + I18n.func_135052_a((String)"capsule.tooltip.overpowered", (Object[])new Object[0]) + TextFormatting.RESET));
        }
        int size = CapsuleItem.getSize(capsule);
        int upgradeLevel = CapsuleItem.getUpgradeLevel(capsule);
        String sizeTxt = size + "\u00d7" + size + "\u00d7" + size;
        if (upgradeLevel > 0) {
            sizeTxt = sizeTxt + " (" + upgradeLevel + "/" + Config.upgradeLimit + " " + I18n.func_135052_a((String)"capsule.tooltip.upgraded", (Object[])new Object[0]) + ")";
        }
        if (CapsuleItem.isInstantAndUndeployed(capsule) || CapsuleItem.isBlueprint(capsule)) {
            sizeTxt = sizeTxt + " (" + I18n.func_135052_a((String)"capsule.tooltip.instant", (Object[])new Object[0]).trim() + ")";
        }
        tooltip.add((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"capsule.tooltip.size", (Object[])new Object[0]) + ": " + sizeTxt));
        if (CapsuleItem.isBlueprint(capsule)) {
            if (CapsuleItem.hasState(capsule, CapsuleState.DEPLOYED)) {
                this.tooltipAddMultiline(tooltip, "capsule.tooltip.blueprintUseUncharged", TextFormatting.WHITE);
            } else {
                this.tooltipAddMultiline(tooltip, "capsule.tooltip.canRotate", TextFormatting.WHITE);
                this.tooltipAddMultiline(tooltip, "capsule.tooltip.blueprintUseCharged", TextFormatting.WHITE);
            }
        } else if (CapsuleItem.canRotate(capsule)) {
            this.tooltipAddMultiline(tooltip, "capsule.tooltip.canRotate", TextFormatting.WHITE);
        } else if (capsule.func_77942_o() && capsule.func_77978_p().func_74764_b("canRotate")) {
            this.tooltipAddMultiline(tooltip, "capsule.tooltip.cannotRotate", TextFormatting.DARK_GRAY);
        }
        if (flagIn == ITooltipFlag.TooltipFlags.ADVANCED) {
            tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GOLD + "structureName: " + CapsuleItem.getStructureName(capsule)));
            tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GOLD + "oneUse: " + CapsuleItem.isOneUse(capsule)));
            tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GOLD + "isReward: " + CapsuleItem.isReward(capsule)));
            if (CapsuleItem.isBlueprint(capsule)) {
                tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GOLD + "sourceInventory: " + CapsuleItem.getSourceInventoryLocation(capsule) + " in dimension " + CapsuleItem.getSourceInventoryDimension(capsule)));
            }
            tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GOLD + "color (material): " + Integer.toHexString(CapsuleItem.getMaterialColor(capsule))));
            PlacementSettings p = CapsuleItem.getPlacement(capsule);
            tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GOLD + "\u232f Symmetry: " + Capsule.getMirrorLabel(p)));
            tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GOLD + "\u27f3 Rotation: " + Capsule.getRotationLabel(p)));
        }
    }

    public void tooltipAddMultiline(List<ITextComponent> tooltip, String key, TextFormatting formatting) {
        for (String s : I18n.func_135052_a((String)key, (Object[])new Object[0]).trim().split("\\\\n")) {
            tooltip.add((ITextComponent)new StringTextComponent(formatting == null ? s : formatting + s));
        }
    }

    public void func_150895_a(ItemGroup tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            subItems.addAll(CapsuleItems.capsuleList.keySet());
            subItems.addAll(CapsuleItems.opCapsuleList.keySet());
            if (CapsuleItems.unlabelledCapsule != null) {
                subItems.add(CapsuleItems.unlabelledCapsule.getKey());
            }
            if (CapsuleItems.deployedCapsule != null) {
                subItems.add(CapsuleItems.deployedCapsule.getKey());
            }
            if (CapsuleItems.recoveryCapsule != null) {
                subItems.add(CapsuleItems.recoveryCapsule.getKey());
            }
            if (CapsuleItems.blueprintChangedCapsule != null) {
                subItems.add(CapsuleItems.blueprintChangedCapsule.getKey());
            }
            for (Pair<ItemStack, ICraftingRecipe> blueprintCapsule : CapsuleItems.blueprintCapsules) {
                subItems.add(blueprintCapsule.getKey());
            }
            for (Pair<ItemStack, ICraftingRecipe> blueprintCapsule : CapsuleItems.blueprintPrefabs) {
                subItems.add(blueprintCapsule.getKey());
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onLeftClick(PlayerInteractEvent.LeftClickEmpty event) {
        ItemStack stack = event.getPlayer().func_184614_ca();
        if (event.getWorld().field_72995_K && stack.func_77973_b() instanceof CapsuleItem && (CapsuleItem.isBlueprint(stack) || CapsuleItem.canRotate(stack))) {
            CapsuleNetwork.wrapper.sendToServer((Object)new CapsuleLeftClickQueryToServer());
            CapsuleItem.askPreviewIfNeeded(stack);
        }
    }

    @SubscribeEvent
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        ItemStack stack;
        if (!event.isCanceled() && (stack = event.getPlayer().func_184614_ca()).func_77973_b() instanceof CapsuleItem) {
            event.setCanceled(true);
            if (event.getWorld().field_72995_K) {
                if (CapsuleItem.canRotate(stack)) {
                    if (lastRotationTime + 60L < Util.func_211177_b()) {
                        lastRotationTime = Util.func_211177_b();
                        CapsuleNetwork.wrapper.sendToServer((Object)new CapsuleLeftClickQueryToServer());
                        CapsuleItem.askPreviewIfNeeded(stack);
                    }
                } else if (!CapsuleItem.hasState(stack, CapsuleState.DEPLOYED)) {
                    event.getPlayer().func_145747_a((ITextComponent)new TranslationTextComponent("capsule.tooltip.cannotRotate", new Object[0]));
                }
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void heldItemChange(LivingEquipmentChangeEvent event) {
        if (event.getEntity() instanceof PlayerEntity && event.getSlot().equals((Object)EquipmentSlotType.MAINHAND) && CapsuleItem.isBlueprint(event.getTo())) {
            CapsuleItem.askPreviewIfNeeded(event.getTo());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void askPreviewIfNeeded(ItemStack stack) {
        if (!CapsulePreviewHandler.currentPreview.containsKey(CapsuleItem.getStructureName(stack)) && Minecraft.func_71410_x().func_147114_u() != null) {
            CapsuleNetwork.wrapper.sendToServer((Object)new CapsuleContentPreviewQueryToServer(CapsuleItem.getStructureName(stack)));
        }
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        TileEntity te;
        Hand hand = context.func_221531_n();
        if (context.func_221531_n() == Hand.OFF_HAND) {
            return ActionResultType.PASS;
        }
        PlayerEntity player = context.func_195999_j();
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        ItemStack capsule = player.func_184586_b(hand);
        if (player.func_225608_bj_() && CapsuleItem.isBlueprint(capsule) && (te = world.func_175625_s(pos)) != null && te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).isPresent()) {
            if (CapsuleItem.hasSourceInventory(capsule) && pos.equals((Object)CapsuleItem.getSourceInventoryLocation(capsule)) && CapsuleItem.getSourceInventoryDimension(capsule).equals(world.field_73011_w.func_186058_p().func_186068_a())) {
                CapsuleItem.saveSourceInventory(capsule, null, 0);
            } else {
                CapsuleItem.saveSourceInventory(capsule, pos, world.field_73011_w.func_186058_p().func_186068_a());
            }
            return ActionResultType.SUCCESS;
        }
        return super.onItemUseFirst(stack, context);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack capsule = playerIn.func_184586_b(handIn);
        if (handIn == Hand.OFF_HAND) {
            return new ActionResult(ActionResultType.FAIL, (Object)capsule);
        }
        if (playerIn.func_225608_bj_() && (CapsuleItem.hasState(capsule, CapsuleState.LINKED) || CapsuleItem.hasState(capsule, CapsuleState.DEPLOYED) || CapsuleItem.hasState(capsule, CapsuleState.ONE_USE) || CapsuleItem.hasState(capsule, CapsuleState.BLUEPRINT))) {
            CapsuleMod.openGuiScreenCommon.accept(playerIn);
        } else if (!worldIn.field_72995_K) {
            if (!CapsuleItem.isInstantAndUndeployed(capsule)) {
                this.activateCapsule(capsule, worldIn, playerIn);
            }
        } else if (worldIn.field_72995_K) {
            BlockPos dest;
            BlockRayTraceResult rtr;
            if (!CapsuleItem.isInstantAndUndeployed(capsule) && (CapsuleItem.hasState(capsule, CapsuleState.LINKED) || CapsuleItem.hasState(capsule, CapsuleState.ONE_USE))) {
                rtr = CapsuleItem.hasStructureLink(capsule) ? Spacial.clientRayTracePreview(playerIn, 0.0f, CapsuleItem.getSize(capsule)) : null;
                BlockPos blockPos = dest = rtr != null && rtr.func_216346_c() == RayTraceResult.Type.BLOCK ? rtr.func_216350_a().func_177971_a(rtr.func_216354_b().func_176730_m()) : null;
                if (dest != null) {
                    CapsuleNetwork.wrapper.sendToServer((Object)new CapsuleContentPreviewQueryToServer(capsule.func_77978_p().func_74779_i("structureName")));
                }
            }
            if (CapsuleItem.isInstantAndUndeployed(capsule)) {
                rtr = Spacial.clientRayTracePreview(playerIn, 0.0f, CapsuleItem.getSize(capsule));
                dest = null;
                if (rtr != null && rtr.func_216346_c() == RayTraceResult.Type.BLOCK) {
                    dest = CapsuleItem.hasState(capsule, CapsuleState.EMPTY) ? rtr.func_216350_a() : rtr.func_216350_a().func_177971_a(rtr.func_216354_b().func_176730_m());
                }
                if (dest != null) {
                    CapsuleNetwork.wrapper.sendToServer((Object)new CapsuleThrowQueryToServer(dest, true));
                }
            } else if (CapsuleItem.isActivated(capsule)) {
                rtr = CapsuleItem.hasStructureLink(capsule) ? Spacial.clientRayTracePreview(playerIn, 0.0f, CapsuleItem.getSize(capsule)) : null;
                dest = rtr != null && rtr.func_216346_c() == RayTraceResult.Type.BLOCK ? rtr.func_216350_a().func_177971_a(rtr.func_216354_b().func_176730_m()) : null;
                CapsuleNetwork.wrapper.sendToServer((Object)new CapsuleThrowQueryToServer(dest, false));
            }
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)capsule);
    }

    public void activateCapsule(ItemStack capsule, World worldIn, PlayerEntity playerIn) {
        if (CapsuleItem.hasState(capsule, CapsuleState.EMPTY)) {
            CapsuleItem.setState(capsule, CapsuleState.EMPTY_ACTIVATED);
            this.startTimer(worldIn, playerIn, capsule);
        } else if (CapsuleItem.hasState(capsule, CapsuleState.LINKED)) {
            CapsuleItem.setState(capsule, CapsuleState.ACTIVATED);
            this.startTimer(worldIn, playerIn, capsule);
        } else if (CapsuleItem.hasState(capsule, CapsuleState.ONE_USE)) {
            CapsuleItem.setState(capsule, CapsuleState.ONE_USE_ACTIVATED);
            this.startTimer(worldIn, playerIn, capsule);
        } else if (CapsuleItem.hasState(capsule, CapsuleState.DEPLOYED) && CapsuleItem.getDimension(capsule) != null) {
            try {
                Capsule.resentToCapsule(capsule, playerIn);
                worldIn.func_184133_a(null, playerIn.func_180425_c(), SoundEvents.field_187837_fU, SoundCategory.BLOCKS, 0.2f, 0.4f);
            }
            catch (Exception e) {
                LOGGER.error("Couldn't resend the content into the capsule", (Throwable)e);
            }
        }
    }

    private void startTimer(World worldIn, PlayerEntity playerIn, ItemStack capsule) {
        CompoundNBT timer = capsule.func_190925_c("activetimer");
        timer.func_74768_a("starttime", playerIn.field_70173_aa);
        worldIn.func_184133_a(null, playerIn.func_180425_c(), SoundEvents.field_187839_fV, SoundCategory.BLOCKS, 0.2f, 0.9f);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        if (!worldIn.field_72995_K) {
            CompoundNBT timer = stack.func_179543_a("activetimer");
            if (timer != null && CapsuleItem.isActivated(stack) && timer.func_74764_b("starttime") && entityIn.field_70173_aa >= timer.func_74762_e("starttime") + 60) {
                CapsuleItem.revertStateFromActivated(stack);
                worldIn.func_184133_a(null, entityIn.func_180425_c(), SoundEvents.field_187837_fU, SoundCategory.BLOCKS, 0.2f, 0.4f);
            }
            if (CapsuleItem.isActivated(stack) && !timer.func_74764_b("starttime")) {
                CapsuleItem.revertStateFromActivated(stack);
            }
        }
    }

    public boolean onEntityItemUpdate(ItemStack capsule, ItemEntity entity) {
        super.onEntityItemUpdate(capsule, entity);
        if (capsule == null) {
            return false;
        }
        if (!entity.func_130014_f_().field_72995_K && entity.field_70173_aa > 2 && CapsuleItem.isActivated(capsule) && (entity.field_70132_H || Spacial.ItemEntityShouldAndCollideLiquid(entity))) {
            Capsule.handleItemEntityOnGround(entity, capsule);
        }
        if (!entity.func_130014_f_().field_72995_K && CapsuleItem.isActivated(capsule) && capsule.func_196082_o().func_74764_b("deployAt") && !entity.field_70132_H && !Spacial.ItemEntityShouldAndCollideLiquid(entity)) {
            Spacial.moveItemEntityToDeployPos(entity, capsule, true);
        }
        return false;
    }

    @SubscribeEvent
    public static void onTickPlayerEvent(TickEvent.PlayerTickEvent event) {
        if (!event.player.field_70170_p.field_72995_K) {
            for (int i = 0; i < event.player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack itemstack = event.player.field_71071_by.func_70301_a(i);
                if (!itemstack.func_77942_o() || !itemstack.func_77978_p().func_74764_b("templateShouldBeCopied")) continue;
                CapsuleItem.duplicateBlueprintTemplate(itemstack, event.player.field_70170_p, event.player);
            }
        }
    }

    public void func_77622_d(ItemStack capsule, World worldIn, PlayerEntity playerIn) {
        CapsuleItem.duplicateBlueprintTemplate(capsule, worldIn, playerIn);
    }

    public static void duplicateBlueprintTemplate(ItemStack capsule, World worldIn, PlayerEntity playerIn) {
        String srcStructurePath;
        if (!worldIn.field_72995_K && capsule.func_77973_b() instanceof CapsuleItem && CapsuleItem.isBlueprint(capsule) && (srcStructurePath = CapsuleItem.getStructureName(capsule)) != null) {
            String templateName = StructureSaver.createBlueprintTemplate(srcStructurePath, capsule, (ServerWorld)worldIn, playerIn);
            CapsuleItem.setStructureName(capsule, templateName);
            if (capsule.func_77978_p() != null) {
                capsule.func_77978_p().func_82580_o("templateShouldBeCopied");
            }
        }
    }

    public static Map<BlockPos, Block> getOccupiedSourcePos(ItemStack capsule) {
        HashMap<BlockPos, Block> occupiedSources = null;
        if (capsule.func_77942_o() && capsule.func_77978_p().func_74764_b("occupiedSpawnPositions")) {
            occupiedSources = new HashMap<BlockPos, Block>();
            ListNBT list = capsule.func_77978_p().func_150295_c("occupiedSpawnPositions", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundNBT entry = list.func_150305_b(i);
                occupiedSources.put(BlockPos.func_218283_e((long)entry.func_74763_f("pos")), Block.func_196257_b((int)entry.func_74762_e("blockId")).func_177230_c());
            }
        }
        return occupiedSources;
    }

    public static void cleanDeploymentTags(ItemStack capsule) {
        capsule.func_77978_p().func_82580_o("spawnPosition");
        capsule.func_77978_p().func_82580_o("occupiedSpawnPositions");
    }

    public static List<Block> getExcludedBlocs(ItemStack stack) {
        List<Block> excludedBlocks = Config.excludedBlocks;
        if (CapsuleItem.isOverpowered(stack)) {
            excludedBlocks = Config.opExcludedBlocks;
        }
        return excludedBlocks;
    }

    public static int getColorFromItemstack(ItemStack stack, int renderPass) {
        int color = 0xFFFFFF;
        if (renderPass == 0) {
            color = MinecraftNBT.getColor(stack);
        } else if (renderPass == 1) {
            if (CapsuleItem.isBlueprint(stack) && CapsuleItem.hasState(stack, CapsuleState.DEPLOYED)) {
                color = 8176874;
            } else if (stack.func_196082_o().func_74764_b("color")) {
                color = stack.func_77978_p().func_74762_e("color");
            }
        } else if (renderPass == 2) {
            color = CapsuleItem.isBlueprint(stack) ? 3912700 : 0xFFFFFF;
        }
        return color;
    }

    public static void saveSpawnPosition(ItemStack capsule, BlockPos dest, int dimID) {
        CompoundNBT pos = new CompoundNBT();
        pos.func_74768_a("x", dest.func_177958_n());
        pos.func_74768_a("y", dest.func_177956_o());
        pos.func_74768_a("z", dest.func_177952_p());
        pos.func_74768_a("dim", dimID);
        capsule.func_196082_o().func_218657_a("spawnPosition", (INBT)pos);
    }

    public static void saveSourceInventory(ItemStack capsule, BlockPos dest, int dimID) {
        CompoundNBT pos = new CompoundNBT();
        if (dest != null) {
            pos.func_74768_a("x", dest.func_177958_n());
            pos.func_74768_a("y", dest.func_177956_o());
            pos.func_74768_a("z", dest.func_177952_p());
            pos.func_74768_a("dim", dimID);
        }
        capsule.func_196082_o().func_218657_a("sourceInventory", (INBT)pos);
    }

    public static boolean hasSourceInventory(ItemStack capsule) {
        return capsule.func_196082_o().func_74764_b("sourceInventory") && capsule.func_77978_p().func_74775_l("sourceInventory").func_74764_b("x");
    }

    @Nullable
    public static BlockPos getSourceInventoryLocation(ItemStack capsule) {
        if (CapsuleItem.hasSourceInventory(capsule)) {
            CompoundNBT sourceInventory = capsule.func_77978_p().func_74775_l("sourceInventory");
            return new BlockPos(sourceInventory.func_74762_e("x"), sourceInventory.func_74762_e("y"), sourceInventory.func_74762_e("z"));
        }
        return null;
    }

    @Nullable
    public static Integer getSourceInventoryDimension(ItemStack capsule) {
        if (CapsuleItem.hasSourceInventory(capsule)) {
            return capsule.func_77978_p().func_74775_l("sourceInventory").func_74762_e("dim");
        }
        return null;
    }

    @Nullable
    public static IItemHandler getSourceInventory(ItemStack blueprint, ServerWorld w) {
        BlockPos location = CapsuleItem.getSourceInventoryLocation(blueprint);
        Integer dimension = CapsuleItem.getSourceInventoryDimension(blueprint);
        if (location == null || dimension == null) {
            return null;
        }
        ServerWorld world = w.func_73046_m().func_71218_a(DimensionType.func_186069_a((int)dimension));
        TileEntity te = world.func_175625_s(location);
        if (te != null) {
            return (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElse(null);
        }
        return null;
    }

    public static void setPlacement(ItemStack blueprint, PlacementSettings placementSettings) {
        if (!blueprint.func_77942_o()) {
            blueprint.func_77982_d(new CompoundNBT());
        }
        blueprint.func_77978_p().func_74778_a("rotation", placementSettings == null ? Rotation.NONE.name() : placementSettings.func_186215_c().name());
        blueprint.func_77978_p().func_74778_a("mirror", placementSettings == null ? Mirror.NONE.name() : placementSettings.func_186212_b().name());
    }

    public static PlacementSettings getPlacement(ItemStack capsule) {
        if (CapsuleItem.hasPlacement(capsule)) {
            PlacementSettings placementSettings = new PlacementSettings().func_186214_a(Mirror.valueOf((String)capsule.func_77978_p().func_74779_i("mirror"))).func_186220_a(Rotation.valueOf((String)capsule.func_77978_p().func_74779_i("rotation"))).func_186222_a(false).func_186218_a(null);
            return placementSettings;
        }
        return new PlacementSettings();
    }

    public static boolean hasPlacement(ItemStack blueprint) {
        if (!blueprint.func_77942_o()) {
            blueprint.func_77982_d(new CompoundNBT());
        }
        return blueprint.func_77978_p().func_74764_b("mirror") && blueprint.func_77978_p().func_74764_b("rotation");
    }

    public static void clearCapsule(ItemStack capsule) {
        CapsuleItem.setState(capsule, CapsuleState.EMPTY);
        if (!capsule.func_77942_o()) {
            return;
        }
        capsule.func_77978_p().func_82580_o("structureName");
        capsule.func_77978_p().func_82580_o("sourceInventory");
    }

    public static enum CapsuleState {
        EMPTY(0),
        EMPTY_ACTIVATED(4),
        ACTIVATED(1),
        LINKED(2),
        DEPLOYED(3),
        ONE_USE(5),
        ONE_USE_ACTIVATED(6),
        BLUEPRINT(7);

        private final int value;
        private static final Map<Integer, CapsuleState> map;

        private CapsuleState(int value) {
            this.value = value;
        }

        public static CapsuleState valueOf(int state) {
            return map.get(state);
        }

        public int getValue() {
            return this.value;
        }

        static {
            map = new HashMap<Integer, CapsuleState>();
            for (CapsuleState state : CapsuleState.values()) {
                map.put(state.value, state);
            }
        }
    }
}

