/*
 * Decompiled with CFR 0.152.
 */
package capsule.items;

import capsule.items.CapsuleItem;
import capsule.recipes.BlueprintCapsuleRecipe;
import capsule.recipes.BlueprintChangeRecipe;
import capsule.recipes.PrefabsBlueprintAggregatorRecipe;
import capsule.recipes.RecoveryCapsuleRecipe;
import capsule.recipes.UpgradeCapsuleRecipe;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;

public class CapsuleItems {
    private static final int UPGRADE_STEP = 2;
    public static CapsuleItem CAPSULE;
    public static TreeMap<ItemStack, ICraftingRecipe> capsuleList;
    public static TreeMap<ItemStack, ICraftingRecipe> opCapsuleList;
    public static List<Pair<ItemStack, ICraftingRecipe>> blueprintCapsules;
    public static List<Pair<ItemStack, ICraftingRecipe>> blueprintPrefabs;
    public static Pair<ItemStack, ICraftingRecipe> unlabelledCapsule;
    public static Pair<ItemStack, ICraftingRecipe> deployedCapsule;
    public static Pair<ItemStack, RecoveryCapsuleRecipe> recoveryCapsule;
    public static Pair<ItemStack, BlueprintChangeRecipe> blueprintChangedCapsule;
    public static Pair<ItemStack, UpgradeCapsuleRecipe> upgradedCapsule;

    public static ItemStack withState(CapsuleItem.CapsuleState state) {
        ItemStack capsule = new ItemStack((IItemProvider)CAPSULE, 1);
        CapsuleItem.setState(capsule, state);
        return capsule;
    }

    private static double compare(ItemStack capsule) {
        return (double)CapsuleItem.getSize(capsule) + (double)CapsuleItem.getMaterialColor(capsule) * 1.0E-12;
    }

    public static void registerItems(RegistryEvent.Register<Item> event) {
        CAPSULE = new CapsuleItem();
        CAPSULE.setRegistryName(new ResourceLocation("capsule", "capsule"));
        event.getRegistry().register((IForgeRegistryEntry)CAPSULE);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerRecipesClient(RecipeManager manager) {
        blueprintCapsules.clear();
        blueprintPrefabs.clear();
        for (IRecipe recipe : manager.func_199510_b()) {
            if (!recipe.func_199560_c().func_110624_b().equals("capsule")) continue;
            if (recipe instanceof BlueprintCapsuleRecipe) {
                blueprintCapsules.add((Pair<ItemStack, ICraftingRecipe>)Pair.of((Object)((BlueprintCapsuleRecipe)recipe).func_77571_b(), (Object)((BlueprintCapsuleRecipe)recipe)));
                continue;
            }
            if (recipe instanceof RecoveryCapsuleRecipe) {
                recoveryCapsule = Pair.of((Object)((RecoveryCapsuleRecipe)recipe).func_77571_b(), (Object)((RecoveryCapsuleRecipe)recipe));
                continue;
            }
            if (recipe instanceof UpgradeCapsuleRecipe) {
                upgradedCapsule = Pair.of((Object)recipe.func_77571_b(), (Object)((UpgradeCapsuleRecipe)recipe));
                continue;
            }
            if (recipe instanceof BlueprintChangeRecipe) {
                blueprintChangedCapsule = Pair.of((Object)recipe.func_77571_b(), (Object)((Object)((BlueprintChangeRecipe)recipe)));
                continue;
            }
            if (recipe instanceof PrefabsBlueprintAggregatorRecipe) {
                PrefabsBlueprintAggregatorRecipe agg = (PrefabsBlueprintAggregatorRecipe)recipe;
                for (PrefabsBlueprintAggregatorRecipe.PrefabsBlueprintCapsuleRecipe aggregatorRecipe : agg.recipes) {
                    blueprintPrefabs.add((Pair<ItemStack, ICraftingRecipe>)Pair.of((Object)aggregatorRecipe.func_77571_b(), (Object)aggregatorRecipe.recipe));
                }
                continue;
            }
            ItemStack output = recipe.func_77571_b();
            if (!(output.func_77973_b() instanceof CapsuleItem) || !(recipe instanceof ShapedRecipe)) continue;
            if (CapsuleItem.isOverpowered(output)) {
                opCapsuleList.put(output, (ICraftingRecipe)((ShapedRecipe)recipe));
                continue;
            }
            capsuleList.put(output, (ICraftingRecipe)((ShapedRecipe)recipe));
        }
        if (capsuleList.size() > 0) {
            unlabelledCapsule = Pair.of((Object)CapsuleItems.getUnlabelledCapsule(capsuleList.firstKey()), null);
            deployedCapsule = Pair.of((Object)CapsuleItems.getDeployedCapsule(capsuleList.firstKey()), null);
        }
    }

    public static ItemStack getUnlabelledCapsule(ItemStack capsule) {
        ItemStack unlabelledCapsule = capsule.func_77946_l();
        CapsuleItem.setState(unlabelledCapsule, CapsuleItem.CapsuleState.LINKED);
        CapsuleItem.setStructureName(unlabelledCapsule, "config/capsule/rewards/example");
        return unlabelledCapsule;
    }

    public static ItemStack getDeployedCapsule(ItemStack capsule) {
        ItemStack unlabelledCapsule = capsule.func_77946_l();
        CapsuleItem.setState(unlabelledCapsule, CapsuleItem.CapsuleState.DEPLOYED);
        CapsuleItem.setStructureName(unlabelledCapsule, "config/capsule/rewards/example");
        return unlabelledCapsule;
    }

    public static ItemStack getUpgradedCapsule(ItemStack ironCapsule, int upLevel) {
        ItemStack capsuleUp = ironCapsule.func_77946_l();
        CapsuleItem.setSize(capsuleUp, CapsuleItem.getSize(ironCapsule) + upLevel * 2);
        CapsuleItem.setUpgradeLevel(capsuleUp, upLevel);
        capsuleUp.func_77983_a("upgraded", (INBT)IntNBT.func_229692_a_((int)upLevel));
        return capsuleUp;
    }

    static {
        capsuleList = new TreeMap(Comparator.comparingDouble(CapsuleItems::compare));
        opCapsuleList = new TreeMap(Comparator.comparingDouble(CapsuleItems::compare));
        blueprintCapsules = new ArrayList<Pair<ItemStack, ICraftingRecipe>>();
        blueprintPrefabs = new ArrayList<Pair<ItemStack, ICraftingRecipe>>();
        unlabelledCapsule = null;
        deployedCapsule = null;
        recoveryCapsule = null;
        blueprintChangedCapsule = null;
        upgradedCapsule = null;
    }
}

