/*
 * Decompiled with CFR 0.152.
 */
package capsule.loot;

import capsule.Config;
import capsule.StructureSaver;
import capsule.helpers.Capsule;
import capsule.helpers.Files;
import capsule.items.CapsuleItem;
import capsule.structure.CapsuleTemplate;
import java.util.Random;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResourceManager;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.StandaloneLootEntry;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraft.world.storage.loot.functions.ILootFunction;
import org.apache.commons.lang3.tuple.Pair;

public class CapsuleLootEntry
extends StandaloneLootEntry {
    public static final int DEFAULT_WEIGHT = 3;
    public static String[] COLOR_PALETTE = new String[]{"0xCCCCCC", "0x549b57", "0xe08822", "0x5e8eb7", "0x6c6c6c", "0xbd5757", "0x99c33d", "0x4a4cba", "0x7b2e89", "0x95d5e7", "0xffffff"};
    private static final Random random = new Random();
    private String templatesPath = null;

    public static LootEntry.Builder<?> builder(String templatePath) {
        return CapsuleLootEntry.func_216156_a((p_216169_1_, p_216169_2_, p_216169_3_, p_216169_4_) -> {
            int weight = CapsuleLootEntry.findConfiguredWeight(templatePath);
            return new CapsuleLootEntry(templatePath, weight);
        });
    }

    public static int findConfiguredWeight(String path) {
        int weight = 3;
        if (Config.lootTemplatesData.containsKey(path)) {
            weight = Config.lootTemplatesData.get((Object)path).weight;
        }
        return weight;
    }

    protected CapsuleLootEntry(String templatesPath, int weightIn) {
        super(weightIn, 0, new ILootCondition[0], new ILootFunction[0]);
        this.templatesPath = templatesPath;
    }

    public static int getRandomColor() {
        return Integer.decode(COLOR_PALETTE[(int)(Math.random() * (double)COLOR_PALETTE.length)]);
    }

    public void func_216154_a(Consumer<ItemStack> stacks, LootContext context) {
        Pair<String, CapsuleTemplate> templatePair;
        if (this.templatesPath == null) {
            return;
        }
        if (Config.lootTemplatesData.containsKey(this.templatesPath) && (templatePair = this.getRandomTemplate(context)) != null) {
            CapsuleTemplate template = (CapsuleTemplate)templatePair.getRight();
            String templatePath = (String)templatePair.getLeft();
            int size = Math.max(template.getSize().func_177958_n(), Math.max(template.getSize().func_177956_o(), template.getSize().func_177952_p()));
            if (template.entities.isEmpty() && Config.allowBlueprintReward) {
                ItemStack capsule = Capsule.newLinkedCapsuleItemStack(templatePath, CapsuleLootEntry.getRandomColor(), CapsuleLootEntry.getRandomColor(), size, false, Capsule.labelFromPath(templatePath), 0);
                CapsuleItem.setAuthor(capsule, template.getAuthor());
                CapsuleItem.setState(capsule, CapsuleItem.CapsuleState.BLUEPRINT);
                CapsuleItem.setBlueprint(capsule);
                CapsuleItem.setCanRotate(capsule, template.canRotate());
                stacks.accept(capsule);
            } else {
                ItemStack capsule = Capsule.newRewardCapsuleItemStack(templatePath, CapsuleLootEntry.getRandomColor(), CapsuleLootEntry.getRandomColor(), size, Capsule.labelFromPath(templatePath), template.getAuthor());
                CapsuleItem.setCanRotate(capsule, template.canRotate());
                stacks.accept(capsule);
            }
        }
    }

    @Nullable
    public Pair<String, CapsuleTemplate> getRandomTemplate(LootContext context) {
        Config.LootPathData lpd = Config.lootTemplatesData.get(this.templatesPath);
        if (lpd == null || lpd.files == null) {
            Files.populateAndLoadLootList(Config.getCapsuleConfigDir().toFile(), Config.lootTemplatesData, (IResourceManager)context.func_202879_g().func_73046_m().func_195570_aG());
            lpd = Config.lootTemplatesData.get(this.templatesPath);
        }
        if (lpd == null || lpd.files == null || lpd.files.isEmpty()) {
            return null;
        }
        int size = lpd.files.size();
        int initRand = random.nextInt(size);
        for (int i = 0; i < lpd.files.size(); ++i) {
            int ri = (initRand + i) % lpd.files.size();
            String structureName = lpd.files.get(ri);
            CapsuleTemplate template = (CapsuleTemplate)StructureSaver.getTemplateForReward(context.func_202879_g().func_73046_m(), this.templatesPath + "/" + structureName).getRight();
            if (template == null) continue;
            return Pair.of((Object)(this.templatesPath + "/" + structureName), (Object)template);
        }
        return null;
    }
}

