/*
 * Decompiled with CFR 0.152.
 */
package capsule.network;

import capsule.client.CapsulePreviewHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CapsuleContentPreviewAnswerToClient {
    protected static final Logger LOGGER = LogManager.getLogger(CapsuleContentPreviewAnswerToClient.class);
    private List<AxisAlignedBB> boundingBoxes = null;
    private String structureName = null;

    public CapsuleContentPreviewAnswerToClient(List<AxisAlignedBB> boundingBoxes, String structureName) {
        this.boundingBoxes = boundingBoxes;
        this.structureName = structureName;
    }

    public void onClient(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Map<String, List<AxisAlignedBB>> map = CapsulePreviewHandler.currentPreview;
            synchronized (map) {
                CapsulePreviewHandler.currentPreview.put(this.getStructureName(), this.getBoundingBoxes());
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public CapsuleContentPreviewAnswerToClient(PacketBuffer buf) {
        try {
            this.structureName = buf.func_150789_c(Short.MAX_VALUE);
            int size = buf.readShort();
            this.boundingBoxes = new ArrayList<AxisAlignedBB>(size);
            for (int i = 0; i < size; ++i) {
                boolean isSingleBlock = buf.readBoolean();
                if (isSingleBlock) {
                    BlockPos p = BlockPos.func_218283_e((long)buf.readLong());
                    this.boundingBoxes.add(new AxisAlignedBB(p, p));
                    continue;
                }
                this.boundingBoxes.add(new AxisAlignedBB(BlockPos.func_218283_e((long)buf.readLong()), BlockPos.func_218283_e((long)buf.readLong())));
            }
        }
        catch (IndexOutOfBoundsException ioe) {
            LOGGER.error("Exception while reading CapsuleContentPreviewMessageToClient: " + ioe);
            return;
        }
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_180714_a(this.structureName);
        int size = Math.min(this.boundingBoxes.size(), Short.MAX_VALUE);
        buf.writeShort(size);
        for (int i = 0; i < size; ++i) {
            AxisAlignedBB bb = this.boundingBoxes.get(i);
            boolean isSingleBlock = bb.func_72320_b() == 0.0;
            buf.writeBoolean(isSingleBlock);
            buf.writeLong(new BlockPos(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c).func_218275_a());
            if (isSingleBlock) continue;
            buf.writeLong(new BlockPos(bb.field_72336_d, bb.field_72337_e, bb.field_72334_f).func_218275_a());
        }
    }

    public String toString() {
        return this.getClass().toString();
    }

    public List<AxisAlignedBB> getBoundingBoxes() {
        return this.boundingBoxes;
    }

    public String getStructureName() {
        return this.structureName;
    }
}

