/*
 * Decompiled with CFR 0.152.
 */
package capsule.network;

import capsule.StructureSaver;
import capsule.helpers.Spacial;
import capsule.items.CapsuleItem;
import capsule.network.CapsuleContentPreviewAnswerToClient;
import capsule.network.CapsuleNetwork;
import capsule.structure.CapsuleTemplate;
import capsule.structure.CapsuleTemplateManager;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CapsuleContentPreviewQueryToServer {
    protected static final Logger LOGGER = LogManager.getLogger(CapsuleContentPreviewQueryToServer.class);
    private String structureName = null;

    public CapsuleContentPreviewQueryToServer(String structureName) {
        this.setStructureName(structureName);
    }

    public CapsuleContentPreviewQueryToServer(PacketBuffer buf) {
        try {
            this.setStructureName(buf.func_150789_c(Short.MAX_VALUE));
        }
        catch (IndexOutOfBoundsException ioe) {
            LOGGER.error("Exception while reading AskCapsuleContentPreviewMessageToServer: " + ioe);
            return;
        }
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_180714_a(this.getStructureName());
    }

    public void onServer(Supplier<NetworkEvent.Context> ctx) {
        ServerPlayerEntity sendingPlayer = ctx.get().getSender();
        if (sendingPlayer == null) {
            LOGGER.error("ServerPlayerEntity was null when AskCapsuleContentPreviewMessageToServer was received");
            return;
        }
        ctx.get().enqueueWork(() -> {
            ItemStack heldItem = sendingPlayer.func_184614_ca();
            if (!(heldItem.func_77973_b() instanceof CapsuleItem) || CapsuleItem.getStructureName(heldItem) == null) {
                return;
            }
            ServerWorld serverworld = sendingPlayer.func_71121_q();
            Pair<CapsuleTemplateManager, CapsuleTemplate> templatepair = StructureSaver.getTemplate(heldItem, serverworld);
            CapsuleTemplate template = (CapsuleTemplate)templatepair.getRight();
            if (template != null) {
                List<AxisAlignedBB> blockspos = Spacial.mergeVoxels(template.getBlocks());
                CapsuleNetwork.wrapper.reply((Object)new CapsuleContentPreviewAnswerToClient(blockspos, this.getStructureName()), (NetworkEvent.Context)ctx.get());
            } else if (heldItem.func_77942_o()) {
                String structureName = heldItem.func_77978_p().func_74779_i("structureName");
                sendingPlayer.func_145747_a((ITextComponent)new TranslationTextComponent("capsule.error.templateNotFound", new Object[]{structureName}));
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public String toString() {
        return this.getClass().toString();
    }

    public String getStructureName() {
        return this.structureName;
    }

    public void setStructureName(String structureName) {
        this.structureName = structureName;
    }
}

