/*
 * Decompiled with CFR 0.152.
 */
package capsule.network;

import capsule.StructureSaver;
import capsule.helpers.Capsule;
import capsule.items.CapsuleItem;
import capsule.network.CapsuleContentPreviewQueryToServer;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CapsuleLeftClickQueryToServer {
    protected static final Logger LOGGER = LogManager.getLogger(CapsuleContentPreviewQueryToServer.class);

    public CapsuleLeftClickQueryToServer() {
    }

    public CapsuleLeftClickQueryToServer(PacketBuffer buf) {
    }

    public void onServer(Supplier<NetworkEvent.Context> ctx) {
        ServerPlayerEntity sendingPlayer = ctx.get().getSender();
        if (sendingPlayer == null) {
            LOGGER.error("ServerPlayerEntity was null when " + this.getClass().getName() + " was received");
            return;
        }
        ctx.get().enqueueWork(() -> {
            ItemStack stack = sendingPlayer.func_184614_ca();
            if (stack.func_77973_b() instanceof CapsuleItem && CapsuleItem.isBlueprint(stack) && CapsuleItem.hasState(stack, CapsuleItem.CapsuleState.DEPLOYED)) {
                Map<StructureSaver.ItemStackKey, Integer> missing = Capsule.reloadBlueprint(stack, sendingPlayer.func_71121_q(), (PlayerEntity)sendingPlayer);
                if (missing != null && missing.size() > 0) {
                    StringTextComponent message = new StringTextComponent("Missing :");
                    for (Map.Entry<StructureSaver.ItemStackKey, Integer> entry : missing.entrySet()) {
                        message.func_150258_a("\n* " + entry.getValue() + " ");
                        message.func_150257_a(entry.getKey().itemStack.func_77973_b().func_200295_i(entry.getKey().itemStack));
                    }
                    sendingPlayer.func_145747_a((ITextComponent)message);
                }
            } else if (stack.func_77973_b() instanceof CapsuleItem && CapsuleItem.canRotate(stack)) {
                PlacementSettings placement = CapsuleItem.getPlacement(stack);
                if (sendingPlayer.func_225608_bj_()) {
                    switch (placement.func_186212_b()) {
                        case FRONT_BACK: {
                            placement.func_186214_a(Mirror.LEFT_RIGHT);
                            break;
                        }
                        case LEFT_RIGHT: {
                            placement.func_186214_a(Mirror.NONE);
                            break;
                        }
                        case NONE: {
                            placement.func_186214_a(Mirror.FRONT_BACK);
                        }
                    }
                    sendingPlayer.func_145747_a((ITextComponent)new TranslationTextComponent("[ ]: " + Capsule.getMirrorLabel(placement), new Object[0]));
                } else {
                    placement.func_186220_a(placement.func_186215_c().func_185830_a(Rotation.CLOCKWISE_90));
                    sendingPlayer.func_145747_a((ITextComponent)new TranslationTextComponent("\u27f3: " + Capsule.getRotationLabel(placement), new Object[0]));
                }
                CapsuleItem.setPlacement(stack, placement);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public void toBytes(PacketBuffer buf) {
    }

    public String toString() {
        return this.getClass().toString();
    }
}

