/*
 * Decompiled with CFR 0.152.
 */
package capsule.network;

import capsule.helpers.Capsule;
import capsule.items.CapsuleItem;
import capsule.network.CapsuleNetwork;
import capsule.network.CapsuleUndeployNotifToClient;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CapsuleThrowQueryToServer {
    protected static final Logger LOGGER = LogManager.getLogger(CapsuleThrowQueryToServer.class);
    public BlockPos pos = null;
    public boolean instant = false;

    public CapsuleThrowQueryToServer(BlockPos pos, boolean instant) {
        this.pos = pos;
        this.instant = instant;
    }

    public void onServer(Supplier<NetworkEvent.Context> ctx) {
        ServerPlayerEntity sendingPlayer = ctx.get().getSender();
        if (sendingPlayer == null) {
            LOGGER.error("ServerPlayerEntity was null when " + this.getClass().getName() + " was received");
            return;
        }
        ItemStack heldItem = sendingPlayer.func_184614_ca();
        ServerWorld world = sendingPlayer.func_71121_q();
        ctx.get().enqueueWork(() -> {
            if (heldItem.func_77973_b() instanceof CapsuleItem) {
                if (this.instant && this.pos != null) {
                    int size = CapsuleItem.getSize(heldItem);
                    int extendLength = (size - 1) / 2;
                    if (CapsuleItem.hasState(heldItem, CapsuleItem.CapsuleState.EMPTY)) {
                        boolean captured = Capsule.captureAtPosition(heldItem, sendingPlayer.func_110124_au(), size, sendingPlayer.func_71121_q(), this.pos);
                        if (captured) {
                            BlockPos center = this.pos.func_177982_a(0, size / 2, 0);
                            CapsuleNetwork.wrapper.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint((double)center.func_177958_n(), (double)center.func_177956_o(), (double)center.func_177952_p(), (double)(200 + size), sendingPlayer.field_71093_bK)), (Object)new CapsuleUndeployNotifToClient(center, sendingPlayer.func_180425_c(), size));
                        }
                    } else {
                        boolean deployed = Capsule.deployCapsule(heldItem, this.pos.func_177982_a(0, -1, 0), sendingPlayer.func_110124_au(), extendLength, world);
                        if (deployed) {
                            world.func_184133_a(null, this.pos, SoundEvents.field_187596_cD, SoundCategory.BLOCKS, 0.4f, 0.1f);
                            Capsule.showDeployParticules(world, this.pos, size);
                        }
                        if (deployed && CapsuleItem.isOneUse(heldItem)) {
                            heldItem.func_190918_g(1);
                        }
                    }
                }
                if (!this.instant) {
                    Capsule.throwCapsule(heldItem, (PlayerEntity)sendingPlayer, this.pos);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public CapsuleThrowQueryToServer(PacketBuffer buf) {
        try {
            this.instant = buf.readBoolean();
            boolean hasPos = buf.readBoolean();
            if (hasPos) {
                this.pos = BlockPos.func_218283_e((long)buf.readLong());
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void toBytes(PacketBuffer buf) {
        buf.writeBoolean(this.instant);
        boolean hasPos = this.pos != null;
        buf.writeBoolean(hasPos);
        if (hasPos) {
            buf.writeLong(this.pos.func_218275_a());
        }
    }

    public String toString() {
        return this.getClass().toString();
    }
}

