/*
 * Decompiled with CFR 0.152.
 */
package capsule.network;

import capsule.helpers.Capsule;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CapsuleUndeployNotifToClient {
    protected static final Logger LOGGER = LogManager.getLogger(CapsuleUndeployNotifToClient.class);
    public BlockPos posFrom = null;
    public BlockPos posTo = null;
    public int size = 0;

    public CapsuleUndeployNotifToClient(BlockPos posFrom, BlockPos posTo, int size) {
        this.posFrom = posFrom;
        this.posTo = posTo;
        this.size = size;
    }

    public void onClient(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> Capsule.showUndeployParticules(Minecraft.func_71410_x().field_71441_e, this.posFrom, this.posTo, this.size));
        ctx.get().setPacketHandled(true);
    }

    public CapsuleUndeployNotifToClient(PacketBuffer buf) {
        try {
            this.posFrom = buf.func_179259_c();
            this.posTo = buf.func_179259_c();
            this.size = buf.readShort();
        }
        catch (IndexOutOfBoundsException ioe) {
            LOGGER.error("Exception while reading CapsuleUndeployNotifToClient: " + ioe);
        }
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_179255_a(this.posFrom);
        buf.func_179255_a(this.posTo);
        buf.writeShort(this.size);
    }

    public String toString() {
        return this.getClass().toString();
    }
}

