/*
 * Decompiled with CFR 0.152.
 */
package capsule.network;

import capsule.items.CapsuleItem;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LabelEditedMessageToServer {
    protected static final Logger LOGGER = LogManager.getLogger(LabelEditedMessageToServer.class);
    private String label;

    public LabelEditedMessageToServer(String newLabel) {
        this.setLabel(newLabel);
    }

    public LabelEditedMessageToServer(PacketBuffer buf) {
        try {
            this.setLabel(buf.func_150789_c(Short.MAX_VALUE));
        }
        catch (IndexOutOfBoundsException ioe) {
            LOGGER.error("Exception while reading CapsuleLabelEditedMessageToClient: " + ioe);
        }
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_180714_a(this.label);
    }

    public void onServer(Supplier<NetworkEvent.Context> ctx) {
        ServerPlayerEntity sendingPlayer = ctx.get().getSender();
        if (sendingPlayer == null) {
            LOGGER.error("ServerPlayerEntity was null when LabelEditedMessageToServer was received");
            return;
        }
        ctx.get().enqueueWork(() -> {
            ItemStack serverStack = sendingPlayer.func_184614_ca();
            if (serverStack.func_77973_b() instanceof CapsuleItem) {
                CapsuleItem.setLabel(serverStack, this.getLabel());
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public String toString() {
        return this.getClass().toString() + "[label=" + this.getLabel() + "]";
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }
}

