/*
 * Decompiled with CFR 0.152.
 */
package capsule.plugins.jei;

import capsule.Config;
import capsule.blocks.CapsuleBlocks;
import capsule.items.CapsuleItem;
import capsule.items.CapsuleItems;
import capsule.recipes.RecoveryCapsuleRecipe;
import capsule.recipes.UpgradeCapsuleRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;

@JeiPlugin
public class CapsulePlugin
implements IModPlugin {
    public void registerItemSubtypes(ISubtypeRegistration subtypeRegistry) {
        subtypeRegistry.registerSubtypeInterpreter((Item)CapsuleItems.CAPSULE, (ISubtypeInterpreter)new CapsuleSubtypeInterpreter());
    }

    public void registerRecipes(@Nonnull IRecipeRegistration registry) {
        ArrayList<Object> recipes = new ArrayList<Object>();
        Ingredient upgradeIngredient = ((UpgradeCapsuleRecipe)CapsuleItems.upgradedCapsule.getValue()).upgradeIngredient;
        for (ItemStack capsule : CapsuleItems.capsuleList.keySet()) {
            for (int upLevel = 1; upLevel < Math.min(8, Config.upgradeLimit); ++upLevel) {
                ItemStack capsuleUp = CapsuleItems.getUpgradedCapsule(capsule, upLevel);
                NonNullList ingredients = NonNullList.func_191197_a((int)(upLevel + 1), (Object)upgradeIngredient);
                ingredients.set(0, (Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{capsule}));
                recipes.add(new ShapelessRecipe(new ResourceLocation("capsule", "capsule"), "capsule", capsuleUp, ingredients));
            }
            recipes.add(new ShapelessRecipe(new ResourceLocation("capsule", "capsule"), "capsule", capsule, NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{CapsuleItems.getUnlabelledCapsule(capsule)})})));
        }
        ItemStack recoveryCapsule = (ItemStack)CapsuleItems.recoveryCapsule.getKey();
        ItemStack unlabelled = (ItemStack)CapsuleItems.unlabelledCapsule.getKey();
        ItemStack unlabelledDeployed = (ItemStack)CapsuleItems.deployedCapsule.getKey();
        CapsuleItem.setState(unlabelledDeployed, CapsuleItem.CapsuleState.DEPLOYED);
        Ingredient anyBlueprint = Ingredient.func_193369_a((ItemStack[])((ItemStack[])CapsuleItems.blueprintCapsules.stream().map(Pair::getKey).toArray(ItemStack[]::new)));
        Ingredient unlabelledIng = Ingredient.merge(Arrays.asList(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{unlabelled}), anyBlueprint, Ingredient.func_193369_a((ItemStack[])new ItemStack[]{recoveryCapsule})));
        recipes.add(((RecoveryCapsuleRecipe)CapsuleItems.recoveryCapsule.getValue()).recipe);
        for (Pair<ItemStack, ICraftingRecipe> pair : CapsuleItems.blueprintCapsules) {
            recipes.add(pair.getValue());
        }
        for (Pair<ItemStack, ICraftingRecipe> pair : CapsuleItems.blueprintPrefabs) {
            recipes.add(pair.getValue());
        }
        ItemStack withNewTemplate = (ItemStack)CapsuleItems.blueprintChangedCapsule.getKey();
        CapsuleItem.setStructureName(withNewTemplate, "newTemplate");
        CapsuleItem.setLabel(withNewTemplate, "Changed Template");
        recipes.add(new ShapelessRecipe(new ResourceLocation("capsule", "capsule"), "capsule", withNewTemplate, NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{anyBlueprint, unlabelledIng})));
        registry.addRecipes(recipes, VanillaRecipeCategoryUid.CRAFTING);
        registry.addIngredientInfo(new ArrayList<ItemStack>(CapsuleItems.capsuleList.keySet()), VanillaTypes.ITEM, new String[]{"jei.capsule.desc.capsule"});
        registry.addIngredientInfo(CapsuleItems.blueprintChangedCapsule.getKey(), VanillaTypes.ITEM, new String[]{"jei.capsule.desc.blueprintCapsule"});
        registry.addIngredientInfo(CapsuleItems.unlabelledCapsule.getKey(), VanillaTypes.ITEM, new String[]{"jei.capsule.desc.linkedCapsule"});
        registry.addIngredientInfo(CapsuleItems.deployedCapsule.getKey(), VanillaTypes.ITEM, new String[]{"jei.capsule.desc.linkedCapsule"});
        registry.addIngredientInfo(CapsuleItems.recoveryCapsule.getKey(), VanillaTypes.ITEM, new String[]{"jei.capsule.desc.recoveryCapsule"});
        for (Pair<ItemStack, ICraftingRecipe> pair : CapsuleItems.blueprintCapsules) {
            registry.addIngredientInfo(pair.getKey(), VanillaTypes.ITEM, new String[]{"jei.capsule.desc.blueprintCapsule"});
        }
        for (Pair<ItemStack, ICraftingRecipe> pair : CapsuleItems.blueprintPrefabs) {
            registry.addIngredientInfo(pair.getKey(), VanillaTypes.ITEM, new String[]{"jei.capsule.desc.blueprintCapsule"});
        }
        ItemStack itemStack = CapsuleItems.withState(CapsuleItem.CapsuleState.EMPTY);
        itemStack.func_77983_a("overpowered", (INBT)ByteNBT.func_229672_a_((boolean)true));
        registry.addIngredientInfo((Object)itemStack, VanillaTypes.ITEM, new String[]{"jei.capsule.desc.opCapsule"});
        registry.addIngredientInfo((Object)new ItemStack((IItemProvider)CapsuleBlocks.CAPSULE_MARKER), VanillaTypes.ITEM, new String[]{"jei.capsule.desc.capsuleMarker"});
    }

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("capsule", "main");
    }

    private static class CapsuleSubtypeInterpreter
    implements ISubtypeInterpreter {
        private CapsuleSubtypeInterpreter() {
        }

        public String apply(ItemStack itemStack) {
            if (!(itemStack.func_77973_b() instanceof CapsuleItem)) {
                return null;
            }
            String isOP = String.valueOf(itemStack.func_196082_o().func_74767_n("overpowered"));
            String capsuleState = String.valueOf((Object)CapsuleItem.getState(itemStack));
            String capsuleColor = String.valueOf(CapsuleItem.getMaterialColor(itemStack));
            String capsuleBlueprint = String.valueOf(CapsuleItem.isBlueprint(itemStack));
            String label = CapsuleItem.getLabel(itemStack);
            return capsuleState + capsuleColor + isOP + capsuleBlueprint + label;
        }
    }
}

