/*
 * Decompiled with CFR 0.152.
 */
package capsule.recipes;

import capsule.helpers.Capsule;
import capsule.items.CapsuleItem;
import capsule.recipes.CapsuleRecipes;
import com.google.gson.JsonObject;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class BlueprintCapsuleRecipe
implements ICraftingRecipe {
    public final ShapedRecipe recipe;

    public BlueprintCapsuleRecipe(ShapedRecipe recipe) {
        this.recipe = recipe;
    }

    public ItemStack func_77571_b() {
        return this.recipe.func_77571_b();
    }

    public NonNullList<Ingredient> func_192400_c() {
        NonNullList ingredients = this.recipe.func_192400_c();
        return ingredients;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        NonNullList nonnulllist = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack itemstack = inv.func_70301_a(i);
            nonnulllist.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)itemstack));
            if (!(itemstack.func_77973_b() instanceof CapsuleItem)) continue;
            nonnulllist.set(i, (Object)itemstack.func_77946_l());
        }
        return nonnulllist;
    }

    private boolean IsCopyable(ItemStack itemstack) {
        return CapsuleItem.isLinkedStateCapsule(itemstack) || CapsuleItem.isBlueprint(itemstack) || CapsuleItem.isOneUse(itemstack);
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        if (!this.recipe.func_77569_a(inv, worldIn)) {
            return false;
        }
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack itemstack = inv.func_70301_a(i);
            if (!(itemstack.func_77973_b() instanceof CapsuleItem) || this.IsCopyable(itemstack)) continue;
            return false;
        }
        return true;
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        ItemStack referenceCapsule = this.recipe.func_77571_b();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack itemstack = inv.func_70301_a(i);
            if (!this.IsCopyable(itemstack)) continue;
            referenceCapsule = itemstack;
        }
        try {
            ItemStack blueprintItem = Capsule.newLinkedCapsuleItemStack(CapsuleItem.getStructureName(referenceCapsule), CapsuleItem.getBaseColor(this.recipe.func_77571_b()), 0xFFFFFF, CapsuleItem.getSize(referenceCapsule), CapsuleItem.isOverpowered(referenceCapsule), referenceCapsule.func_77978_p() != null ? referenceCapsule.func_77978_p().func_74779_i("label") : null, 0);
            CapsuleItem.setBlueprint(blueprintItem);
            if (blueprintItem.func_77978_p() != null) {
                blueprintItem.func_77978_p().func_74757_a("templateShouldBeCopied", true);
            }
            CapsuleItem.setState(blueprintItem, CapsuleItem.CapsuleState.DEPLOYED);
            return blueprintItem;
        }
        catch (Exception e) {
            e.printStackTrace();
            return ItemStack.field_190927_a;
        }
    }

    public boolean func_194133_a(int width, int height) {
        return this.recipe.func_194133_a(width, height);
    }

    public ResourceLocation func_199560_c() {
        return this.recipe.func_199560_c();
    }

    public IRecipeSerializer<?> func_199559_b() {
        return CapsuleRecipes.BLUEPRINT_CAPSULE_SERIALIZER;
    }

    public boolean func_192399_d() {
        return true;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<BlueprintCapsuleRecipe> {
        public BlueprintCapsuleRecipe read(ResourceLocation recipeId, JsonObject json) {
            return new BlueprintCapsuleRecipe((ShapedRecipe)ShapedRecipe.Serializer.field_222157_a.func_199425_a_(recipeId, json));
        }

        public BlueprintCapsuleRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            return new BlueprintCapsuleRecipe((ShapedRecipe)ShapedRecipe.Serializer.field_222157_a.func_199426_a_(recipeId, buffer));
        }

        public void write(PacketBuffer buffer, BlueprintCapsuleRecipe recipe) {
            ShapedRecipe.Serializer.field_222157_a.func_199427_a_(buffer, (IRecipe)recipe.recipe);
        }
    }
}

