/*
 * Decompiled with CFR 0.152.
 */
package capsule.recipes;

import capsule.items.CapsuleItem;
import capsule.items.CapsuleItems;
import capsule.recipes.CapsuleRecipes;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class BlueprintChangeRecipe
extends SpecialRecipe {
    public BlueprintChangeRecipe(ResourceLocation id) {
        super(id);
    }

    public ItemStack func_77571_b() {
        ItemStack bp = new ItemStack((IItemProvider)CapsuleItems.CAPSULE, 1);
        CapsuleItem.setState(bp, CapsuleItem.CapsuleState.DEPLOYED);
        CapsuleItem.setBlueprint(bp);
        CapsuleItem.setBaseColor(bp, 3949738);
        CapsuleItem.setStructureName(bp, "config/capsule/rewards/example");
        return bp;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return CapsuleRecipes.BLUEPRINT_CHANGE_SERIALIZER;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        NonNullList nonnulllist = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStack blueprintCapsule = null;
        ItemStack templateCapsule = null;
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack itemstack = inv.func_70301_a(i);
            if (blueprintCapsule == null && CapsuleItem.isBlueprint(itemstack)) {
                blueprintCapsule = itemstack;
                continue;
            }
            if (!CapsuleItem.hasStructureLink(itemstack)) continue;
            templateCapsule = itemstack;
            nonnulllist.set(i, (Object)templateCapsule.func_77946_l());
        }
        return nonnulllist;
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        int sourceCapsule = 0;
        int blueprint = 0;
        NonNullList nonnulllist = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack itemstack = inv.func_70301_a(i);
            if (blueprint == 0 && CapsuleItem.isBlueprint(itemstack)) {
                ++blueprint;
                continue;
            }
            if (CapsuleItem.hasStructureLink(itemstack) && (CapsuleItem.CapsuleState.DEPLOYED != CapsuleItem.getState(itemstack) || CapsuleItem.isBlueprint(itemstack))) {
                ++sourceCapsule;
                continue;
            }
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return sourceCapsule == 1 && blueprint == 1;
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        String templateStructure = null;
        Integer templateSize = null;
        ItemStack blueprintCapsule = null;
        NonNullList nonnulllist = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack itemstack = inv.func_70301_a(i);
            if (blueprintCapsule == null && CapsuleItem.isBlueprint(itemstack)) {
                blueprintCapsule = itemstack.func_77946_l();
                continue;
            }
            if (!CapsuleItem.hasStructureLink(itemstack)) continue;
            templateStructure = CapsuleItem.getStructureName(itemstack);
            templateSize = CapsuleItem.getSize(itemstack);
        }
        if (templateStructure != null && blueprintCapsule != null) {
            if (blueprintCapsule.func_77978_p() != null) {
                blueprintCapsule.func_77978_p().func_74778_a("prevStructureName", CapsuleItem.getStructureName(blueprintCapsule));
            }
            CapsuleItem.setStructureName(blueprintCapsule, templateStructure);
            CapsuleItem.setState(blueprintCapsule, CapsuleItem.CapsuleState.DEPLOYED);
            CapsuleItem.setSize(blueprintCapsule, templateSize);
            CapsuleItem.cleanDeploymentTags(blueprintCapsule);
            return blueprintCapsule;
        }
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }
}

