/*
 * Decompiled with CFR 0.152.
 */
package capsule.recipes;

import capsule.items.CapsuleItem;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;

public class CapsuleIngredient
extends Ingredient {
    private final ItemStack referenceStack;

    protected CapsuleIngredient(ItemStack stack) {
        super(Stream.of(new Ingredient.SingleItemList(stack)));
        this.referenceStack = stack;
    }

    public boolean test(@Nullable ItemStack input) {
        if (input == null || !(input.func_77973_b() instanceof CapsuleItem)) {
            return false;
        }
        return this.referenceStack.func_77973_b() == input.func_77973_b() && CapsuleItem.hasState(input, CapsuleItem.getState(this.referenceStack)) && CapsuleItem.isBlueprint(input) == CapsuleItem.isBlueprint(this.referenceStack);
    }

    public boolean isSimple() {
        return false;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public JsonElement func_200304_c() {
        JsonObject json = new JsonObject();
        json.addProperty("type", CraftingHelper.getID((IIngredientSerializer)Serializer.INSTANCE).toString());
        json.addProperty("item", this.referenceStack.func_77973_b().getRegistryName().toString());
        json.addProperty("count", (Number)this.referenceStack.func_190916_E());
        if (this.referenceStack.func_77942_o()) {
            json.addProperty("nbt", this.referenceStack.func_77978_p().toString());
        }
        return json;
    }

    public static class Serializer
    implements IIngredientSerializer<CapsuleIngredient> {
        public static final Serializer INSTANCE = new Serializer();

        public CapsuleIngredient parse(PacketBuffer buffer) {
            return new CapsuleIngredient(buffer.func_150791_c());
        }

        public CapsuleIngredient parse(JsonObject json) {
            return new CapsuleIngredient(CraftingHelper.getItemStack((JsonObject)json, (boolean)true));
        }

        public void write(PacketBuffer buffer, CapsuleIngredient ingredient) {
            buffer.func_150788_a(ingredient.referenceStack);
        }
    }
}

