/*
 * Decompiled with CFR 0.152.
 */
package capsule.recipes;

import capsule.items.CapsuleItem;
import capsule.items.CapsuleItems;
import capsule.recipes.CapsuleRecipes;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class ClearCapsuleRecipe
extends SpecialRecipe {
    public ClearCapsuleRecipe(ResourceLocation idIn) {
        super(idIn);
    }

    public IRecipeSerializer<?> func_199559_b() {
        return CapsuleRecipes.CLEAR_CAPSULE_SERIALIZER;
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        int sourceCapsule = 0;
        NonNullList nonnulllist = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack itemstack = inv.func_70301_a(i);
            if (this.canBeEmptyCapsule(itemstack)) {
                ++sourceCapsule;
                continue;
            }
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return sourceCapsule == 1;
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        NonNullList nonnulllist = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack itemstack = inv.func_70301_a(i);
            if (!this.canBeEmptyCapsule(itemstack)) continue;
            ItemStack copy = itemstack.func_77946_l();
            CapsuleItem.clearCapsule(copy);
            return copy;
        }
        return ItemStack.field_190927_a;
    }

    public boolean canBeEmptyCapsule(ItemStack itemstack) {
        if (!(itemstack.func_77973_b() instanceof CapsuleItem)) {
            return false;
        }
        return CapsuleItem.isLinkedStateCapsule(itemstack) || CapsuleItem.hasState(itemstack, CapsuleItem.CapsuleState.DEPLOYED) && !CapsuleItem.isBlueprint(itemstack);
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 1;
    }

    public ItemStack func_77571_b() {
        return CapsuleItems.withState(CapsuleItem.CapsuleState.EMPTY);
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        NonNullList nonnulllist = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack itemstack = inv.func_70301_a(i);
            nonnulllist.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)itemstack));
            if (!(itemstack.func_77973_b() instanceof CapsuleItem) || CapsuleItem.hasState(itemstack, CapsuleItem.CapsuleState.DEPLOYED)) continue;
            ItemStack copy = itemstack.func_77946_l();
            CapsuleItem.setOneUse(copy);
            nonnulllist.set(i, (Object)copy);
        }
        return nonnulllist;
    }
}

