/*
 * Decompiled with CFR 0.152.
 */
package capsule.recipes;

import capsule.Config;
import capsule.StructureSaver;
import capsule.helpers.Blueprint;
import capsule.items.CapsuleItem;
import capsule.items.CapsuleItems;
import capsule.recipes.CapsuleRecipes;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.util.TriConsumer;

public class PrefabsBlueprintAggregatorRecipe
extends SpecialRecipe {
    public static PrefabsBlueprintAggregatorRecipe instance;
    public List<PrefabsBlueprintCapsuleRecipe> recipes = new ArrayList<PrefabsBlueprintCapsuleRecipe>();

    public PrefabsBlueprintAggregatorRecipe(ResourceLocation idIn) {
        super(idIn);
        instance = this;
    }

    public void populateRecipes(MinecraftServer server) {
        if (server == null) {
            return;
        }
        List<String> prefabsTemplatesList = Config.prefabsTemplatesList;
        this.recipes.clear();
        Blueprint.createDynamicPrefabRecipes(server, prefabsTemplatesList, (TriConsumer<ResourceLocation, JsonObject, Triple<StructureSaver.ItemStackKey, StructureSaver.ItemStackKey, StructureSaver.ItemStackKey>>)((TriConsumer)(id, recipe, ingredients) -> this.recipes.add(new PrefabsBlueprintCapsuleRecipe((ResourceLocation)id, (JsonObject)recipe, (Triple<StructureSaver.ItemStackKey, StructureSaver.ItemStackKey, StructureSaver.ItemStackKey>)ingredients))));
    }

    public IRecipeSerializer<?> func_199559_b() {
        return CapsuleRecipes.PREFABS_AGGREGATOR_SERIALIZER;
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        return this.recipes.stream().anyMatch(r -> r.matches(inv));
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        Optional<PrefabsBlueprintCapsuleRecipe> recipe = this.recipes.stream().filter(r -> r.matches(inv)).findFirst();
        if (recipe.isPresent()) {
            return recipe.get().getCraftingResult(inv);
        }
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    public ItemStack func_77571_b() {
        return CapsuleItems.withState(CapsuleItem.CapsuleState.BLUEPRINT);
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        Optional<PrefabsBlueprintCapsuleRecipe> recipe = this.recipes.stream().filter(r -> r.matches(inv)).findFirst();
        if (recipe.isPresent()) {
            return recipe.get().getRemainingItems(inv);
        }
        return NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<PrefabsBlueprintAggregatorRecipe> {
        public PrefabsBlueprintAggregatorRecipe read(ResourceLocation recipeId, JsonObject json) {
            return instance != null ? instance : new PrefabsBlueprintAggregatorRecipe(recipeId);
        }

        public PrefabsBlueprintAggregatorRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            if (instance == null) {
                instance = new PrefabsBlueprintAggregatorRecipe(recipeId);
            }
            PrefabsBlueprintAggregatorRecipe.instance.recipes.clear();
            IRecipeSerializer serializer = ShapedRecipe.Serializer.field_222157_a;
            int size = buffer.readInt();
            for (int i = 0; i < size; ++i) {
                ResourceLocation id = new ResourceLocation(buffer.func_218666_n());
                ShapedRecipe recipe = (ShapedRecipe)serializer.func_199426_a_(id, buffer);
                PrefabsBlueprintAggregatorRecipe.instance.recipes.add(new PrefabsBlueprintCapsuleRecipe(id, recipe));
            }
            return instance;
        }

        public void write(PacketBuffer buffer, PrefabsBlueprintAggregatorRecipe recipe) {
            IRecipeSerializer serializer = ShapedRecipe.Serializer.field_222157_a;
            buffer.writeInt(recipe.recipes.size());
            for (PrefabsBlueprintCapsuleRecipe subRecipe : recipe.recipes) {
                buffer.func_180714_a(subRecipe.id.toString());
                serializer.func_199427_a_(buffer, (IRecipe)subRecipe.recipe);
            }
        }
    }

    public static class PrefabsBlueprintCapsuleRecipe
    implements ICraftingRecipe {
        private final ResourceLocation id;
        public final ShapedRecipe recipe;
        private int ingredientOneIndex = 4;
        private int ingredientTwoIndex = 0;
        private int ingredientThreeIndex = 2;

        public PrefabsBlueprintCapsuleRecipe(ResourceLocation id, JsonObject template, Triple<StructureSaver.ItemStackKey, StructureSaver.ItemStackKey, StructureSaver.ItemStackKey> ingredients) {
            this.id = id;
            this.recipe = (ShapedRecipe)ShapedRecipe.Serializer.field_222157_a.func_199425_a_(id, template);
            this.buildRecipeFromPattern(template, ingredients);
        }

        public PrefabsBlueprintCapsuleRecipe(ResourceLocation id, ShapedRecipe serializedRecipe) {
            this.id = id;
            this.recipe = serializedRecipe;
        }

        public void buildRecipeFromPattern(JsonObject template, Triple<StructureSaver.ItemStackKey, StructureSaver.ItemStackKey, StructureSaver.ItemStackKey> ingredients) {
            JsonArray patternArr = JSONUtils.func_151214_t((JsonObject)template, (String)"pattern");
            String pattern = patternArr.get(0).getAsString() + patternArr.get(1).getAsString() + patternArr.get(2).getAsString();
            this.ingredientOneIndex = pattern.indexOf("1");
            this.ingredientTwoIndex = pattern.indexOf("2");
            this.ingredientThreeIndex = pattern.indexOf("3");
            this.recipe.func_192400_c().set(this.ingredientOneIndex, (Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{((StructureSaver.ItemStackKey)ingredients.getLeft()).itemStack}));
            if (ingredients.getMiddle() != null) {
                this.recipe.func_192400_c().set(this.ingredientTwoIndex, (Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{((StructureSaver.ItemStackKey)ingredients.getMiddle()).itemStack}));
            }
            if (ingredients.getRight() != null) {
                this.recipe.func_192400_c().set(this.ingredientThreeIndex, (Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{((StructureSaver.ItemStackKey)ingredients.getRight()).itemStack}));
            }
        }

        public ItemStack func_77571_b() {
            return this.recipe.func_77571_b();
        }

        public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
            NonNullList nonnulllist = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
            for (int i = 0; i < nonnulllist.size(); ++i) {
                ItemStack itemstack = inv.func_70301_a(i);
                nonnulllist.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)itemstack));
                if (itemstack.func_77973_b() instanceof CapsuleItem) {
                    nonnulllist.set(i, (Object)itemstack.func_77946_l());
                    continue;
                }
                if (i != this.ingredientOneIndex && i != this.ingredientTwoIndex && i != this.ingredientThreeIndex) continue;
                ItemStack refund = itemstack.func_77946_l();
                refund.func_190920_e(1);
                nonnulllist.set(i, (Object)refund);
            }
            return nonnulllist;
        }

        public ResourceLocation func_199560_c() {
            return this.id;
        }

        public IRecipeSerializer<?> func_199559_b() {
            return ShapedRecipe.Serializer.field_222157_a;
        }

        public boolean matches(CraftingInventory inv) {
            for (int i = 0; i <= inv.func_174922_i() - this.recipe.func_192403_f(); ++i) {
                for (int j = 0; j <= inv.func_174923_h() - this.recipe.func_192404_g(); ++j) {
                    if (this.checkMatch(inv, i, j, true)) {
                        return true;
                    }
                    if (!this.checkMatch(inv, i, j, false)) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean matches(CraftingInventory inv, World worldIn) {
            return this.matches(inv);
        }

        private boolean checkMatch(CraftingInventory craftingInventory, int p_77573_2_, int p_77573_3_, boolean p_77573_4_) {
            for (int i = 0; i < craftingInventory.func_174922_i(); ++i) {
                for (int j = 0; j < craftingInventory.func_174923_h(); ++j) {
                    int k = i - p_77573_2_;
                    int l = j - p_77573_3_;
                    Ingredient ingredient = Ingredient.field_193370_a;
                    if (k >= 0 && l >= 0 && k < this.recipe.func_192403_f() && l < this.recipe.func_192404_g()) {
                        ingredient = p_77573_4_ ? (Ingredient)this.recipe.func_192400_c().get(this.recipe.func_192403_f() - k - 1 + l * this.recipe.func_192403_f()) : (Ingredient)this.recipe.func_192400_c().get(k + l * this.recipe.func_192403_f());
                    }
                    if (ingredient.test(craftingInventory.func_70301_a(i + j * craftingInventory.func_174922_i()))) continue;
                    return false;
                }
            }
            return true;
        }

        public ItemStack getCraftingResult(CraftingInventory invC) {
            return this.recipe.func_77572_b(invC);
        }

        public boolean func_194133_a(int width, int height) {
            return this.recipe.func_194133_a(width, height);
        }
    }
}

