/*
 * Decompiled with CFR 0.152.
 */
package capsule.recipes;

import capsule.items.CapsuleItem;
import capsule.recipes.CapsuleRecipes;
import com.google.gson.JsonObject;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class RecoveryCapsuleRecipe
implements ICraftingRecipe {
    public final ShapelessRecipe recipe;

    public RecoveryCapsuleRecipe(ShapelessRecipe recipe) {
        this.recipe = recipe;
    }

    public ItemStack func_77571_b() {
        return this.recipe.func_77571_b();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        NonNullList nonnulllist = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack itemstack = inv.func_70301_a(i);
            nonnulllist.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)itemstack));
            if (!(itemstack.func_77973_b() instanceof CapsuleItem)) continue;
            nonnulllist.set(i, (Object)itemstack.func_77946_l());
        }
        return nonnulllist;
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        return this.recipe.func_77569_a(inv, worldIn);
    }

    public ItemStack getCraftingResult(CraftingInventory invC) {
        for (int i = 0; i < invC.func_70302_i_(); ++i) {
            ItemStack itemstack = invC.func_70301_a(i);
            if (!CapsuleItem.isLinkedStateCapsule(itemstack)) continue;
            ItemStack copy = itemstack.func_77946_l();
            CapsuleItem.setOneUse(copy);
            return copy;
        }
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return this.recipe.func_194133_a(width, height);
    }

    public ResourceLocation func_199560_c() {
        return this.recipe.func_199560_c();
    }

    public IRecipeSerializer<?> func_199559_b() {
        return CapsuleRecipes.RECOVERY_CAPSULE_SERIALIZER;
    }

    public boolean func_192399_d() {
        return true;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<RecoveryCapsuleRecipe> {
        public RecoveryCapsuleRecipe read(ResourceLocation recipeId, JsonObject json) {
            return new RecoveryCapsuleRecipe((ShapelessRecipe)ShapelessRecipe.Serializer.field_222158_b.func_199425_a_(recipeId, json));
        }

        public RecoveryCapsuleRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            return new RecoveryCapsuleRecipe((ShapelessRecipe)ShapelessRecipe.Serializer.field_222158_b.func_199426_a_(recipeId, buffer));
        }

        public void write(PacketBuffer buffer, RecoveryCapsuleRecipe recipe) {
            ShapelessRecipe.Serializer.field_222158_b.func_199427_a_(buffer, (IRecipe)recipe.recipe);
        }
    }
}

