/*
 * Decompiled with CFR 0.152.
 */
package capsule.recipes;

import capsule.Config;
import capsule.items.CapsuleItem;
import capsule.items.CapsuleItems;
import capsule.recipes.CapsuleRecipes;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class UpgradeCapsuleRecipe
implements ICraftingRecipe {
    public final Ingredient upgradeIngredient;
    private final ResourceLocation recipeId;

    public UpgradeCapsuleRecipe(ResourceLocation recipeId, Ingredient upgradeIngredient) {
        this.upgradeIngredient = upgradeIngredient;
        this.recipeId = recipeId;
    }

    public ItemStack func_77571_b() {
        return CapsuleItems.getUpgradedCapsule(CapsuleItems.withState(CapsuleItem.CapsuleState.EMPTY), 1);
    }

    public boolean matches(CraftingInventory invC, World worldIn) {
        ItemStack sourceCapsule = ItemStack.field_190927_a;
        int material = 0;
        for (int i = 0; i < invC.func_70302_i_(); ++i) {
            ItemStack itemstack = invC.func_70301_a(i);
            if (!itemstack.func_190926_b() && itemstack.func_77973_b() instanceof CapsuleItem && CapsuleItem.hasState(itemstack, CapsuleItem.CapsuleState.EMPTY) && CapsuleItem.getUpgradeLevel(itemstack) < Config.upgradeLimit) {
                sourceCapsule = itemstack;
                continue;
            }
            if (this.upgradeIngredient.test(itemstack)) {
                ++material;
                continue;
            }
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return sourceCapsule != ItemStack.field_190927_a && material > 0 && CapsuleItem.getUpgradeLevel(sourceCapsule) + material <= Config.upgradeLimit;
    }

    public ItemStack getCraftingResult(CraftingInventory invC) {
        ItemStack input = ItemStack.field_190927_a;
        int material = 0;
        for (int i = 0; i < invC.func_70302_i_(); ++i) {
            ItemStack itemstack = invC.func_70301_a(i);
            if (!itemstack.func_190926_b() && itemstack.func_77973_b() instanceof CapsuleItem && CapsuleItem.hasState(itemstack, CapsuleItem.CapsuleState.EMPTY) && CapsuleItem.getUpgradeLevel(itemstack) < Config.upgradeLimit) {
                input = itemstack;
                continue;
            }
            if (this.upgradeIngredient.test(itemstack)) {
                ++material;
                continue;
            }
            if (itemstack.func_190926_b()) continue;
            return ItemStack.field_190927_a;
        }
        if (input == ItemStack.field_190927_a) {
            return ItemStack.field_190927_a;
        }
        ItemStack copy = input.func_77946_l();
        int newSize = CapsuleItem.getSize(input) + material * 2;
        int newUpgraded = CapsuleItem.getUpgradeLevel(input) + material;
        if (newSize > 255) {
            newSize = 255;
        }
        if (newUpgraded > Config.upgradeLimit) {
            newUpgraded = Config.upgradeLimit;
        }
        CapsuleItem.setSize(copy, newSize);
        CapsuleItem.setUpgradeLevel(copy, newUpgraded);
        return copy;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return CapsuleRecipes.UPGRADE_CAPSULE_SERIALIZER;
    }

    public boolean func_192399_d() {
        return true;
    }

    public ResourceLocation func_199560_c() {
        return this.recipeId;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<UpgradeCapsuleRecipe> {
        private static NonNullList<Ingredient> readIngredients(JsonArray p_199568_0_) {
            NonNullList nonnulllist = NonNullList.func_191196_a();
            for (int i = 0; i < p_199568_0_.size(); ++i) {
                Ingredient ingredient = Ingredient.func_199802_a((JsonElement)p_199568_0_.get(i));
                if (ingredient.func_203189_d()) continue;
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        public UpgradeCapsuleRecipe read(ResourceLocation recipeId, JsonObject json) {
            NonNullList<Ingredient> nonnulllist = Serializer.readIngredients(JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients"));
            if (nonnulllist.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            return new UpgradeCapsuleRecipe(recipeId, (Ingredient)nonnulllist.get(0));
        }

        public UpgradeCapsuleRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            return new UpgradeCapsuleRecipe(recipeId, Ingredient.func_199566_b((PacketBuffer)buffer));
        }

        public void write(PacketBuffer buffer, UpgradeCapsuleRecipe recipe) {
            recipe.upgradeIngredient.func_199564_a(buffer);
        }
    }
}

