/*
 * Decompiled with CFR 0.152.
 */
package capsule.structure;

import capsule.Config;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.PaintingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.inventory.IClearable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.ObjectIntIdentityMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.VoxelShapePart;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CapsuleTemplate {
    protected static final Logger LOGGER = LogManager.getLogger(CapsuleTemplate.class);
    public final List<List<Template.BlockInfo>> blocks = Lists.newArrayList();
    public final List<Template.EntityInfo> entities = Lists.newArrayList();
    public Map<BlockPos, Block> occupiedPositions = null;
    public BlockPos size = BlockPos.field_177992_a;
    private String author = "?";

    public final List<Template.BlockInfo> getBlocks() {
        if (this.blocks.size() <= 0) {
            return Lists.newArrayList();
        }
        return this.blocks.get(0);
    }

    public BlockPos getSize() {
        return this.size;
    }

    public void setAuthor(String authorIn) {
        this.author = authorIn;
    }

    public String getAuthor() {
        return this.author;
    }

    public void takeBlocksFromWorld(World worldIn, BlockPos startPos, BlockPos size, boolean takeEntities, @Nullable Block toIgnore) {
        if (size.func_177958_n() >= 1 && size.func_177956_o() >= 1 && size.func_177952_p() >= 1) {
            BlockPos blockpos = startPos.func_177971_a((Vec3i)size).func_177982_a(-1, -1, -1);
            ArrayList list = Lists.newArrayList();
            ArrayList list1 = Lists.newArrayList();
            ArrayList list2 = Lists.newArrayList();
            BlockPos blockpos1 = new BlockPos(Math.min(startPos.func_177958_n(), blockpos.func_177958_n()), Math.min(startPos.func_177956_o(), blockpos.func_177956_o()), Math.min(startPos.func_177952_p(), blockpos.func_177952_p()));
            BlockPos blockpos2 = new BlockPos(Math.max(startPos.func_177958_n(), blockpos.func_177958_n()), Math.max(startPos.func_177956_o(), blockpos.func_177956_o()), Math.max(startPos.func_177952_p(), blockpos.func_177952_p()));
            this.size = size;
            for (BlockPos blockpos3 : BlockPos.func_218278_a((BlockPos)blockpos1, (BlockPos)blockpos2)) {
                BlockPos blockpos4 = blockpos3.func_177973_b((Vec3i)blockpos1);
                BlockState blockstate = worldIn.func_180495_p(blockpos3);
                if (toIgnore != null && toIgnore == blockstate.func_177230_c()) continue;
                TileEntity tileentity = worldIn.func_175625_s(blockpos3);
                if (tileentity != null) {
                    CompoundNBT compoundnbt = tileentity.func_189515_b(new CompoundNBT());
                    compoundnbt.func_82580_o("x");
                    compoundnbt.func_82580_o("y");
                    compoundnbt.func_82580_o("z");
                    list1.add(new Template.BlockInfo(blockpos4, blockstate, compoundnbt));
                    continue;
                }
                if (!blockstate.func_200015_d((IBlockReader)worldIn, blockpos3) && !blockstate.func_224756_o((IBlockReader)worldIn, blockpos3)) {
                    list2.add(new Template.BlockInfo(blockpos4, blockstate, null));
                    continue;
                }
                list.add(new Template.BlockInfo(blockpos4, blockstate, null));
            }
            ArrayList list3 = Lists.newArrayList();
            list3.addAll(list);
            list3.addAll(list1);
            list3.addAll(list2);
            this.blocks.clear();
            this.blocks.add(list3);
            if (takeEntities) {
                this.takeEntitiesFromWorld(worldIn, blockpos1, blockpos2.func_177982_a(1, 1, 1));
            } else {
                this.entities.clear();
            }
        }
    }

    private void takeEntitiesFromWorld(World worldIn, BlockPos startPos, BlockPos endPos) {
        List list = worldIn.func_175647_a(Entity.class, new AxisAlignedBB(startPos, endPos), p_201048_0_ -> !(p_201048_0_ instanceof PlayerEntity));
        this.entities.clear();
        for (Entity entity : list) {
            Vec3d vec3d = new Vec3d(entity.func_226277_ct_() - (double)startPos.func_177958_n(), entity.func_226278_cu_() - (double)startPos.func_177956_o(), entity.func_226281_cx_() - (double)startPos.func_177952_p());
            CompoundNBT compoundnbt = new CompoundNBT();
            entity.func_70039_c(compoundnbt);
            BlockPos blockpos = entity instanceof PaintingEntity ? ((PaintingEntity)entity).func_174857_n().func_177973_b((Vec3i)startPos) : new BlockPos(vec3d);
            this.entities.add(new Template.EntityInfo(vec3d, blockpos, compoundnbt));
        }
    }

    public List<Template.BlockInfo> func_215381_a(BlockPos p_215381_1_, PlacementSettings p_215381_2_, Block p_215381_3_) {
        return this.func_215386_a(p_215381_1_, p_215381_2_, p_215381_3_, true);
    }

    public List<Template.BlockInfo> func_215386_a(BlockPos p_215386_1_, PlacementSettings p_215386_2_, Block p_215386_3_, boolean p_215386_4_) {
        ArrayList list = Lists.newArrayList();
        MutableBoundingBox mutableboundingbox = p_215386_2_.func_186213_g();
        for (Template.BlockInfo template$blockinfo : p_215386_2_.func_227459_a_(this.blocks, p_215386_1_)) {
            BlockState blockstate;
            BlockPos blockpos;
            BlockPos blockPos = blockpos = p_215386_4_ ? CapsuleTemplate.transformedBlockPos(p_215386_2_, template$blockinfo.field_186242_a).func_177971_a((Vec3i)p_215386_1_) : template$blockinfo.field_186242_a;
            if (mutableboundingbox != null && !mutableboundingbox.func_175898_b((Vec3i)blockpos) || (blockstate = template$blockinfo.field_186243_b).func_177230_c() != p_215386_3_) continue;
            list.add(new Template.BlockInfo(blockpos, blockstate.func_185907_a(p_215386_2_.func_186215_c()), template$blockinfo.field_186244_c));
        }
        return list;
    }

    public BlockPos calculateConnectedPos(PlacementSettings placementIn, BlockPos p_186262_2_, PlacementSettings p_186262_3_, BlockPos p_186262_4_) {
        BlockPos blockpos = CapsuleTemplate.transformedBlockPos(placementIn, p_186262_2_);
        BlockPos blockpos1 = CapsuleTemplate.transformedBlockPos(p_186262_3_, p_186262_4_);
        return blockpos.func_177973_b((Vec3i)blockpos1);
    }

    public static BlockPos transformedBlockPos(PlacementSettings placementIn, BlockPos pos) {
        return CapsuleTemplate.getTransformedPos(pos, placementIn.func_186212_b(), placementIn.func_186215_c(), placementIn.func_207664_d());
    }

    public static Vec3d transformedVec3d(PlacementSettings placementIn, Vec3d pos) {
        return CapsuleTemplate.getTransformedPos(pos, placementIn.func_186212_b(), placementIn.func_186215_c(), placementIn.func_207664_d());
    }

    public static void func_222857_a(IWorld worldIn, int p_222857_1_, VoxelShapePart voxelShapePartIn, int xIn, int yIn, int zIn) {
        voxelShapePartIn.func_211540_a((p_222856_5_, p_222856_6_, p_222856_7_, p_222856_8_) -> {
            BlockState blockstate3;
            BlockState blockstate1;
            BlockState blockstate2;
            BlockPos blockpos = new BlockPos(xIn + p_222856_6_, yIn + p_222856_7_, zIn + p_222856_8_);
            BlockPos blockpos1 = blockpos.func_177972_a(p_222856_5_);
            BlockState blockstate = worldIn.func_180495_p(blockpos);
            if (blockstate != (blockstate2 = blockstate.func_196956_a(p_222856_5_, blockstate1 = worldIn.func_180495_p(blockpos1), worldIn, blockpos, blockpos1))) {
                worldIn.func_180501_a(blockpos, blockstate2, p_222857_1_ & 0xFFFFFFFE | 0x10);
            }
            if (blockstate1 != (blockstate3 = blockstate1.func_196956_a(p_222856_5_.func_176734_d(), blockstate2, worldIn, blockpos1, blockpos))) {
                worldIn.func_180501_a(blockpos1, blockstate3, p_222857_1_ & 0xFFFFFFFE | 0x10);
            }
        });
    }

    @Deprecated
    public static List<Template.BlockInfo> processBlockInfos(IWorld worldIn, BlockPos offsetPos, PlacementSettings placementSettingsIn, List<Template.BlockInfo> blockInfos) {
        return CapsuleTemplate.processBlockInfos(null, worldIn, offsetPos, placementSettingsIn, blockInfos);
    }

    public static List<Template.BlockInfo> processBlockInfos(@Nullable CapsuleTemplate template, IWorld worldIn, BlockPos offsetPos, PlacementSettings placementSettingsIn, List<Template.BlockInfo> blockInfos) {
        ArrayList list = Lists.newArrayList();
        for (Template.BlockInfo template$blockinfo : blockInfos) {
            BlockPos blockpos = CapsuleTemplate.transformedBlockPos(placementSettingsIn, template$blockinfo.field_186242_a).func_177971_a((Vec3i)offsetPos);
            Template.BlockInfo template$blockinfo1 = new Template.BlockInfo(blockpos, template$blockinfo.field_186243_b, template$blockinfo.field_186244_c);
            list.add(template$blockinfo1);
        }
        return list;
    }

    public static List<Template.EntityInfo> processEntityInfos(@Nullable CapsuleTemplate template, IWorld worldIn, BlockPos offsetPos, PlacementSettings placementSettingsIn, List<Template.EntityInfo> blockInfos) {
        ArrayList list = Lists.newArrayList();
        for (Template.EntityInfo entityInfo : blockInfos) {
            Vec3d pos = CapsuleTemplate.transformedVec3d(placementSettingsIn, entityInfo.field_186247_a).func_178787_e(new Vec3d((Vec3i)offsetPos));
            BlockPos blockpos = CapsuleTemplate.transformedBlockPos(placementSettingsIn, entityInfo.field_186248_b).func_177971_a((Vec3i)offsetPos);
            Template.EntityInfo info = new Template.EntityInfo(pos, blockpos, entityInfo.field_186249_c);
            list.add(info);
        }
        return list;
    }

    private void addEntitiesToWorld(IWorld worldIn, BlockPos offsetPos, PlacementSettings placementIn, Mirror mirrorIn, Rotation rotationIn, BlockPos centerOffset, @Nullable MutableBoundingBox boundsIn, List<Entity> spawnedEntities) {
        for (Template.EntityInfo template$entityinfo : CapsuleTemplate.processEntityInfos(this, worldIn, offsetPos, placementIn, this.entities)) {
            BlockPos blockpos = CapsuleTemplate.getTransformedPos(template$entityinfo.field_186248_b, mirrorIn, rotationIn, centerOffset).func_177971_a((Vec3i)offsetPos);
            blockpos = template$entityinfo.field_186248_b;
            if (boundsIn != null && !boundsIn.func_175898_b((Vec3i)blockpos)) continue;
            CompoundNBT compoundnbt = template$entityinfo.field_186249_c;
            Vec3d vec3d = CapsuleTemplate.getTransformedPos(template$entityinfo.field_186247_a, mirrorIn, rotationIn, centerOffset);
            vec3d = vec3d.func_72441_c((double)offsetPos.func_177958_n(), (double)offsetPos.func_177956_o(), (double)offsetPos.func_177952_p());
            Vec3d vec3d1 = template$entityinfo.field_186247_a;
            ListNBT listnbt = new ListNBT();
            listnbt.add((Object)DoubleNBT.func_229684_a_((double)vec3d1.field_72450_a));
            listnbt.add((Object)DoubleNBT.func_229684_a_((double)vec3d1.field_72448_b));
            listnbt.add((Object)DoubleNBT.func_229684_a_((double)vec3d1.field_72449_c));
            compoundnbt.func_218657_a("Pos", (INBT)listnbt);
            compoundnbt.func_82580_o("UUIDMost");
            compoundnbt.func_82580_o("UUIDLeast");
            CapsuleTemplate.loadEntity(worldIn, compoundnbt).ifPresent(p_215383_4_ -> {
                float f = p_215383_4_.func_184217_a(mirrorIn);
                p_215383_4_.func_70012_b(vec3d1.field_72450_a, vec3d1.field_72448_b, vec3d1.field_72449_c, f += p_215383_4_.field_70177_z - p_215383_4_.func_184229_a(rotationIn), p_215383_4_.field_70125_A);
                worldIn.func_217376_c(p_215383_4_);
                if (spawnedEntities != null) {
                    spawnedEntities.add((Entity)p_215383_4_);
                }
            });
        }
    }

    private static Optional<Entity> loadEntity(IWorld worldIn, CompoundNBT nbt) {
        try {
            return EntityType.func_220330_a((CompoundNBT)nbt, (World)worldIn.func_201672_e());
        }
        catch (Exception var3) {
            return Optional.empty();
        }
    }

    public BlockPos transformedSize(Rotation rotationIn) {
        switch (rotationIn) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                return new BlockPos(this.size.func_177952_p(), this.size.func_177956_o(), this.size.func_177958_n());
            }
        }
        return this.size;
    }

    public static BlockPos getTransformedPos(BlockPos targetPos, Mirror mirrorIn, Rotation rotationIn, BlockPos offset) {
        int i = targetPos.func_177958_n();
        int j = targetPos.func_177956_o();
        int k = targetPos.func_177952_p();
        boolean flag = true;
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                k = -k;
                break;
            }
            case FRONT_BACK: {
                i = -i;
                break;
            }
            default: {
                flag = false;
            }
        }
        int l = offset.func_177958_n();
        int i1 = offset.func_177952_p();
        switch (rotationIn) {
            case COUNTERCLOCKWISE_90: {
                return new BlockPos(l - i1 + k, j, l + i1 - i);
            }
            case CLOCKWISE_90: {
                return new BlockPos(l + i1 - k, j, i1 - l + i);
            }
            case CLOCKWISE_180: {
                return new BlockPos(l + l - i, j, i1 + i1 - k);
            }
        }
        return flag ? new BlockPos(i, j, k) : targetPos;
    }

    private static Vec3d getTransformedPos(Vec3d target, Mirror mirrorIn, Rotation rotationIn, BlockPos centerOffset) {
        double d0 = target.field_72450_a;
        double d1 = target.field_72448_b;
        double d2 = target.field_72449_c;
        boolean flag = true;
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                d2 = 1.0 - d2;
                break;
            }
            case FRONT_BACK: {
                d0 = 1.0 - d0;
                break;
            }
            default: {
                flag = false;
            }
        }
        int i = centerOffset.func_177958_n();
        int j = centerOffset.func_177952_p();
        switch (rotationIn) {
            case COUNTERCLOCKWISE_90: {
                return new Vec3d((double)(i - j) + d2, d1, (double)(i + j + 1) - d0);
            }
            case CLOCKWISE_90: {
                return new Vec3d((double)(i + j + 1) - d2, d1, (double)(j - i) + d0);
            }
            case CLOCKWISE_180: {
                return new Vec3d((double)(i + i + 1) - d0, d1, (double)(j + j + 1) - d2);
            }
        }
        return flag ? new Vec3d(d0, d1, d2) : target;
    }

    public BlockPos getZeroPositionWithTransform(BlockPos p_189961_1_, Mirror p_189961_2_, Rotation p_189961_3_) {
        return CapsuleTemplate.getZeroPositionWithTransform(p_189961_1_, p_189961_2_, p_189961_3_, this.getSize().func_177958_n(), this.getSize().func_177952_p());
    }

    public static BlockPos getZeroPositionWithTransform(BlockPos p_191157_0_, Mirror p_191157_1_, Rotation p_191157_2_, int p_191157_3_, int p_191157_4_) {
        int i = p_191157_1_ == Mirror.FRONT_BACK ? --p_191157_3_ : 0;
        int j = p_191157_1_ == Mirror.LEFT_RIGHT ? --p_191157_4_ : 0;
        BlockPos blockpos = p_191157_0_;
        switch (p_191157_2_) {
            case COUNTERCLOCKWISE_90: {
                blockpos = p_191157_0_.func_177982_a(j, 0, p_191157_3_ - i);
                break;
            }
            case CLOCKWISE_90: {
                blockpos = p_191157_0_.func_177982_a(p_191157_4_ - j, 0, i);
                break;
            }
            case CLOCKWISE_180: {
                blockpos = p_191157_0_.func_177982_a(p_191157_3_ - i, 0, p_191157_4_ - j);
                break;
            }
            case NONE: {
                blockpos = p_191157_0_.func_177982_a(i, 0, j);
            }
        }
        return blockpos;
    }

    public MutableBoundingBox getMutableBoundingBox(PlacementSettings p_215388_1_, BlockPos p_215388_2_) {
        Rotation rotation = p_215388_1_.func_186215_c();
        BlockPos blockpos = p_215388_1_.func_207664_d();
        BlockPos blockpos1 = this.transformedSize(rotation);
        Mirror mirror = p_215388_1_.func_186212_b();
        int i = blockpos.func_177958_n();
        int j = blockpos.func_177952_p();
        int k = blockpos1.func_177958_n() - 1;
        int l = blockpos1.func_177956_o() - 1;
        int i1 = blockpos1.func_177952_p() - 1;
        MutableBoundingBox mutableboundingbox = new MutableBoundingBox(0, 0, 0, 0, 0, 0);
        switch (rotation) {
            case COUNTERCLOCKWISE_90: {
                mutableboundingbox = new MutableBoundingBox(i - j, 0, i + j - i1, i - j + k, l, i + j);
                break;
            }
            case CLOCKWISE_90: {
                mutableboundingbox = new MutableBoundingBox(i + j - k, 0, j - i, i + j, l, j - i + i1);
                break;
            }
            case CLOCKWISE_180: {
                mutableboundingbox = new MutableBoundingBox(i + i - k, 0, j + j - i1, i + i, l, j + j);
                break;
            }
            case NONE: {
                mutableboundingbox = new MutableBoundingBox(0, 0, 0, k, l, i1);
            }
        }
        switch (mirror) {
            case LEFT_RIGHT: {
                this.func_215385_a(rotation, i1, k, mutableboundingbox, Direction.NORTH, Direction.SOUTH);
                break;
            }
            case FRONT_BACK: {
                this.func_215385_a(rotation, k, i1, mutableboundingbox, Direction.WEST, Direction.EAST);
            }
        }
        mutableboundingbox.func_78886_a(p_215388_2_.func_177958_n(), p_215388_2_.func_177956_o(), p_215388_2_.func_177952_p());
        return mutableboundingbox;
    }

    private void func_215385_a(Rotation rotationIn, int offsetFront, int p_215385_3_, MutableBoundingBox p_215385_4_, Direction p_215385_5_, Direction p_215385_6_) {
        BlockPos blockpos = BlockPos.field_177992_a;
        blockpos = rotationIn != Rotation.CLOCKWISE_90 && rotationIn != Rotation.COUNTERCLOCKWISE_90 ? (rotationIn == Rotation.CLOCKWISE_180 ? blockpos.func_177967_a(p_215385_6_, offsetFront) : blockpos.func_177967_a(p_215385_5_, offsetFront)) : blockpos.func_177967_a(rotationIn.func_185831_a(p_215385_5_), p_215385_3_);
        p_215385_4_.func_78886_a(blockpos.func_177958_n(), 0, blockpos.func_177952_p());
    }

    public CompoundNBT writeToNBT(CompoundNBT nbt) {
        if (this.blocks.isEmpty()) {
            nbt.func_218657_a("blocks", (INBT)new ListNBT());
            nbt.func_218657_a("palette", (INBT)new ListNBT());
        } else {
            ArrayList list = Lists.newArrayList();
            BasicPalette template$basicpalette = new BasicPalette();
            list.add(template$basicpalette);
            for (int i = 1; i < this.blocks.size(); ++i) {
                list.add(new BasicPalette());
            }
            ListNBT listnbt1 = new ListNBT();
            List<Template.BlockInfo> list1 = this.getBlocks();
            for (int j = 0; j < list1.size(); ++j) {
                Template.BlockInfo template$blockinfo = list1.get(j);
                CompoundNBT compoundnbt = new CompoundNBT();
                compoundnbt.func_218657_a("pos", (INBT)this.writeInts(template$blockinfo.field_186242_a.func_177958_n(), template$blockinfo.field_186242_a.func_177956_o(), template$blockinfo.field_186242_a.func_177952_p()));
                int k = template$basicpalette.idFor(template$blockinfo.field_186243_b);
                compoundnbt.func_74768_a("state", k);
                if (template$blockinfo.field_186244_c != null) {
                    compoundnbt.func_218657_a("nbt", (INBT)template$blockinfo.field_186244_c);
                }
                listnbt1.add((Object)compoundnbt);
                for (int l = 1; l < this.blocks.size(); ++l) {
                    BasicPalette template$basicpalette1 = (BasicPalette)list.get(l);
                    template$basicpalette1.addMapping(this.blocks.get((int)l).get((int)j).field_186243_b, k);
                }
            }
            nbt.func_218657_a("blocks", (INBT)listnbt1);
            if (list.size() == 1) {
                ListNBT listnbt2 = new ListNBT();
                Iterator<Object> iterator = template$basicpalette.iterator();
                while (iterator.hasNext()) {
                    BlockState blockstate = (BlockState)iterator.next();
                    listnbt2.add((Object)NBTUtil.func_190009_a((BlockState)blockstate));
                }
                nbt.func_218657_a("palette", (INBT)listnbt2);
            } else {
                ListNBT listnbt3 = new ListNBT();
                for (BasicPalette template$basicpalette2 : list) {
                    ListNBT listnbt4 = new ListNBT();
                    for (BlockState blockstate1 : template$basicpalette2) {
                        listnbt4.add((Object)NBTUtil.func_190009_a((BlockState)blockstate1));
                    }
                    listnbt3.add((Object)listnbt4);
                }
                nbt.func_218657_a("palettes", (INBT)listnbt3);
            }
        }
        ListNBT listnbt = new ListNBT();
        for (Template.EntityInfo template$entityinfo : this.entities) {
            CompoundNBT compoundnbt1 = new CompoundNBT();
            compoundnbt1.func_218657_a("pos", (INBT)this.writeDoubles(template$entityinfo.field_186247_a.field_72450_a, template$entityinfo.field_186247_a.field_72448_b, template$entityinfo.field_186247_a.field_72449_c));
            compoundnbt1.func_218657_a("blockPos", (INBT)this.writeInts(template$entityinfo.field_186248_b.func_177958_n(), template$entityinfo.field_186248_b.func_177956_o(), template$entityinfo.field_186248_b.func_177952_p()));
            if (template$entityinfo.field_186249_c != null) {
                compoundnbt1.func_218657_a("nbt", (INBT)template$entityinfo.field_186249_c);
            }
            listnbt.add((Object)compoundnbt1);
        }
        nbt.func_218657_a("entities", (INBT)listnbt);
        nbt.func_218657_a("size", (INBT)this.writeInts(this.size.func_177958_n(), this.size.func_177956_o(), this.size.func_177952_p()));
        nbt.func_74768_a("DataVersion", SharedConstants.func_215069_a().getWorldVersion());
        ListNBT occupiedSpawnPositionstaglist = new ListNBT();
        if (this.occupiedPositions != null) {
            for (Map.Entry<BlockPos, Block> entry : this.occupiedPositions.entrySet()) {
                CompoundNBT nbtEntry = new CompoundNBT();
                nbtEntry.func_74772_a("pos", entry.getKey().func_218275_a());
                nbtEntry.func_74768_a("blockId", Block.func_196246_j((BlockState)entry.getValue().func_176223_P()));
                occupiedSpawnPositionstaglist.add((Object)nbtEntry);
            }
            nbt.func_218657_a("capsule_occupiedSources", (INBT)occupiedSpawnPositionstaglist);
        }
        return nbt;
    }

    public void read(CompoundNBT compound) {
        this.blocks.clear();
        this.entities.clear();
        ListNBT listnbt = compound.func_150295_c("size", 3);
        this.size = new BlockPos(listnbt.func_186858_c(0), listnbt.func_186858_c(1), listnbt.func_186858_c(2));
        ListNBT listnbt1 = compound.func_150295_c("blocks", 10);
        if (compound.func_150297_b("palettes", 9)) {
            ListNBT listnbt2 = compound.func_150295_c("palettes", 9);
            for (int i = 0; i < listnbt2.size(); ++i) {
                this.readPalletesAndBlocks(listnbt2.func_202169_e(i), listnbt1);
            }
        } else {
            this.readPalletesAndBlocks(compound.func_150295_c("palette", 10), listnbt1);
        }
        ListNBT listnbt5 = compound.func_150295_c("entities", 10);
        for (int j = 0; j < listnbt5.size(); ++j) {
            CompoundNBT compoundnbt = listnbt5.func_150305_b(j);
            ListNBT listnbt3 = compoundnbt.func_150295_c("pos", 6);
            Vec3d vec3d = new Vec3d(listnbt3.func_150309_d(0), listnbt3.func_150309_d(1), listnbt3.func_150309_d(2));
            ListNBT listnbt4 = compoundnbt.func_150295_c("blockPos", 3);
            BlockPos blockpos = new BlockPos(listnbt4.func_186858_c(0), listnbt4.func_186858_c(1), listnbt4.func_186858_c(2));
            if (!compoundnbt.func_74764_b("nbt")) continue;
            CompoundNBT compoundnbt1 = compoundnbt.func_74775_l("nbt");
            this.entities.add(new Template.EntityInfo(vec3d, blockpos, compoundnbt1));
        }
        if (compound.func_74764_b("capsule_occupiedSources")) {
            HashMap<BlockPos, Block> occupiedSources = new HashMap<BlockPos, Block>();
            ListNBT list = compound.func_150295_c("capsule_occupiedSources", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundNBT entry = list.func_150305_b(i);
                occupiedSources.put(BlockPos.func_218283_e((long)entry.func_74763_f("pos")), Block.func_196257_b((int)entry.func_74762_e("blockId")).func_177230_c());
            }
            this.occupiedPositions = occupiedSources;
        }
    }

    private void readPalletesAndBlocks(ListNBT palletesNBT, ListNBT blocksNBT) {
        BasicPalette template$basicpalette = new BasicPalette();
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < palletesNBT.size(); ++i) {
            template$basicpalette.addMapping(NBTUtil.func_190008_d((CompoundNBT)palletesNBT.func_150305_b(i)), i);
        }
        for (int j = 0; j < blocksNBT.size(); ++j) {
            CompoundNBT compoundnbt = blocksNBT.func_150305_b(j);
            ListNBT listnbt = compoundnbt.func_150295_c("pos", 3);
            BlockPos blockpos = new BlockPos(listnbt.func_186858_c(0), listnbt.func_186858_c(1), listnbt.func_186858_c(2));
            BlockState blockstate = template$basicpalette.stateFor(compoundnbt.func_74762_e("state"));
            CompoundNBT compoundnbt1 = compoundnbt.func_74764_b("nbt") ? compoundnbt.func_74775_l("nbt") : null;
            list.add(new Template.BlockInfo(blockpos, blockstate, compoundnbt1));
        }
        list.sort(Comparator.comparingInt(p_215384_0_ -> p_215384_0_.field_186242_a.func_177956_o()));
        this.blocks.add(list);
    }

    private ListNBT writeInts(int ... values) {
        ListNBT listnbt = new ListNBT();
        for (int i : values) {
            listnbt.add((Object)IntNBT.func_229692_a_((int)i));
        }
        return listnbt;
    }

    private ListNBT writeDoubles(double ... values) {
        ListNBT listnbt = new ListNBT();
        for (double d0 : values) {
            listnbt.add((Object)DoubleNBT.func_229684_a_((double)d0));
        }
        return listnbt;
    }

    public void filterFromWhitelist(HashMap<String, JsonObject> blueprintWhitelist, List<String> outExcluded) {
        List newBlockList = this.getBlocks().stream().filter(b -> {
            boolean included;
            ResourceLocation registryName = b.field_186243_b.func_177230_c().getRegistryName();
            boolean bl = included = b.field_186244_c == null || registryName != null && Config.blueprintWhitelist.containsKey(registryName.toString());
            if (!included && outExcluded != null) {
                outExcluded.add(b.field_186243_b.toString());
            }
            return included;
        }).map(b -> {
            if (b.field_186244_c == null) {
                return b;
            }
            CompoundNBT nbt = null;
            JsonObject allowedNBT = Config.getBlueprintAllowedNBT(b.field_186243_b.func_177230_c());
            if (allowedNBT != null) {
                nbt = b.field_186244_c.func_74737_b();
                nbt.func_150296_c().removeIf(key -> !allowedNBT.has(key));
            } else {
                nbt = new CompoundNBT();
            }
            return new Template.BlockInfo(b.field_186242_a, b.field_186243_b, nbt);
        }).collect(Collectors.toList());
        this.getBlocks().clear();
        this.getBlocks().addAll(newBlockList);
        this.entities.clear();
    }

    public void removeOccupiedPositions() {
        this.occupiedPositions = null;
    }

    public void saveOccupiedPositions(Map<BlockPos, Block> occupiedPositions) {
        this.occupiedPositions = occupiedPositions;
    }

    public List<BlockPos> snapshotBlocksFromWorld(World worldIn, BlockPos startPos, BlockPos endPos, Map<BlockPos, Block> occupiedPositionsToIgnore, List<Block> excluded, List<Entity> outCapturedEntities) {
        ArrayList<BlockPos> transferedBlocks = new ArrayList<BlockPos>();
        if (endPos.func_177958_n() >= 1 && endPos.func_177956_o() >= 1 && endPos.func_177952_p() >= 1) {
            BlockPos blockpos = startPos.func_177971_a((Vec3i)endPos).func_177982_a(-1, -1, -1);
            ArrayList list = Lists.newArrayList();
            ArrayList list1 = Lists.newArrayList();
            ArrayList list2 = Lists.newArrayList();
            BlockPos blockpos1 = new BlockPos(Math.min(startPos.func_177958_n(), blockpos.func_177958_n()), Math.min(startPos.func_177956_o(), blockpos.func_177956_o()), Math.min(startPos.func_177952_p(), blockpos.func_177952_p()));
            BlockPos blockpos2 = new BlockPos(Math.max(startPos.func_177958_n(), blockpos.func_177958_n()), Math.max(startPos.func_177956_o(), blockpos.func_177956_o()), Math.max(startPos.func_177952_p(), blockpos.func_177952_p()));
            this.size = endPos;
            for (BlockPos blockpos3 : BlockPos.func_218278_a((BlockPos)blockpos1, (BlockPos)blockpos2)) {
                BlockPos blockpos4 = blockpos3.func_177973_b((Vec3i)blockpos1);
                BlockState blockstate = worldIn.func_180495_p(blockpos3);
                if (excluded.contains(blockstate.func_177230_c()) || occupiedPositionsToIgnore != null && occupiedPositionsToIgnore.containsKey(blockpos3) && occupiedPositionsToIgnore.get(blockpos3).equals(blockstate.func_177230_c())) continue;
                TileEntity tileentity = worldIn.func_175625_s(blockpos3);
                if (tileentity != null) {
                    CompoundNBT compoundnbt = tileentity.func_189515_b(new CompoundNBT());
                    compoundnbt.func_82580_o("x");
                    compoundnbt.func_82580_o("y");
                    compoundnbt.func_82580_o("z");
                    list1.add(new Template.BlockInfo(blockpos4, blockstate, compoundnbt));
                } else if (!blockstate.func_200015_d((IBlockReader)worldIn, blockpos3) && !blockstate.func_224756_o((IBlockReader)worldIn, blockpos3)) {
                    list2.add(new Template.BlockInfo(blockpos4, blockstate, null));
                } else {
                    list.add(new Template.BlockInfo(blockpos4, blockstate, null));
                }
                transferedBlocks.add(new BlockPos(blockpos3.func_177958_n(), blockpos3.func_177956_o(), blockpos3.func_177952_p()));
            }
            ArrayList list3 = Lists.newArrayList();
            list3.addAll(list);
            list3.addAll(list1);
            list3.addAll(list2);
            this.blocks.clear();
            this.blocks.add(list3);
            List<Entity> capturedEntities = this.snapshotNonLivingEntitiesFromWorld(worldIn, blockpos1, blockpos2.func_177982_a(1, 1, 1));
            if (outCapturedEntities != null && capturedEntities != null) {
                outCapturedEntities.addAll(capturedEntities);
            }
        }
        return transferedBlocks;
    }

    public List<Entity> snapshotNonLivingEntitiesFromWorld(World worldIn, BlockPos startPos, BlockPos endPos) {
        List list = worldIn.func_175647_a(Entity.class, new AxisAlignedBB(startPos, endPos), entity -> !(entity instanceof ItemEntity) && (!(entity instanceof LivingEntity) || entity instanceof ArmorStandEntity));
        this.entities.clear();
        for (Entity entity2 : list) {
            Vec3d vec3d = new Vec3d(entity2.func_226277_ct_() - (double)startPos.func_177958_n(), entity2.func_226278_cu_() - (double)startPos.func_177956_o(), entity2.func_226281_cx_() - (double)startPos.func_177952_p());
            CompoundNBT compoundnbt = new CompoundNBT();
            entity2.func_70039_c(compoundnbt);
            BlockPos blockpos = entity2 instanceof PaintingEntity ? ((PaintingEntity)entity2).func_174857_n().func_177973_b((Vec3i)startPos) : new BlockPos(vec3d);
            this.entities.add(new Template.EntityInfo(vec3d, blockpos, compoundnbt));
        }
        return list;
    }

    public static AxisAlignedBB transformedAxisAlignedBB(PlacementSettings placementIn, AxisAlignedBB bb) {
        return new AxisAlignedBB(CapsuleTemplate.transformedBlockPos(placementIn, new BlockPos(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c)), CapsuleTemplate.transformedBlockPos(placementIn, new BlockPos(bb.field_72336_d, bb.field_72337_e, bb.field_72334_f)));
    }

    public boolean spawnBlocksAndEntities(World worldIn, BlockPos pos, PlacementSettings placementIn, Map<BlockPos, Block> occupiedPositions, List<Block> overridableBlocks, List<BlockPos> outSpawnedBlocks, List<Entity> outSpawnedEntities) {
        int flags = 2;
        if (this.blocks.isEmpty()) {
            return false;
        }
        List list = placementIn.func_227459_a_(this.blocks, pos);
        if (!(list.isEmpty() && (placementIn.func_186221_e() || this.entities.isEmpty()) || this.size.func_177958_n() < 1 || this.size.func_177956_o() < 1 || this.size.func_177952_p() < 1)) {
            MutableBoundingBox mutableboundingbox = placementIn.func_186213_g();
            ArrayList list1 = Lists.newArrayListWithCapacity((int)(placementIn.func_204763_l() ? list.size() : 0));
            ArrayList list2 = Lists.newArrayListWithCapacity((int)list.size());
            int i = Integer.MAX_VALUE;
            int j = Integer.MAX_VALUE;
            int k = Integer.MAX_VALUE;
            int l = Integer.MIN_VALUE;
            int i1 = Integer.MIN_VALUE;
            int j1 = Integer.MIN_VALUE;
            for (Template.BlockInfo template$blockinfo : CapsuleTemplate.processBlockInfos(this, (IWorld)worldIn, pos, placementIn, list)) {
                TileEntity tileentity1;
                BlockPos blockpos = template$blockinfo.field_186242_a.func_177971_a((Vec3i)CapsuleTemplate.recenterRotation((this.size.func_177958_n() - 1) / 2, placementIn));
                if (mutableboundingbox != null && !mutableboundingbox.func_175898_b((Vec3i)blockpos) || occupiedPositions.containsKey(blockpos) && !overridableBlocks.contains(occupiedPositions.get(blockpos))) continue;
                if (outSpawnedBlocks != null) {
                    outSpawnedBlocks.add(blockpos);
                }
                IFluidState ifluidstate = placementIn.func_204763_l() ? worldIn.func_204610_c(blockpos) : null;
                BlockState blockstate = template$blockinfo.field_186243_b.func_185902_a(placementIn.func_186212_b()).func_185907_a(placementIn.func_186215_c());
                if (template$blockinfo.field_186244_c != null) {
                    TileEntity tileentity = worldIn.func_175625_s(blockpos);
                    IClearable.func_213131_a((Object)tileentity);
                    worldIn.func_180501_a(blockpos, Blocks.field_180401_cv.func_176223_P(), 20);
                }
                if (!worldIn.func_180501_a(blockpos, blockstate, flags)) continue;
                i = Math.min(i, blockpos.func_177958_n());
                j = Math.min(j, blockpos.func_177956_o());
                k = Math.min(k, blockpos.func_177952_p());
                l = Math.max(l, blockpos.func_177958_n());
                i1 = Math.max(i1, blockpos.func_177956_o());
                j1 = Math.max(j1, blockpos.func_177952_p());
                list2.add(Pair.of((Object)blockpos, (Object)template$blockinfo.field_186244_c));
                if (template$blockinfo.field_186244_c != null && (tileentity1 = worldIn.func_175625_s(blockpos)) != null) {
                    template$blockinfo.field_186244_c.func_74768_a("x", blockpos.func_177958_n());
                    template$blockinfo.field_186244_c.func_74768_a("y", blockpos.func_177956_o());
                    template$blockinfo.field_186244_c.func_74768_a("z", blockpos.func_177952_p());
                    tileentity1.func_145839_a(template$blockinfo.field_186244_c);
                    tileentity1.func_189668_a(placementIn.func_186212_b());
                    tileentity1.func_189667_a(placementIn.func_186215_c());
                }
                if (ifluidstate == null || !(blockstate.func_177230_c() instanceof ILiquidContainer)) continue;
                ((ILiquidContainer)blockstate.func_177230_c()).func_204509_a((IWorld)worldIn, blockpos, blockstate, ifluidstate);
                if (ifluidstate.func_206889_d()) continue;
                list1.add(blockpos);
            }
            boolean flag = true;
            Direction[] adirection = new Direction[]{Direction.UP, Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
            while (flag && !list1.isEmpty()) {
                flag = false;
                Iterator iterator = list1.iterator();
                while (iterator.hasNext()) {
                    BlockState blockstate2;
                    Block block;
                    BlockPos blockpos2;
                    BlockPos blockpos3 = blockpos2 = (BlockPos)iterator.next();
                    IFluidState ifluidstate2 = worldIn.func_204610_c(blockpos2);
                    for (int k1 = 0; k1 < adirection.length && !ifluidstate2.func_206889_d(); ++k1) {
                        BlockPos blockpos1 = blockpos3.func_177972_a(adirection[k1]);
                        IFluidState ifluidstate1 = worldIn.func_204610_c(blockpos1);
                        if (!(ifluidstate1.func_215679_a((IBlockReader)worldIn, blockpos1) > ifluidstate2.func_215679_a((IBlockReader)worldIn, blockpos3)) && (!ifluidstate1.func_206889_d() || ifluidstate2.func_206889_d())) continue;
                        ifluidstate2 = ifluidstate1;
                        blockpos3 = blockpos1;
                    }
                    if (!ifluidstate2.func_206889_d() || !((block = (blockstate2 = worldIn.func_180495_p(blockpos2)).func_177230_c()) instanceof ILiquidContainer)) continue;
                    ((ILiquidContainer)block).func_204509_a((IWorld)worldIn, blockpos2, blockstate2, ifluidstate2);
                    flag = true;
                    iterator.remove();
                }
            }
            if (i <= l) {
                for (Pair pair : list2) {
                    TileEntity tileentity2;
                    BlockPos blockpos4 = (BlockPos)pair.getFirst();
                    if (pair.getSecond() == null || (tileentity2 = worldIn.func_175625_s(blockpos4)) == null) continue;
                    tileentity2.func_70296_d();
                }
            }
            if (!placementIn.func_186221_e()) {
                this.addEntitiesToWorld((IWorld)worldIn, pos, placementIn, placementIn.func_186212_b(), placementIn.func_186215_c(), placementIn.func_207664_d(), placementIn.func_186213_g(), outSpawnedEntities);
            }
            return true;
        }
        return false;
    }

    public void removeBlocks(List<BlockPos> couldNotBeRemoved, BlockPos startPos) {
        for (BlockPos blockPos : couldNotBeRemoved) {
            this.getBlocks().removeIf(blockInfo -> blockPos.func_177973_b((Vec3i)startPos).equals((Object)blockInfo.field_186242_a));
        }
    }

    public List<BlockPos> calculateDeployPositions(World world, BlockPos blockPos, PlacementSettings placementSettings) {
        ArrayList<BlockPos> out = new ArrayList<BlockPos>();
        if (this.size == null) {
            return out;
        }
        List list = placementSettings.func_227459_a_(this.blocks, blockPos);
        if (!list.isEmpty() && this.size.func_177958_n() >= 1 && this.size.func_177956_o() >= 1 && this.size.func_177952_p() >= 1) {
            MutableBoundingBox structureboundingbox = placementSettings.func_186213_g();
            for (Template.BlockInfo template$blockinfo : CapsuleTemplate.processBlockInfos(this, (IWorld)world, blockPos, placementSettings, list)) {
                BlockPos blockpos = CapsuleTemplate.transformedBlockPos(placementSettings, template$blockinfo.field_186242_a).func_177971_a((Vec3i)blockPos).func_177971_a((Vec3i)CapsuleTemplate.recenterRotation((this.size.func_177958_n() - 1) / 2, placementSettings));
                if (template$blockinfo.field_186243_b.func_177230_c() == Blocks.field_185779_df || structureboundingbox != null && !structureboundingbox.func_175898_b((Vec3i)blockpos)) continue;
                out.add(blockpos);
            }
        }
        return out;
    }

    public static BlockPos recenterRotation(int extendSize, PlacementSettings placement) {
        return CapsuleTemplate.transformedBlockPos(placement, new BlockPos(-extendSize, 0, -extendSize)).func_177971_a((Vec3i)new BlockPos(extendSize, 0, extendSize));
    }

    public boolean canRotate() {
        try {
            for (Template.BlockInfo block : this.getBlocks()) {
                if (block.field_186244_c == null || Config.blueprintWhitelist.containsKey(block.field_186243_b.func_177230_c().getRegistryName().toString())) continue;
                return false;
            }
        }
        catch (NullPointerException e) {
            return false;
        }
        return true;
    }

    public boolean readSchematic(CompoundNBT nbt) {
        if (!nbt.func_150297_b("Blocks", 7) || !nbt.func_150297_b("Data", 7)) {
            LOGGER.error("Schematic: Missing block data in the schematic");
            return false;
        }
        if (!nbt.func_150297_b("DataVersion", 99)) {
            nbt.func_74768_a("DataVersion", 500);
        }
        this.blocks.clear();
        this.blocks.add(new ArrayList());
        this.entities.clear();
        int width = nbt.func_74765_d("Width");
        int height = nbt.func_74765_d("Height");
        int length = nbt.func_74765_d("Length");
        byte[] blockIdsByte = nbt.func_74770_j("Blocks");
        byte[] metaArr = nbt.func_74770_j("Data");
        int numBlocks = blockIdsByte.length;
        this.author = "?";
        if (numBlocks != width * height * length) {
            LOGGER.error("Schematic: Mismatched block array size compared to the width/height/length, blocks: {}, W x H x L: {} x {} x {}", (Object)numBlocks, (Object)width, (Object)height, (Object)length);
            return false;
        }
        if (numBlocks != metaArr.length) {
            LOGGER.error("Schematic: Mismatched block ID and metadata array sizes, blocks: {}, meta: {}", (Object)numBlocks, (Object)metaArr.length);
            return false;
        }
        Block[] palette = this.readSchematicPalette(nbt);
        if (palette == null || palette.length == 0) {
            LOGGER.error("Schematic: Failed to read the block palette");
            return false;
        }
        BlockState[] blocksById = this.getSchematicBlocks(nbt, blockIdsByte, metaArr, numBlocks, palette);
        if (blocksById == null) {
            return false;
        }
        Map<BlockPos, CompoundNBT> tiles = this.getSchematicTiles(nbt);
        this.entities.clear();
        ListNBT tagList = nbt.func_150295_c("Entities", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT entityNBT = tagList.func_150305_b(i);
            ListNBT posList = entityNBT.func_150295_c("Pos", 6);
            Vec3d vec3d = new Vec3d(posList.func_150309_d(0), posList.func_150309_d(1), posList.func_150309_d(2));
            this.entities.add(new Template.EntityInfo(vec3d, new BlockPos(vec3d), entityNBT));
        }
        int index = 0;
        int sizeX = 1;
        int sizeY = 1;
        int sizeZ = 1;
        for (int y = 0; y < height; ++y) {
            for (int z = 0; z < length; ++z) {
                int x = 0;
                while (x < width) {
                    BlockState state = blocksById[index];
                    if (state.func_177230_c() != Blocks.field_150350_a) {
                        BlockPos pos = new BlockPos(x, y, z);
                        CompoundNBT teNBT = tiles.get(pos);
                        this.getBlocks().add(new Template.BlockInfo(pos, state, teNBT));
                        if (pos.func_177958_n() > sizeX) {
                            sizeX = pos.func_177958_n();
                        }
                        if (pos.func_177956_o() > sizeY) {
                            sizeY = pos.func_177956_o();
                        }
                        if (pos.func_177952_p() > sizeZ) {
                            sizeZ = pos.func_177952_p();
                        }
                    }
                    ++x;
                    ++index;
                }
            }
        }
        int size = Math.max(sizeX, Math.max(sizeY, sizeZ));
        if (size % 2 == 0) {
            ++size;
        }
        this.size = new BlockPos(size, size, size);
        return true;
    }

    private Map<BlockPos, CompoundNBT> getSchematicTiles(CompoundNBT nbt) {
        HashMap<BlockPos, CompoundNBT> tiles = new HashMap<BlockPos, CompoundNBT>();
        ListNBT tagList = nbt.func_150295_c("TileEntities", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT tag = tagList.func_150305_b(i);
            BlockPos pos = new BlockPos(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"));
            tiles.put(pos, tag);
        }
        return tiles;
    }

    @Nullable
    private BlockState[] getSchematicBlocks(CompoundNBT nbt, byte[] blockIdsByte, byte[] metaArr, int numBlocks, Block[] palette) {
        BlockState[] blocksById = new BlockState[numBlocks];
        if (nbt.func_150297_b("AddBlocks", 7)) {
            Block block;
            int byteId;
            int addValue;
            int expectedAddLength;
            byte[] add = nbt.func_74770_j("AddBlocks");
            if (add.length != (expectedAddLength = (int)Math.ceil((double)blockIdsByte.length / 2.0))) {
                LOGGER.error("Schematic: Add array size mismatch, blocks: {}, add: {}, expected add: {}", (Object)numBlocks, (Object)add.length, (Object)expectedAddLength);
                return null;
            }
            int loopMax = numBlocks % 2 == 0 ? numBlocks - 1 : numBlocks - 2;
            int bi = 0;
            int ai = 0;
            while (bi < loopMax) {
                addValue = add[ai] & 0xFF;
                byteId = blockIdsByte[bi] & 0xFF;
                block = palette[(addValue & 0xF0) << 4 | byteId];
                blocksById[bi] = block.func_176223_P();
                byteId = blockIdsByte[bi + 1] & 0xFF;
                block = palette[(addValue & 0xF) << 8 | byteId];
                blocksById[bi + 1] = block.func_176223_P();
                bi += 2;
                ++ai;
            }
            if (numBlocks % 2 != 0) {
                addValue = add[ai] & 0xFF;
                byteId = blockIdsByte[bi] & 0xFF;
                block = palette[(addValue & 0xF0) << 4 | byteId];
                blocksById[bi] = block.func_176223_P();
            }
        } else {
            if (nbt.func_150297_b("Add", 7)) {
                LOGGER.error("Schematic: Old Schematica format detected, not implemented");
                return null;
            }
            if (nbt.func_150297_b("Version", 3)) {
                LOGGER.error("Schematic: Newer Schematica format {} detected, not implemented", (Object)nbt.func_74762_e("Version"));
                return null;
            }
            for (int i = 0; i < numBlocks; ++i) {
                Block block = palette[blockIdsByte[i] & 0xFF];
                blocksById[i] = block.func_176223_P();
            }
        }
        return blocksById;
    }

    @Nullable
    private Block[] readSchematicPalette(CompoundNBT nbt) {
        Block air = Blocks.field_150350_a;
        Object[] palette = new Block[4096];
        Arrays.fill(palette, air);
        if (nbt.func_150297_b("SchematicaMapping", 10)) {
            CompoundNBT tag = nbt.func_74775_l("SchematicaMapping");
            Set keys = tag.func_150296_c();
            for (String key : keys) {
                short id = tag.func_74765_d(key);
                if (id >= palette.length) {
                    LOGGER.error("Schematic: Invalid ID '{}' in SchematicaMapping for block '{}', max = 4095", (Object)id, (Object)key);
                    return null;
                }
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(key));
                if (block != null) {
                    palette[id] = block;
                    continue;
                }
                LOGGER.error("Schematic: Missing/non-existing block '{}' in SchematicaMapping", (Object)key);
            }
        } else if (nbt.func_150297_b("BlockIDs", 10)) {
            CompoundNBT tag = nbt.func_74775_l("BlockIDs");
            Set keys = tag.func_150296_c();
            for (String idStr : keys) {
                int id;
                String key = tag.func_74779_i(idStr);
                try {
                    id = Integer.parseInt(idStr);
                }
                catch (NumberFormatException e) {
                    LOGGER.error("Schematic: Invalid ID '{}' (not a number) in MCEdit2 palette for block '{}'", (Object)idStr, (Object)key);
                    continue;
                }
                if (id >= palette.length) {
                    LOGGER.error("Schematic: Invalid ID '{}' in MCEdit2 palette for block '{}', max = 4095", (Object)id, (Object)key);
                    return null;
                }
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(key));
                if (block != null) {
                    palette[id] = block;
                    continue;
                }
                LOGGER.error("Schematic: Missing/non-existing block '{}' in MCEdit2 palette", (Object)key);
            }
        } else {
            for (Block block : ForgeRegistries.BLOCKS.getValues()) {
                if (block == null) continue;
                int id = Block.func_196246_j((BlockState)block.func_176223_P());
                if (id >= 0 && id < palette.length) {
                    palette[id] = block;
                    continue;
                }
                LOGGER.error("Schematic: Invalid ID {} for block '{}' from the registry", (Object)id, (Object)block.getRegistryName());
            }
        }
        return palette;
    }

    static class BasicPalette
    implements Iterable<BlockState> {
        public static final BlockState DEFAULT_BLOCK_STATE = Blocks.field_150350_a.func_176223_P();
        private final ObjectIntIdentityMap<BlockState> ids = new ObjectIntIdentityMap(16);
        private int lastId;

        private BasicPalette() {
        }

        public int idFor(BlockState state) {
            int i = this.ids.func_148747_b((Object)state);
            if (i == -1) {
                i = this.lastId++;
                this.ids.func_148746_a((Object)state, i);
            }
            return i;
        }

        @Nullable
        public BlockState stateFor(int id) {
            BlockState blockstate = (BlockState)this.ids.func_148745_a(id);
            return blockstate == null ? DEFAULT_BLOCK_STATE : blockstate;
        }

        @Override
        public Iterator<BlockState> iterator() {
            return this.ids.iterator();
        }

        public void addMapping(BlockState p_189956_1_, int p_189956_2_) {
            this.ids.func_148746_a((Object)p_189956_1_, p_189956_2_);
        }
    }
}

