/*
 * Decompiled with CFR 0.152.
 */
package capsule.structure;

import capsule.structure.CapsuleTemplate;
import com.google.common.collect.Maps;
import com.mojang.datafixers.DataFixer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.FileUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraft.util.datafix.DefaultTypeReferences;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CapsuleTemplateManager
implements ISelectiveResourceReloadListener {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<ResourceLocation, CapsuleTemplate> templates = Maps.newHashMap();
    private final DataFixer fixer;
    private final MinecraftServer minecraftServer;
    private final Path pathGenerated;

    public CapsuleTemplateManager(MinecraftServer server, File templateFolder, DataFixer fixerIn) {
        this.minecraftServer = server;
        this.fixer = fixerIn;
        this.pathGenerated = templateFolder.toPath().normalize();
        server.func_195570_aG().func_219534_a((IFutureReloadListener)this);
    }

    public CapsuleTemplate getTemplateDefaulted(ResourceLocation templateLocation) {
        ResourceLocation capsuleTemplateLocation = new ResourceLocation("capsule", templateLocation.func_110623_a());
        CapsuleTemplate template = this.getTemplate(capsuleTemplateLocation);
        if (template == null) {
            template = new CapsuleTemplate();
            this.templates.put(capsuleTemplateLocation, template);
        }
        return template;
    }

    @Nullable
    public CapsuleTemplate getTemplate(ResourceLocation templateLocation) {
        ResourceLocation capsuleTemplateLocation = new ResourceLocation("capsule", templateLocation.func_110623_a());
        return this.templates.computeIfAbsent(capsuleTemplateLocation, p_209204_1_ -> {
            CapsuleTemplate template = this.loadTemplateFile((ResourceLocation)p_209204_1_, ".schematics");
            if (template == null) {
                template = this.loadTemplateFile((ResourceLocation)p_209204_1_, ".nbt");
            }
            if (template == null) {
                template = this.loadTemplateResource((ResourceLocation)p_209204_1_, ".schematics");
            }
            if (template == null) {
                template = this.loadTemplateResource((ResourceLocation)p_209204_1_, ".nbt");
            }
            return template;
        });
    }

    public void func_195410_a(IResourceManager resourceManager) {
        this.templates.clear();
    }

    public void onResourceManagerReload(IResourceManager resourceManager, Predicate<IResourceType> resourcePredicate) {
        this.templates.clear();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private CapsuleTemplate loadTemplateResource(ResourceLocation p_209201_1_, String extension) {
        ResourceLocation capsuleTemplateLocation = new ResourceLocation("capsule", p_209201_1_.func_110623_a() + extension);
        try (IResource iresource = this.minecraftServer.func_195570_aG().func_199002_a(capsuleTemplateLocation);){
            CapsuleTemplate template;
            CapsuleTemplate capsuleTemplate = template = this.loadTemplate(iresource.func_199027_b(), ".schematics".equals(extension));
            return capsuleTemplate;
        }
        catch (FileNotFoundException var18) {
            return null;
        }
        catch (Throwable throwable6) {
            LOGGER.error("Couldn't load structure {}: {}", (Object)capsuleTemplateLocation, (Object)throwable6.toString());
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private CapsuleTemplate loadTemplateFile(ResourceLocation locationIn, String extension) {
        if (!this.pathGenerated.toAbsolutePath().toFile().isDirectory()) {
            return null;
        }
        Path path = this.resolvePath(locationIn, extension);
        try (FileInputStream inputstream = new FileInputStream(path.toFile());){
            CapsuleTemplate template;
            CapsuleTemplate capsuleTemplate = template = this.loadTemplate(inputstream, ".schematics".equals(extension));
            return capsuleTemplate;
        }
        catch (FileNotFoundException var18) {
            return null;
        }
        catch (IOException ioexception) {
            LOGGER.error("Couldn't load structure from {}", (Object)path, (Object)ioexception);
            return null;
        }
    }

    private CapsuleTemplate loadTemplate(InputStream inputStreamIn, Boolean isSchematic) throws IOException {
        if (isSchematic.booleanValue()) {
            return this.readTemplateFromSchematic(inputStreamIn);
        }
        CompoundNBT compoundnbt = CompressedStreamTools.func_74796_a((InputStream)inputStreamIn);
        return this.readFromNBT(compoundnbt);
    }

    public CapsuleTemplate readFromNBT(CompoundNBT p_227458_1_) {
        if (!p_227458_1_.func_150297_b("DataVersion", 99)) {
            p_227458_1_.func_74768_a("DataVersion", 500);
        }
        CapsuleTemplate template = new CapsuleTemplate();
        template.read(NBTUtil.func_210822_a((DataFixer)this.fixer, (DefaultTypeReferences)DefaultTypeReferences.STRUCTURE, (CompoundNBT)p_227458_1_, (int)p_227458_1_.func_74762_e("DataVersion")));
        return template;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean writeToFile(ResourceLocation templateName) {
        ResourceLocation capsuleTemplateLocation = new ResourceLocation("capsule", templateName.func_110623_a());
        CapsuleTemplate template = this.templates.get(capsuleTemplateLocation);
        if (template == null) {
            return false;
        }
        Path path = this.resolvePath(capsuleTemplateLocation, ".nbt");
        Path path1 = path.getParent();
        if (path1 == null) {
            return false;
        }
        try {
            Files.createDirectories(Files.exists(path1, new LinkOption[0]) ? path1.toRealPath(new LinkOption[0]) : path1, new FileAttribute[0]);
        }
        catch (IOException var19) {
            LOGGER.error("Failed to create parent directory: {}", (Object)path1);
            return false;
        }
        CompoundNBT compoundnbt = template.writeToNBT(new CompoundNBT());
        try (FileOutputStream outputstream = new FileOutputStream(path.toFile());){
            CompressedStreamTools.func_74799_a((CompoundNBT)compoundnbt, (OutputStream)outputstream);
            boolean bl = true;
            return bl;
        }
        catch (Throwable var21) {
            return false;
        }
    }

    private Path resolvePath(ResourceLocation locationIn, String extIn) {
        if (locationIn.func_110623_a().contains("//")) {
            throw new ResourceLocationException("Invalid resource path: " + locationIn);
        }
        String ext = locationIn.func_110623_a().endsWith(extIn) ? "" : extIn;
        Path p = this.pathGenerated.resolve(locationIn.func_110623_a() + ext);
        if (FileUtil.func_214995_a((Path)p) && FileUtil.func_214994_b((Path)p)) {
            return p;
        }
        throw new ResourceLocationException("Invalid resource path: " + p);
    }

    public void remove(ResourceLocation templateLocation) {
        ResourceLocation capsuleTemplateLocation = new ResourceLocation("capsule", templateLocation.func_110623_a());
        this.templates.remove(capsuleTemplateLocation);
    }

    public CapsuleTemplate readTemplateFromSchematic(InputStream inputstream) {
        try {
            CompoundNBT schematicNBT = CompressedStreamTools.func_74796_a((InputStream)inputstream);
            CapsuleTemplate template = new CapsuleTemplate();
            template.readSchematic(schematicNBT);
            CompoundNBT compoundnbt = template.writeToNBT(new CompoundNBT());
            return this.readFromNBT(compoundnbt);
        }
        catch (Throwable var10) {
            return null;
        }
    }

    public boolean deleteTemplate(ResourceLocation templateLocation) {
        ResourceLocation capsuleTemplateLocation = new ResourceLocation("capsule", templateLocation.func_110623_a());
        if (this.templates.containsKey(capsuleTemplateLocation)) {
            File file = this.resolvePath(capsuleTemplateLocation, ".nbt").toFile();
            boolean deleted = file.delete();
            if (deleted) {
                this.remove(capsuleTemplateLocation);
            }
            return deleted;
        }
        return false;
    }
}

