/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.ceilingtorch.compat.magicaltorches;

import bl4ckscor3.mod.ceilingtorch.compat.vanilla.CeilingTorchBlock;
import de.geheimagentnr1.magical_torches.elements.capabilities.ModCapabilities;
import de.geheimagentnr1.magical_torches.elements.capabilities.spawn_blocking.ISpawnBlockerFactory;
import de.geheimagentnr1.magical_torches.elements.capabilities.spawn_blocking.SpawnBlocker;
import de.geheimagentnr1.magical_torches.elements.capabilities.spawn_blocking.SpawnBlockingCapability;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.material.PushReaction;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class SpawnBlockingCeilingTorchBlock
extends CeilingTorchBlock
implements IWaterLoggable {
    private final ISpawnBlockerFactory spawnBlockerFactory;
    private final String name;
    private final VoxelShape shape;

    public SpawnBlockingCeilingTorchBlock(AbstractBlock.Properties properties, String spawnBlockRegistryName, ISpawnBlockerFactory spawnBlockerFactory, Supplier<Block> originalBlock) {
        super(properties, null, originalBlock);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false)));
        this.spawnBlockerFactory = spawnBlockerFactory;
        SpawnBlockingCapability.registerSpawnBlocker((ResourceLocation)new ResourceLocation("ceilingtorch", spawnBlockRegistryName), (ISpawnBlockerFactory)this.spawnBlockerFactory);
        switch (this.name = spawnBlockRegistryName) {
            case "small_torch": {
                this.shape = Block.func_208617_a((double)7.0, (double)6.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
                break;
            }
            case "medium_torch": {
                this.shape = Block.func_208617_a((double)6.5, (double)5.0, (double)6.5, (double)9.5, (double)16.0, (double)9.5);
                break;
            }
            case "grand_torch": {
                this.shape = Block.func_208617_a((double)6.0, (double)4.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
                break;
            }
            case "mega_torch": {
                this.shape = Block.func_208617_a((double)6.0, (double)3.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
                break;
            }
            default: {
                this.shape = VoxelShapes.func_197868_b();
            }
        }
    }

    @Override
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return this.shape;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197880_a();
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }

    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState oldState, boolean isMoving) {
        world.getCapability(ModCapabilities.SPAWN_BLOCKING).ifPresent(capability -> capability.addSpawnBlocker((SpawnBlocker)this.spawnBlockerFactory.build(pos)));
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        super.func_196243_a(state, world, pos, newState, isMoving);
        world.getCapability(ModCapabilities.SPAWN_BLOCKING).ifPresent(capability -> capability.removeSpawnBlocker((SpawnBlocker)this.spawnBlockerFactory.build(pos)));
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos pos = context.func_195995_a();
        BlockState state = context.func_195991_k().func_180495_p(pos);
        if (state.func_177230_c() == this) {
            return (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false));
        }
        return (BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(context.func_195991_k().func_204610_c(pos).func_206886_c() == Fluids.field_204546_a));
    }

    @Override
    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue()) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        return state;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208198_y});
    }
}

