/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.ceilingtorch.compat.torchbandolier;

import bl4ckscor3.mod.ceilingtorch.CeilingTorch;
import bl4ckscor3.mod.ceilingtorch.ICeilingTorchCompat;
import bl4ckscor3.mod.ceilingtorch.PlaceHandler;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.block.AirBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.silentchaos512.torchbandolier.init.ModItems;
import net.silentchaos512.torchbandolier.item.TorchBandolierItem;

public class TorchBandolierCompat
implements ICeilingTorchCompat {
    public TorchBandolierCompat() {
        MinecraftForge.EVENT_BUS.addListener(TorchBandolierCompat::onRightClickBlock);
    }

    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (event.getFace() == Direction.DOWN && event.getItemStack().func_77973_b() instanceof TorchBandolierItem) {
            ICeilingTorchCompat compat;
            Map<ResourceLocation, Block> placeEntries;
            String modid;
            PlayerEntity player = event.getPlayer();
            ItemStack stack = event.getItemStack();
            TorchBandolierItem bandolier = (TorchBandolierItem)stack.func_77973_b();
            Block torch = bandolier.getTorchBlock();
            boolean consumeTorch = player != null && !player.func_184812_l_();
            int torchCount = TorchBandolierItem.getTorchCount((ItemStack)stack);
            if (player == null || torch == null || torch instanceof AirBlock || torchCount <= 0 && consumeTorch) {
                return;
            }
            ResourceLocation rl = torch.func_199767_j().getRegistryName();
            Map<String, ICeilingTorchCompat> compatList = CeilingTorch.getCompatList();
            if (compatList.containsKey(modid = rl.func_110624_b()) && (placeEntries = (compat = compatList.get(modid)).getPlaceEntries()).containsKey(rl)) {
                Block block = placeEntries.get(rl);
                BlockPos pos = event.getPos();
                BlockState state = compat.getStateToPlace(stack, block);
                if (PlaceHandler.placeTorch(compat, event, ItemStack.field_190927_a, block, pos, pos.func_177972_a(event.getFace()), event.getWorld(), state)) {
                    if (consumeTorch) {
                        TorchBandolierItem.setTorchCount((ItemStack)stack, (int)(--torchCount));
                    }
                    if (torchCount == 0 && player != null) {
                        player.func_174820_d(TorchBandolierCompat.getSlotFor(stack, player.field_71071_by), new ItemStack((IItemProvider)ModItems.EMPTY_TORCH_BANDOLIER.get()));
                    }
                    event.setCancellationResult(ActionResultType.SUCCESS);
                    return;
                }
            }
        }
    }

    public static int getSlotFor(ItemStack stack1, PlayerInventory inv) {
        for (int i = 0; i < inv.field_70462_a.size(); ++i) {
            ItemStack stack2 = (ItemStack)inv.field_70462_a.get(i);
            if (stack2.func_190926_b() || stack1.func_77973_b() != stack2.func_77973_b() || !ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void registerBlocks(RegistryEvent.Register<Block> event) {
    }

    @Override
    public Map<ResourceLocation, Block> getPlaceEntries() {
        return ImmutableMap.of();
    }
}

