/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.base;

import com.lothrazar.cyclic.registry.BlockRegistry;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public abstract class BlockBase
extends Block {
    public static final BooleanProperty IS_LIT = BooleanProperty.func_177716_a((String)"lit");
    private boolean hasGui;

    private static boolean hasCapabilityDir(Direction facing, IWorld world, BlockPos facingPos, Capability<?> cap) {
        if (facing == null) {
            return false;
        }
        TileEntity neighbor = world.func_175625_s(facingPos);
        return neighbor != null && neighbor.getCapability(cap, facing.func_176734_d()).orElse(null) != null;
    }

    protected void setHasGui() {
        this.hasGui = true;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        if (this.hasGui && !world.field_72995_K) {
            TileEntity tileEntity = world.func_175625_s(pos);
            if (!(tileEntity instanceof INamedContainerProvider)) {
                throw new IllegalStateException("Our named container provider is missing!");
            }
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((INamedContainerProvider)tileEntity), (BlockPos)tileEntity.func_174877_v());
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(state, world, pos, player, hand, result);
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            IItemHandler items;
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity != null && (items = (IItemHandler)tileentity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null)) != null) {
                for (int i = 0; i < items.getSlots(); ++i) {
                    InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)items.getStackInSlot(i));
                }
                worldIn.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public static boolean isItem(BlockState stateIn, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        return BlockBase.hasCapabilityDir(facing, world, facingPos, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
    }

    public static boolean isFluid(BlockState stateIn, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        return BlockBase.hasCapabilityDir(facing, world, facingPos, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
    }

    public static boolean isEnergy(BlockState stateIn, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        return BlockBase.hasCapabilityDir(facing, world, facingPos, CapabilityEnergy.ENERGY);
    }

    public BlockBase(Block.Properties properties) {
        super(properties);
        BlockRegistry.blocks.add(this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        TranslationTextComponent t = new TranslationTextComponent(this.func_149739_a() + ".tooltip", new Object[0]);
        t.func_211708_a(TextFormatting.GRAY);
        tooltip.add((ITextComponent)t);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerClient() {
    }
}

