/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.autouser;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.autouser.ContainerUser;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.util.UtilEntity;
import com.lothrazar.cyclic.util.UtilFakePlayer;
import com.lothrazar.cyclic.util.UtilItemStack;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileUser
extends TileEntityBase
implements ITickableTileEntity,
INamedContainerProvider {
    private LazyOptional<IItemHandler> inventory = LazyOptional.of(this::createHandler);
    private WeakReference<FakePlayer> fakePlayer;
    private int timerDelay = 20;

    public TileUser() {
        super(BlockRegistry.Tiles.user);
    }

    public boolean hasFastRenderer() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void func_73660_a() {
        if (this.requiresRedstone() && !this.isPowered()) {
            return;
        }
        if (!(this.field_145850_b instanceof ServerWorld)) {
            return;
        }
        if (this.timer > 0) {
            --this.timer;
            return;
        }
        this.timer = this.timerDelay;
        this.setupBeforeTrigger((ServerWorld)this.field_145850_b);
        try {
            this.tryEquipItem();
            ActionResultType result = this.rightClickBlock(this.field_174879_c.func_177972_a(this.getCurrentFacing()));
            if (result != ActionResultType.SUCCESS) {
                // empty if block
            }
        }
        catch (Exception e) {
            ModCyclic.LOGGER.error("User action item error", (Throwable)e);
        }
        this.tryDumpFakePlayerInvo(false);
    }

    private void tryDumpFakePlayerInvo(boolean includeMainHand) {
        int start = includeMainHand ? 0 : 1;
        ArrayList<ItemStack> toDrop = new ArrayList<ItemStack>();
        for (int i = start; i < ((FakePlayer)this.fakePlayer.get()).field_71071_by.field_70462_a.size(); ++i) {
            ItemStack s = (ItemStack)((FakePlayer)this.fakePlayer.get()).field_71071_by.field_70462_a.get(i);
            if (s.func_190926_b()) continue;
            toDrop.add(s.func_77946_l());
            ((FakePlayer)this.fakePlayer.get()).field_71071_by.field_70462_a.set(i, (Object)ItemStack.field_190927_a);
        }
        UtilItemStack.drop(this.field_145850_b, this.field_174879_c.func_177984_a(), toDrop);
    }

    private ActionResultType rightClickBlock(BlockPos targetPos) throws Exception {
        Hand hand = Hand.MAIN_HAND;
        BlockRayTraceResult blockraytraceresult = new BlockRayTraceResult(((FakePlayer)this.fakePlayer.get()).func_70040_Z(), ((FakePlayer)this.fakePlayer.get()).func_184172_bi(), targetPos, true);
        ActionResultType result = ((FakePlayer)this.fakePlayer.get()).field_71134_c.func_219441_a((PlayerEntity)this.fakePlayer.get(), this.field_145850_b, ((FakePlayer)this.fakePlayer.get()).func_184586_b(hand), hand, blockraytraceresult);
        return result;
    }

    private void setupBeforeTrigger(ServerWorld sw) {
        if (this.fakePlayer == null) {
            this.fakePlayer = UtilFakePlayer.initFakePlayer(sw, UUID.randomUUID(), "user");
            if (this.fakePlayer == null) {
                ModCyclic.LOGGER.error("Fake player failed to init ");
                return;
            }
            ((FakePlayer)this.fakePlayer.get()).func_70107_b((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p());
            ((FakePlayer)this.fakePlayer.get()).field_70177_z = UtilEntity.getYawFromFacing(this.getCurrentFacing());
        }
    }

    private void tryEquipItem() {
        this.inventory.ifPresent(inv -> {
            ItemStack maybeTool = inv.getStackInSlot(0);
            if (!maybeTool.func_190926_b() && maybeTool.func_190916_E() <= 0) {
                maybeTool = ItemStack.field_190927_a;
            }
            if (!maybeTool.equals(((FakePlayer)this.fakePlayer.get()).func_184586_b(Hand.MAIN_HAND))) {
                ((FakePlayer)this.fakePlayer.get()).func_184611_a(Hand.MAIN_HAND, maybeTool);
            }
        });
    }

    private Direction getCurrentFacing() {
        return (Direction)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockStateProperties.field_208155_H);
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                this.setNeedsRedstone(value);
                break;
            }
            case TIMER: {
                this.timer = value;
                break;
            }
            case TIMERDEL: {
                this.timerDelay = value;
                break;
            }
        }
    }

    @Override
    public int getField(int field) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                return this.getNeedsRedstone();
            }
            case TIMER: {
                return this.timer;
            }
            case TIMERDEL: {
                return this.timerDelay;
            }
        }
        return 0;
    }

    private IItemHandler createHandler() {
        return new ItemStackHandler(1);
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventory.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void func_145839_a(CompoundNBT tag) {
        this.timerDelay = tag.func_74762_e("delay");
        this.inventory.ifPresent(h -> ((INBTSerializable)h).deserializeNBT((INBT)tag.func_74775_l("inv")));
        super.func_145839_a(tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_74768_a("delay", this.timerDelay);
        this.inventory.ifPresent(h -> {
            CompoundNBT compound = (CompoundNBT)((INBTSerializable)h).serializeNBT();
            tag.func_218657_a("inv", (INBT)compound);
        });
        return super.func_189515_b(tag);
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerUser(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity);
    }

    public static enum Fields {
        REDSTONE,
        TIMER,
        TIMERDEL;

    }
}

