/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.cable.item;

import com.google.common.collect.Maps;
import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.cable.CableBase;
import com.lothrazar.cyclic.block.cable.DirectionNullable;
import com.lothrazar.cyclic.block.cable.fluid.BlockCableFluid;
import com.lothrazar.cyclic.registry.BlockRegistry;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileCableItem
extends TileEntityBase
implements ITickableTileEntity {
    private Map<Direction, LazyOptional<IItemHandler>> flow = Maps.newHashMap();
    List<Integer> rawList = IntStream.rangeClosed(0, 5).boxed().collect(Collectors.toList());

    public TileCableItem() {
        super(BlockRegistry.Tiles.item_pipeTile);
        for (Direction f : Direction.values()) {
            this.flow.put(f, (LazyOptional<IItemHandler>)LazyOptional.of(this::createHandler));
        }
    }

    private IItemHandler createHandler() {
        ItemStackHandler h = new ItemStackHandler(1);
        return h;
    }

    public void func_73660_a() {
        this.tryExtract();
        this.normalFlow();
    }

    private void tryExtract() {
        IItemHandler itemHandlerFrom;
        Direction importFromSide = ((DirectionNullable)((Object)this.func_195044_w().func_177229_b((IProperty)BlockCableFluid.EXTR))).direction();
        if (importFromSide == null) {
            return;
        }
        IItemHandler sideHandler = (IItemHandler)this.flow.get(importFromSide).orElse(null);
        if (importFromSide == null || !sideHandler.getStackInSlot(0).func_190926_b()) {
            return;
        }
        BlockPos posTarget = this.field_174879_c.func_177972_a(importFromSide);
        TileEntity tile = this.field_145850_b.func_175625_s(posTarget);
        if (tile != null && (itemHandlerFrom = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, importFromSide.func_176734_d()).orElse(null)) != null) {
            for (int i = 0; i < itemHandlerFrom.getSlots(); ++i) {
                ItemStack itemTarget = itemHandlerFrom.extractItem(i, 64, true);
                if (itemTarget.func_190926_b() || itemTarget.func_190926_b()) continue;
                itemTarget = itemHandlerFrom.extractItem(i, 64, false);
                ItemStack result = sideHandler.insertItem(0, itemTarget.func_77946_l(), false);
                itemTarget.func_190920_e(result.func_190916_E());
                return;
            }
        }
    }

    private void normalFlow() {
        Direction importFromSide = ((DirectionNullable)((Object)this.func_195044_w().func_177229_b((IProperty)BlockCableFluid.EXTR))).direction();
        for (Direction incomingSide : Direction.values()) {
            IItemHandler sideHandler = (IItemHandler)this.flow.get(incomingSide).orElse(null);
            Collections.shuffle(this.rawList);
            for (Integer i : this.rawList) {
                Direction outgoingSide = Direction.values()[i];
                if (outgoingSide == incomingSide || importFromSide != null && importFromSide == outgoingSide) continue;
                this.moveItems(outgoingSide, 64, sideHandler);
            }
        }
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (side != null && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && !CableBase.isCableBlocked(this.func_195044_w(), side)) {
            return this.flow.get(side).cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void func_145839_a(CompoundNBT tag) {
        for (Direction f : Direction.values()) {
            LazyOptional<IItemHandler> item = this.flow.get(f);
            item.ifPresent(h -> {
                CompoundNBT itemTag = tag.func_74775_l("item" + f.toString());
                ((INBTSerializable)h).deserializeNBT((INBT)itemTag);
            });
        }
        super.func_145839_a(tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        for (Direction f : Direction.values()) {
            LazyOptional<IItemHandler> item = this.flow.get(f);
            item.ifPresent(h -> {
                CompoundNBT compound = (CompoundNBT)((INBTSerializable)h).serializeNBT();
                tag.func_218657_a("item" + f.toString(), (INBT)compound);
            });
        }
        return super.func_189515_b(tag);
    }

    @Override
    public void setField(int field, int value) {
    }
}

