/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.collectfluid;

import com.lothrazar.cyclic.base.FluidTankBase;
import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.collectfluid.ContainerFluidCollect;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.util.UtilShape;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.IFluidState;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileFluidCollect
extends TileEntityBase
implements ITickableTileEntity,
INamedContainerProvider {
    public static final int CAPACITY = 64000;
    FluidTankBase tank;
    private final LazyOptional<FluidTankBase> tankWrapper = LazyOptional.of(() -> this.tank);
    private LazyOptional<IItemHandler> inventory = LazyOptional.of(this::createHandler);
    private int shapeIndex = 0;
    private int size = 8;
    private int height = 16;

    public TileFluidCollect() {
        super(BlockRegistry.Tiles.collector_fluid);
        this.tank = new FluidTankBase(this, 64000, this.isFluidValid());
        this.needsRedstone = 1;
        this.renderParticles = 1;
    }

    public Predicate<FluidStack> isFluidValid() {
        return p -> true;
    }

    public FluidStack getFluid() {
        return this.tank == null ? FluidStack.EMPTY : this.tank.getFluid();
    }

    private IItemHandler createHandler() {
        return new ItemStackHandler(1);
    }

    public List<BlockPos> getShape() {
        List<BlockPos> shape = UtilShape.squareHorizontalHollow(this.field_174879_c.func_177979_c(this.height), this.size);
        shape = UtilShape.repeatShapeByHeight(shape, this.height - 1);
        return shape;
    }

    public List<BlockPos> getShapeFilled() {
        List<BlockPos> shape = UtilShape.squareHorizontalFull(this.field_174879_c.func_177979_c(this.height), this.size);
        shape = UtilShape.repeatShapeByHeight(shape, this.height - 1);
        return shape;
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerFluidCollect(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity);
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventory.cast();
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.tankWrapper.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void func_145839_a(CompoundNBT tag) {
        this.shapeIndex = tag.func_74762_e("shapeIndex");
        this.tank.readFromNBT(tag.func_74775_l("fluid"));
        this.inventory.ifPresent(h -> ((INBTSerializable)h).deserializeNBT((INBT)tag.func_74775_l("inv")));
        super.func_145839_a(tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        this.inventory.ifPresent(h -> {
            CompoundNBT compound = (CompoundNBT)((INBTSerializable)h).serializeNBT();
            tag.func_218657_a("inv", (INBT)compound);
        });
        CompoundNBT fluid = new CompoundNBT();
        this.tank.writeToNBT(fluid);
        tag.func_218657_a("fluid", (INBT)fluid);
        tag.func_74768_a("shapeIndex", this.shapeIndex);
        return super.func_189515_b(tag);
    }

    public void func_73660_a() {
        if (this.requiresRedstone() && !this.isPowered()) {
            return;
        }
        this.inventory.ifPresent(inv -> {
            FluidStack fstack;
            int result;
            ItemStack stack = inv.getStackInSlot(0);
            if (stack.func_190926_b() || Block.func_149634_a((Item)stack.func_77973_b()) == Blocks.field_150350_a) {
                return;
            }
            List<BlockPos> shape = this.getShapeFilled();
            if (shape.size() == 0) {
                return;
            }
            this.incrementShapePtr(shape);
            BlockPos posTarget = shape.get(this.shapeIndex);
            IFluidState fluidState = this.field_145850_b.func_204610_c(posTarget);
            for (int ff = 0; ff < 20 && !fluidState.func_206889_d(); ++ff) {
                this.incrementShapePtr(shape);
                posTarget = shape.get(this.shapeIndex);
                fluidState = this.field_145850_b.func_204610_c(posTarget);
            }
            if (fluidState.func_206889_d() && (result = this.tank.fill(fstack = new FluidStack(fluidState.func_206886_c(), 1000), IFluidHandler.FluidAction.SIMULATE)) == 1000 && this.field_145850_b.func_175656_a(posTarget, Block.func_149634_a((Item)stack.func_77973_b()).func_176223_P())) {
                stack.func_190918_g(1);
                this.tank.fill(fstack, IFluidHandler.FluidAction.EXECUTE);
            }
        });
    }

    private void incrementShapePtr(List<BlockPos> shape) {
        ++this.shapeIndex;
        if (this.shapeIndex < 0 || this.shapeIndex >= shape.size()) {
            this.shapeIndex = 0;
        }
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                this.setNeedsRedstone(value);
                break;
            }
            case RENDER: {
                this.renderParticles = value % 2;
            }
        }
    }

    @Override
    public int getField(int field) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                return this.getNeedsRedstone();
            }
            case RENDER: {
                return this.renderParticles;
            }
        }
        return 0;
    }

    public static enum Fields {
        REDSTONE,
        RENDER;

    }
}

