/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.creativebattery;

import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.capability.CustomEnergyStorage;
import com.lothrazar.cyclic.registry.BlockRegistry;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class TileBatteryInfinite
extends TileEntityBase
implements ITickableTileEntity {
    static final int MAX = 6400000;
    private Map<Direction, Boolean> poweredSides;
    private LazyOptional<IEnergyStorage> energy = LazyOptional.of(this::createEnergy);
    private List<Integer> rawList = IntStream.rangeClosed(0, 5).boxed().collect(Collectors.toList());

    public TileBatteryInfinite() {
        super(BlockRegistry.Tiles.battery_infinite);
        this.poweredSides = new HashMap<Direction, Boolean>();
        for (Direction f : Direction.values()) {
            this.poweredSides.put(f, true);
        }
    }

    public boolean getSideHasPower(Direction side) {
        return this.poweredSides.get(side);
    }

    public int getSideField(Direction side) {
        return this.getSideHasPower(side) ? 1 : 0;
    }

    public void setSideField(Direction side, int pow) {
        this.poweredSides.put(side, pow == 1);
    }

    private IEnergyStorage createEnergy() {
        return new CustomEnergyStorage(6400000, 1600000);
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energy.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void func_145839_a(CompoundNBT tag) {
        for (Direction f : Direction.values()) {
            this.poweredSides.put(f, tag.func_74767_n("flow_" + f.func_176742_j()));
        }
        this.energy.ifPresent(h -> ((INBTSerializable)h).deserializeNBT((INBT)tag.func_74775_l("energy")));
        super.func_145839_a(tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        for (Direction f : Direction.values()) {
            tag.func_74757_a("flow_" + f.func_176742_j(), this.poweredSides.get(f).booleanValue());
        }
        this.energy.ifPresent(h -> {
            CompoundNBT compound = (CompoundNBT)((INBTSerializable)h).serializeNBT();
            tag.func_218657_a("energy", (INBT)compound);
        });
        return super.func_189515_b(tag);
    }

    public ITextComponent getDisplayName() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    public void func_73660_a() {
        IEnergyStorage handlerHere = (IEnergyStorage)this.getCapability(CapabilityEnergy.ENERGY, null).orElse(null);
        if (handlerHere == null) {
            return;
        }
        handlerHere.receiveEnergy(1600000, false);
        this.tickCableFlow();
    }

    private void tickCableFlow() {
        Collections.shuffle(this.rawList);
        for (Integer i : this.rawList) {
            Direction exportToSide = Direction.values()[i];
            if (!this.poweredSides.get(exportToSide).booleanValue()) continue;
            this.moveEnergy(exportToSide, 1600000);
        }
    }

    @Override
    public int getField(int id) {
        switch (Fields.values()[id]) {
            case D: {
                return this.getSideField(Direction.DOWN);
            }
            case E: {
                return this.getSideField(Direction.EAST);
            }
            case N: {
                return this.getSideField(Direction.NORTH);
            }
            case S: {
                return this.getSideField(Direction.SOUTH);
            }
            case U: {
                return this.getSideField(Direction.UP);
            }
            case W: {
                return this.getSideField(Direction.WEST);
            }
        }
        return -1;
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case D: {
                this.setSideField(Direction.DOWN, value % 2);
                break;
            }
            case E: {
                this.setSideField(Direction.EAST, value % 2);
                break;
            }
            case N: {
                this.setSideField(Direction.NORTH, value % 2);
                break;
            }
            case S: {
                this.setSideField(Direction.SOUTH, value % 2);
                break;
            }
            case U: {
                this.setSideField(Direction.UP, value % 2);
                break;
            }
            case W: {
                this.setSideField(Direction.WEST, value % 2);
            }
        }
    }

    static enum Fields {
        N,
        E,
        S,
        W,
        U,
        D;

    }
}

