/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.disenchant;

import com.google.common.collect.Maps;
import com.lothrazar.cyclic.ConfigManager;
import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.disenchant.ContainerDisenchant;
import com.lothrazar.cyclic.capability.CustomEnergyStorage;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.util.UtilSound;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileDisenchant
extends TileEntityBase
implements INamedContainerProvider,
ITickableTileEntity {
    private LazyOptional<IItemHandler> inventory = LazyOptional.of(this::createHandler);
    private LazyOptional<IEnergyStorage> energy = LazyOptional.of(this::createEnergy);
    static final int MAX = 640000;
    private static final int SLOT_INPUT = 0;
    private static final int SLOT_BOOK = 1;
    private static final int SLOT_OUT = 2;

    public TileDisenchant() {
        super(BlockRegistry.Tiles.disenchanter);
    }

    private IItemHandler createHandler() {
        return new ItemStackHandler(3){

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                if (slot == 1) {
                    return stack.func_77973_b() == Items.field_151122_aG;
                }
                if (slot == 0) {
                    Map enchants = EnchantmentHelper.func_82781_a((ItemStack)stack);
                    return enchants != null && enchants.size() > 0;
                }
                return stack.func_77973_b() == Items.field_151134_bR;
            }
        };
    }

    private IEnergyStorage createEnergy() {
        return new CustomEnergyStorage(640000, 160000);
    }

    public int getEnergy() {
        return (Integer)this.getCapability(CapabilityEnergy.ENERGY).map(IEnergyStorage::getEnergyStored).orElse((Object)0);
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerDisenchant(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity);
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventory.cast();
        }
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energy.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void func_145839_a(CompoundNBT tag) {
        this.energy.ifPresent(h -> ((INBTSerializable)h).deserializeNBT((INBT)tag.func_74775_l("energy")));
        this.inventory.ifPresent(h -> ((INBTSerializable)h).deserializeNBT((INBT)tag.func_74775_l("inv")));
        super.func_145839_a(tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        this.inventory.ifPresent(h -> {
            CompoundNBT compound = (CompoundNBT)((INBTSerializable)h).serializeNBT();
            tag.func_218657_a("inv", (INBT)compound);
        });
        this.energy.ifPresent(h -> {
            CompoundNBT compound = (CompoundNBT)((INBTSerializable)h).serializeNBT();
            tag.func_218657_a("energy", (INBT)compound);
        });
        return super.func_189515_b(tag);
    }

    public void func_73660_a() {
        if (this.requiresRedstone() && !this.isPowered()) {
            return;
        }
        IEnergyStorage cap = (IEnergyStorage)this.energy.orElse(null);
        if (cap == null) {
            return;
        }
        if (cap.getEnergyStored() < (Integer)ConfigManager.DISENCHANTERPOWER.get()) {
            return;
        }
        this.inventory.ifPresent(inv -> {
            ItemStack input = inv.getStackInSlot(0);
            ItemStack book = inv.getStackInSlot(1);
            if (book.func_77973_b() != Items.field_151122_aG || !inv.getStackInSlot(2).func_190926_b() || input.func_190916_E() != 1) {
                return;
            }
            LinkedHashMap outEnchants = Maps.newLinkedHashMap();
            Map enchants = EnchantmentHelper.func_82781_a((ItemStack)input);
            Enchantment keyMoved = null;
            Iterator iterator = enchants.entrySet().iterator();
            if (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                keyMoved = (Enchantment)entry.getKey();
                outEnchants.put(keyMoved, entry.getValue());
            }
            if (outEnchants.size() == 0 || keyMoved == null) {
                return;
            }
            UtilSound.playSound(this.field_145850_b, this.field_174879_c, SoundEvents.field_190021_aL);
            cap.extractEnergy(((Integer)ConfigManager.DISENCHANTERPOWER.get()).intValue(), true);
            enchants.remove(keyMoved);
            ItemStack eBook = new ItemStack((IItemProvider)Items.field_151134_bR);
            EnchantmentHelper.func_82782_a((Map)outEnchants, (ItemStack)eBook);
            inv.extractItem(1, 1, false);
            inv.insertItem(2, eBook, false);
            if (input.func_77973_b() == Items.field_151134_bR && enchants.size() == 0) {
                inv.extractItem(0, 64, false);
                inv.insertItem(0, new ItemStack((IItemProvider)Items.field_151122_aG), false);
            } else if (input.func_77973_b() == Items.field_151134_bR) {
                ItemStack inputCopy = new ItemStack((IItemProvider)Items.field_151134_bR);
                EnchantmentHelper.func_82782_a((Map)enchants, (ItemStack)inputCopy);
                inv.extractItem(0, 64, false);
                inv.insertItem(0, inputCopy, false);
            } else {
                EnchantmentHelper.func_82782_a((Map)enchants, (ItemStack)input);
            }
        });
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                this.setNeedsRedstone(value);
            }
        }
    }

    @Override
    public int getField(int field) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                return this.getNeedsRedstone();
            }
        }
        return 0;
    }

    public static enum Fields {
        REDSTONE;

    }
}

