/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.fan;

import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.fan.BlockFan;
import com.lothrazar.cyclic.net.PacketPlayerFalldamage;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.registry.PacketRegistry;
import com.lothrazar.cyclic.util.UtilShape;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

public class TileFan
extends TileEntityBase
implements ITickableTileEntity {
    private int range = 7;
    private int speed = 5;
    private static final int MIN_RANGE = 1;

    public TileFan() {
        super(BlockRegistry.Tiles.fantile);
    }

    public void func_73660_a() {
        if (!this.isPowered()) {
            this.setAnimation(false);
            return;
        }
        this.setAnimation(true);
        this.pushEntities();
    }

    private void setAnimation(boolean lit) {
        BlockState st = this.field_145850_b.func_180495_p(this.field_174879_c);
        boolean previous = (Boolean)st.func_177229_b((IProperty)BlockFan.IS_LIT);
        if (previous != lit) {
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)st.func_206870_a((IProperty)BlockFan.IS_LIT, (Comparable)Boolean.valueOf(lit)));
        }
    }

    public int getRange() {
        return this.range;
    }

    private float getSpeedCalc() {
        return (float)this.speed / 35.0f;
    }

    private int getCurrentRange() {
        Direction facing = this.getCurrentFacing();
        for (int i = 1; i <= this.getRange(); ++i) {
            BlockPos tester = this.func_174877_v().func_177967_a(facing, i);
            if (this.canBlowThrough(tester)) continue;
            return i;
        }
        return this.getRange();
    }

    private boolean canBlowThrough(BlockPos tester) {
        return this.func_145831_w().func_175623_d(tester);
    }

    public List<BlockPos> getShape() {
        return UtilShape.line(this.func_174877_v(), this.getCurrentFacing(), this.getCurrentRange());
    }

    private Direction getCurrentFacing() {
        return (Direction)this.func_195044_w().func_177229_b((IProperty)BlockStateProperties.field_208155_H);
    }

    private int pushEntities() {
        List<BlockPos> shape = this.getShape();
        if (shape.size() == 0) {
            return 0;
        }
        BlockPos start = shape.get(0);
        BlockPos end = shape.get(shape.size() - 1);
        switch (this.getCurrentFacing().func_176740_k()) {
            case X: {
                end = end.func_177982_a(0, 0, 1);
                end = end.func_177982_a(0, 1, 0);
                break;
            }
            case Z: {
                end = end.func_177982_a(1, 0, 0);
                end = end.func_177982_a(0, 1, 0);
                break;
            }
            case Y: {
                start = start.func_177982_a(1, 0, 0);
                end = end.func_177982_a(0, 0, 1);
            }
        }
        Direction face = this.getCurrentFacing();
        switch (face) {
            case NORTH: {
                start = start.func_177968_d();
                break;
            }
            case SOUTH: {
                end = end.func_177968_d();
                break;
            }
            case EAST: {
                end = end.func_177974_f();
                break;
            }
            case WEST: {
                start = start.func_177974_f();
                break;
            }
            case DOWN: {
                break;
            }
        }
        AxisAlignedBB region = new AxisAlignedBB(start, end);
        List entitiesFound = this.func_145831_w().func_217357_a(Entity.class, region);
        int moved = 0;
        boolean doPush = true;
        int direction = 1;
        float SPEED = this.getSpeedCalc();
        for (Entity entity : entitiesFound) {
            if (entity instanceof PlayerEntity && ((PlayerEntity)entity).func_213453_ef()) continue;
            ++moved;
            double newx = entity.func_213322_ci().func_82615_a();
            double newy = entity.func_213322_ci().func_82617_b();
            double newz = entity.func_213322_ci().func_82616_c();
            switch (face) {
                case NORTH: {
                    direction = !doPush ? 1 : -1;
                    newz += (double)((float)direction * SPEED);
                    break;
                }
                case SOUTH: {
                    direction = doPush ? 1 : -1;
                    newz += (double)((float)direction * SPEED);
                    break;
                }
                case EAST: {
                    direction = doPush ? 1 : -1;
                    newx += (double)((float)direction * SPEED);
                    break;
                }
                case WEST: {
                    direction = !doPush ? 1 : -1;
                    newx += (double)((float)direction * SPEED);
                    break;
                }
                case DOWN: {
                    direction = !doPush ? 1 : -1;
                    newy += (double)((float)direction * SPEED);
                    break;
                }
                case UP: {
                    direction = doPush ? 1 : -1;
                    newy += (double)((float)direction * SPEED);
                }
            }
            entity.func_213293_j(newx, newy, newz);
            if (!this.field_145850_b.field_72995_K || entity.field_70173_aa % 22 != 0 || !(entity instanceof PlayerEntity)) continue;
            PacketRegistry.INSTANCE.sendToServer((Object)new PacketPlayerFalldamage());
        }
        return moved;
    }

    @Override
    public void setField(int field, int value) {
    }
}

